/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlElementFactoryImpl
extends XmlElementFactory {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(XmlElementFactoryImpl.class);

    public XmlElementFactoryImpl(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public XmlTag createTagFromText(@NotNull @NonNls CharSequence text, @NotNull Language language) throws IncorrectOperationException {
        XmlDocument document;
        XmlTag tag;
        assert (language instanceof XMLLanguage) : "Tag can be created only for xml language";
        LanguageFileType type2 = language.getAssociatedFileType();
        if (type2 == null) {
            type2 = XmlFileType.INSTANCE;
        }
        if ((tag = (document = this.createXmlDocument(text, "dummy." + type2.getDefaultExtension(), (FileType)type2)).getRootTag()) == null) {
            throw new IncorrectOperationException("Incorrect tag text");
        }
        return tag;
    }

    @NotNull
    public XmlTag createTagFromText(@NotNull CharSequence text) throws IncorrectOperationException {
        return this.createTagFromText(text, (Language)XMLLanguage.INSTANCE);
    }

    @NotNull
    public XmlAttribute createXmlAttribute(@NotNull String name, @NotNull String value2) throws IncorrectOperationException {
        return this.createAttribute(name, value2, (FileType)XmlFileType.INSTANCE);
    }

    @NotNull
    public XmlAttribute createAttribute(@NotNull @NonNls String name, @NotNull String value2, @Nullable PsiElement context) throws IncorrectOperationException {
        return this.createAttribute(name, value2, (FileType)(PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false) instanceof HtmlTag ? HtmlFileType.INSTANCE : XmlFileType.INSTANCE));
    }

    @NotNull
    private XmlAttribute createAttribute(@NotNull String name, @NotNull String value2, @NotNull FileType fileType) {
        char quoteChar;
        if (!value2.contains("\"")) {
            quoteChar = '\"';
        } else if (!value2.contains("'")) {
            quoteChar = '\'';
        } else {
            quoteChar = '\"';
            value2 = StringUtil.replace((String)value2, (String)"\"", (String)"&quot;");
        }
        XmlDocument document = this.createXmlDocument("<tag " + name + "=" + quoteChar + value2 + quoteChar + "/>", "dummy.xml", fileType);
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        XmlAttribute[] attributes = tag.getAttributes();
        LOG.assertTrue(attributes.length == 1, (Object)document.getText());
        return attributes[0];
    }

    @NotNull
    public XmlText createDisplayText(@NotNull String s) throws IncorrectOperationException {
        XmlTag tagFromText = this.createTagFromText("<a>" + XmlTagUtil.getCDATAQuote((String)s) + "</a>");
        XmlText[] textElements = tagFromText.getValue().getTextElements();
        if (textElements.length == 0) {
            return (XmlText)ASTFactory.composite(XmlElementType.XML_TEXT);
        }
        return textElements[0];
    }

    @NotNull
    public XmlTag createXHTMLTagFromText(@NotNull String text) throws IncorrectOperationException {
        XmlDocument document = this.createXmlDocument(text, "dummy.xhtml", (FileType)XHtmlFileType.INSTANCE);
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        return tag;
    }

    @NotNull
    public XmlTag createHTMLTagFromText(@NotNull String text) throws IncorrectOperationException {
        XmlDocument document = this.createXmlDocument(text, "dummy.html", (FileType)HtmlFileType.INSTANCE);
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        return tag;
    }

    private XmlDocument createXmlDocument(@NonNls CharSequence text, @NonNls String fileName, FileType fileType) {
        XmlFile xmlFile;
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, fileType, text);
        if (fileFromText instanceof XmlFile) {
            xmlFile = (XmlFile)fileFromText;
        } else {
            xmlFile = (XmlFile)fileFromText.getViewProvider().getPsi(((LanguageFileType)fileType).getLanguage());
            assert (xmlFile != null);
        }
        XmlDocument document = xmlFile.getDocument();
        assert (document != null);
        return document;
    }
}

