/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.psi.PsiField;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntryDependencyInfo;
import com.intellij.psi.codeStyle.arrangement.JavaElementArrangementEntry;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FieldDependenciesManager {
    private final Map<PsiField, Set<PsiField>> myFieldDependencies;
    private final Map<PsiField, ArrangementEntryDependencyInfo> myFieldInfosMap = ContainerUtil.newHashMap();

    public FieldDependenciesManager(@NotNull Map<PsiField, Set<PsiField>> fieldDependencies, @NotNull Map<PsiField, JavaElementArrangementEntry> fields) {
        this.myFieldDependencies = fieldDependencies;
        for (PsiField field : fields.keySet()) {
            JavaElementArrangementEntry entry = fields.get(field);
            this.myFieldInfosMap.put(field, new ArrangementEntryDependencyInfo(entry));
        }
    }

    @NotNull
    public List<ArrangementEntryDependencyInfo> getRoots() {
        ArrayList list = ContainerUtil.newArrayList();
        for (Map.Entry<PsiField, Set<PsiField>> entry : this.myFieldDependencies.entrySet()) {
            ArrangementEntryDependencyInfo currentInfo = this.myFieldInfosMap.get(entry.getKey());
            for (PsiField usedInInitialization : entry.getValue()) {
                ArrangementEntryDependencyInfo fieldInfo = this.myFieldInfosMap.get(usedInInitialization);
                if (fieldInfo == null) continue;
                currentInfo.addDependentEntryInfo(fieldInfo);
            }
            list.add(currentInfo);
        }
        return list;
    }
}

