/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.AnalysisCanceledSoftException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowImpl;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowStack;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.EmptyInstruction;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.controlFlow.ControlFlowAnalyzer");
    private final PsiElement myCodeFragment;
    private final ControlFlowPolicy myPolicy;
    private ControlFlowImpl myCurrentFlow;
    private final ControlFlowStack myStack = new ControlFlowStack();
    private final Stack<PsiParameter> myCatchParameters = new Stack();
    private final Stack<PsiElement> myCatchBlocks = new Stack();
    private final Stack<FinallyBlockSubroutine> myFinallyBlocks = new Stack();
    private final Stack<PsiElement> myUnhandledExceptionCatchBlocks = new Stack();
    private final StatementStack myStartStatementStack = new StatementStack();
    private final StatementStack myEndStatementStack = new StatementStack();
    private final Stack<BranchingInstruction.Role> myStartJumpRoles = new Stack();
    private final Stack<BranchingInstruction.Role> myEndJumpRoles = new Stack();
    private final boolean myEnabledShortCircuit;
    private final boolean myEvaluateConstantIfCondition;
    private final boolean myAssignmentTargetsAreElements;
    private final Stack<TIntArrayList> intArrayPool = new Stack();
    private final Map<PsiElement, TIntArrayList> offsetsAddElementStart = new THashMap();
    private final Map<PsiElement, TIntArrayList> offsetsAddElementEnd = new THashMap();
    private final ControlFlowFactory myControlFlowFactory;
    private final Map<PsiElement, ControlFlowSubRange> mySubRanges = new THashMap();
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final Map<PsiElement, List<PsiElement>> finallyBlockToUnhandledExceptions = new HashMap<PsiElement, List<PsiElement>>();

    ControlFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull ControlFlowPolicy policy, boolean enabledShortCircuit, boolean evaluateConstantIfCondition) {
        this(codeFragment, policy, enabledShortCircuit, evaluateConstantIfCondition, false);
    }

    private ControlFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull ControlFlowPolicy policy, boolean enabledShortCircuit, boolean evaluateConstantIfCondition, boolean assignmentTargetsAreElements) {
        this.myCodeFragment = codeFragment;
        this.myPolicy = policy;
        this.myEnabledShortCircuit = enabledShortCircuit;
        this.myEvaluateConstantIfCondition = evaluateConstantIfCondition;
        this.myAssignmentTargetsAreElements = assignmentTargetsAreElements;
        Project project2 = codeFragment.getProject();
        this.myControlFlowFactory = ControlFlowFactory.getInstance(project2);
        this.myConstantEvaluationHelper = JavaPsiFacade.getInstance((Project)project2).getConstantEvaluationHelper();
    }

    @NotNull
    ControlFlow buildControlFlow() throws AnalysisCanceledException {
        this.myStartJumpRoles.push((Object)BranchingInstruction.Role.END);
        this.myEndJumpRoles.push((Object)BranchingInstruction.Role.END);
        this.myCurrentFlow = new ControlFlowImpl();
        this.myStartStatementStack.pushStatement(this.myCodeFragment, false);
        this.myEndStatementStack.pushStatement(this.myCodeFragment, false);
        try {
            this.myCodeFragment.accept((PsiElementVisitor)this);
            this.cleanup();
        }
        catch (AnalysisCanceledSoftException e) {
            throw new AnalysisCanceledException(e.getErrorElement());
        }
        return this.myCurrentFlow;
    }

    @NotNull
    private TIntArrayList getEmptyIntArray() {
        if (this.intArrayPool.isEmpty()) {
            return new TIntArrayList(1);
        }
        TIntArrayList list = (TIntArrayList)this.intArrayPool.pop();
        list.clear();
        return list;
    }

    private void poolIntArray(@NotNull TIntArrayList list) {
        this.intArrayPool.add((Object)list);
    }

    private void addElementOffsetLater(@NotNull PsiElement element, boolean atStart) {
        Map<PsiElement, TIntArrayList> offsetsAddElement = atStart ? this.offsetsAddElementStart : this.offsetsAddElementEnd;
        TIntArrayList offsets = offsetsAddElement.get(element);
        if (offsets == null) {
            offsets = this.getEmptyIntArray();
            offsetsAddElement.put(element, offsets);
        }
        int offset = this.myCurrentFlow.getSize() - 1;
        offsets.add(offset);
        if (this.myCurrentFlow.getEndOffset(element) != -1) {
            this.patchInstructionOffsets(element);
        }
    }

    private void patchInstructionOffsets(@NotNull PsiElement element) {
        this.patchInstructionOffsets(this.offsetsAddElementStart.get(element), this.myCurrentFlow.getStartOffset(element));
        this.offsetsAddElementStart.put(element, null);
        this.patchInstructionOffsets(this.offsetsAddElementEnd.get(element), this.myCurrentFlow.getEndOffset(element));
        this.offsetsAddElementEnd.put(element, null);
    }

    private void patchInstructionOffsets(@Nullable TIntArrayList offsets, int add2) {
        if (offsets == null) {
            return;
        }
        for (int i = 0; i < offsets.size(); ++i) {
            int offset = offsets.get(i);
            BranchingInstruction instruction = (BranchingInstruction)this.myCurrentFlow.getInstructions().get(offset);
            instruction.offset += add2;
            LOG.assertTrue(instruction.offset >= 0);
        }
        this.poolIntArray(offsets);
    }

    private void cleanup() {
        for (TIntArrayList tIntArrayList : this.offsetsAddElementStart.values()) {
            this.patchInstructionOffsets(tIntArrayList, this.myCurrentFlow.getEndOffset(this.myCodeFragment));
        }
        for (TIntArrayList tIntArrayList : this.offsetsAddElementEnd.values()) {
            this.patchInstructionOffsets(tIntArrayList, this.myCurrentFlow.getEndOffset(this.myCodeFragment));
        }
        for (Map.Entry entry : this.mySubRanges.entrySet()) {
            ProgressManager.checkCanceled();
            ControlFlowSubRange subRange = (ControlFlowSubRange)entry.getValue();
            PsiElement element = (PsiElement)entry.getKey();
            this.myControlFlowFactory.registerSubRange(element, subRange, this.myEvaluateConstantIfCondition, this.myEnabledShortCircuit, this.myPolicy);
        }
    }

    private void startElement(@NotNull PsiElement element) {
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            ProgressManager.checkCanceled();
            if (!(child instanceof PsiErrorElement) || Comparing.strEqual((String)((PsiErrorElement)child).getErrorDescription(), (String)JavaErrorMessages.message("expected.semicolon", new Object[0]))) continue;
            throw new AnalysisCanceledSoftException(element);
        }
        ProgressManager.checkCanceled();
        this.myCurrentFlow.startElement(element);
        this.generateUncheckedExceptionJumpsIfNeeded(element, true);
    }

    private void generateUncheckedExceptionJumpsIfNeeded(@NotNull PsiElement element, boolean atStart) {
        boolean isGeneratingCodeBlock;
        boolean isGeneratingStatement = element instanceof PsiStatement && !(element instanceof PsiSwitchLabelStatement);
        boolean bl = isGeneratingCodeBlock = element instanceof PsiCodeBlock && !(element.getParent() instanceof PsiSwitchStatement);
        if (isGeneratingStatement || isGeneratingCodeBlock) {
            this.generateUncheckedExceptionJumps(element, atStart);
        }
    }

    private void finishElement(@NotNull PsiElement element) {
        this.generateUncheckedExceptionJumpsIfNeeded(element, false);
        this.myCurrentFlow.finishElement(element);
        this.patchInstructionOffsets(element);
    }

    private void generateUncheckedExceptionJumps(@NotNull PsiElement element, boolean atStart) {
        if (atStart && element instanceof PsiStatement && element.getParent() instanceof PsiCodeBlock && element.getPrevSibling() != null) {
            return;
        }
        for (int i = this.myUnhandledExceptionCatchBlocks.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiElement block = (PsiElement)this.myUnhandledExceptionCatchBlocks.get(i);
            if (block == null) {
                if (this.myFinallyBlocks.isEmpty()) continue;
                break;
            }
            ConditionalThrowToInstruction throwToInstruction = new ConditionalThrowToInstruction(-1);
            this.myCurrentFlow.addInstruction(throwToInstruction);
            if (this.patchUncheckedThrowInstructionIfInsideFinally(throwToInstruction, element, block)) continue;
            this.addElementOffsetLater(block, true);
        }
        if (!this.myFinallyBlocks.isEmpty()) {
            PsiElement finallyBlock = ((FinallyBlockSubroutine)this.myFinallyBlocks.peek()).getElement();
            ConditionalThrowToInstruction throwToInstruction = new ConditionalThrowToInstruction(-2);
            this.myCurrentFlow.addInstruction(throwToInstruction);
            if (!this.patchUncheckedThrowInstructionIfInsideFinally(throwToInstruction, element, finallyBlock)) {
                this.addElementOffsetLater(finallyBlock, true);
            }
        }
    }

    private void generateCheckedExceptionJumps(@NotNull PsiElement element) {
        Collection<PsiClassType> unhandledExceptions = ExceptionUtil.collectUnhandledExceptions(element, element.getParent());
        for (PsiClassType unhandledException : unhandledExceptions) {
            ProgressManager.checkCanceled();
            this.generateThrow(unhandledException, element);
        }
    }

    private void generateThrow(@NotNull PsiClassType unhandledException, @NotNull PsiElement throwingElement) {
        List<PsiElement> catchBlocks = this.findThrowToBlocks(unhandledException);
        for (PsiElement block : catchBlocks) {
            ProgressManager.checkCanceled();
            ConditionalThrowToInstruction instruction = new ConditionalThrowToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.patchCheckedThrowInstructionIfInsideFinally(instruction, throwingElement, block)) continue;
            if (block == null) {
                this.addElementOffsetLater(this.myCodeFragment, false);
                continue;
            }
            --instruction.offset;
            this.addElementOffsetLater(block, true);
        }
    }

    private boolean patchCheckedThrowInstructionIfInsideFinally(@NotNull ConditionalThrowToInstruction instruction, @NotNull PsiElement throwingElement, PsiElement elementToJumpTo) {
        int index;
        PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(throwingElement, elementToJumpTo);
        if (finallyBlock == null) {
            return false;
        }
        List<PsiElement> unhandledExceptionCatchBlocks = this.finallyBlockToUnhandledExceptions.get(finallyBlock);
        if (unhandledExceptionCatchBlocks == null) {
            unhandledExceptionCatchBlocks = new ArrayList<PsiElement>();
            this.finallyBlockToUnhandledExceptions.put(finallyBlock, unhandledExceptionCatchBlocks);
        }
        if ((index = unhandledExceptionCatchBlocks.indexOf(elementToJumpTo)) == -1) {
            index = unhandledExceptionCatchBlocks.size();
            unhandledExceptionCatchBlocks.add(elementToJumpTo);
        }
        instruction.offset = 3 + index;
        this.addElementOffsetLater(finallyBlock, false);
        return true;
    }

    private boolean patchUncheckedThrowInstructionIfInsideFinally(@NotNull ConditionalThrowToInstruction instruction, @NotNull PsiElement throwingElement, @NotNull PsiElement elementToJumpTo) {
        PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(throwingElement, elementToJumpTo);
        if (finallyBlock == null) {
            return false;
        }
        instruction.offset = 2;
        this.addElementOffsetLater(finallyBlock, false);
        return true;
    }

    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        PsiElement[] children2;
        this.startElement((PsiElement)codeFragment);
        int prevOffset = this.myCurrentFlow.getSize();
        for (PsiElement child : children2 = codeFragment.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)codeFragment);
        this.registerSubRange((PsiElement)codeFragment, prevOffset);
    }

    private void registerSubRange(@NotNull PsiElement codeFragment, int startOffset) {
        ControlFlowSubRange flow = new ControlFlowSubRange(this.myCurrentFlow, startOffset, this.myCurrentFlow.getSize());
        this.mySubRanges.put(codeFragment, flow);
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        PsiStatement[] statements;
        this.startElement((PsiElement)block);
        int prevOffset = this.myCurrentFlow.getSize();
        for (PsiStatement statement2 : statements = block.getStatements()) {
            ProgressManager.checkCanceled();
            statement2.accept((PsiElementVisitor)this);
        }
        int nextOffset = this.myCurrentFlow.getSize();
        if (!(block.getParent() instanceof PsiSwitchStatement) && prevOffset == nextOffset) {
            this.emitEmptyInstruction();
        }
        this.finishElement((PsiElement)block);
        if (prevOffset != 0) {
            this.registerSubRange((PsiElement)block, prevOffset);
        }
    }

    private void emitEmptyInstruction() {
        this.myCurrentFlow.addInstruction(EmptyInstruction.INSTANCE);
    }

    public void visitFile(PsiFile file2) {
        this.visitChildren((PsiElement)file2);
    }

    public void visitBlockStatement(PsiBlockStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiCodeBlock codeBlock = statement2.getCodeBlock();
        codeBlock.accept((PsiElementVisitor)this);
        this.finishElement((PsiElement)statement2);
    }

    public void visitBreakStatement(PsiBreakStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement exitedStatement = statement2.findExitedStatement();
        if (exitedStatement != null) {
            GoToInstruction instruction;
            int finallyStartOffset;
            this.callFinallyBlocksOnExit(exitedStatement);
            PsiElement finallyBlock = this.findEnclosingFinallyBlockElement((PsiElement)statement2, (PsiElement)exitedStatement);
            int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
            if (finallyBlock != null && finallyStartOffset != -1) {
                CallInstruction callInstruction = (CallInstruction)this.myCurrentFlow.getInstructions().get(finallyStartOffset - 2);
                instruction = new ReturnInstruction(0, this.myStack, callInstruction);
            } else {
                instruction = new GoToInstruction(0);
            }
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater((PsiElement)exitedStatement, false);
        }
        this.finishElement((PsiElement)statement2);
    }

    private void callFinallyBlocksOnExit(PsiStatement exitedStatement) {
        FinallyBlockSubroutine finallyBlockSubroutine;
        PsiElement finallyBlock;
        PsiElement enclosingTryStatement;
        ListIterator it = this.myFinallyBlocks.listIterator(this.myFinallyBlocks.size());
        while (it.hasPrevious() && (enclosingTryStatement = (finallyBlock = (finallyBlockSubroutine = (FinallyBlockSubroutine)it.previous()).getElement()).getParent()) != null && PsiTreeUtil.isAncestor((PsiElement)exitedStatement, (PsiElement)enclosingTryStatement, (boolean)false)) {
            CallInstruction instruction = new CallInstruction(0, 0, this.myStack);
            finallyBlockSubroutine.addCall(instruction);
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(finallyBlock, true);
        }
    }

    private PsiElement findEnclosingFinallyBlockElement(@NotNull PsiElement sourceElement, @Nullable PsiElement jumpElement) {
        for (PsiElement element = sourceElement; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!(element instanceof PsiCodeBlock) || !(element.getParent() instanceof PsiTryStatement) || ((PsiTryStatement)element.getParent()).getFinallyBlock() != element) continue;
            if (this.myCurrentFlow.getStartOffset(element.getParent()) == -1) {
                return null;
            }
            if (jumpElement != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)jumpElement, (boolean)false)) continue;
            return element;
        }
        return null;
    }

    public void visitContinueStatement(PsiContinueStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement continuedStatement = statement2.findContinuedStatement();
        if (continuedStatement != null) {
            GoToInstruction instruction;
            int finallyStartOffset;
            PsiStatement body2 = null;
            if (continuedStatement instanceof PsiLoopStatement) {
                body2 = ((PsiLoopStatement)continuedStatement).getBody();
            }
            if (body2 == null) {
                body2 = this.myCodeFragment;
            }
            this.callFinallyBlocksOnExit(continuedStatement);
            PsiElement finallyBlock = this.findEnclosingFinallyBlockElement((PsiElement)statement2, (PsiElement)continuedStatement);
            int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
            if (finallyBlock != null && finallyStartOffset != -1) {
                CallInstruction callInstruction = (CallInstruction)this.myCurrentFlow.getInstructions().get(finallyStartOffset - 2);
                instruction = new ReturnInstruction(0, this.myStack, callInstruction);
            } else {
                instruction = new GoToInstruction(0);
            }
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater((PsiElement)body2, false);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
        PsiElement[] elements;
        this.startElement((PsiElement)statement2);
        int pc = this.myCurrentFlow.getSize();
        for (PsiElement element : elements = statement2.getDeclaredElements()) {
            ProgressManager.checkCanceled();
            if (element instanceof PsiClass) {
                element.accept((PsiElementVisitor)this);
                continue;
            }
            if (!(element instanceof PsiVariable)) continue;
            this.processVariable((PsiVariable)element);
        }
        if (pc == this.myCurrentFlow.getSize()) {
            this.emitEmptyInstruction();
        }
        this.finishElement((PsiElement)statement2);
    }

    private void processVariable(@NotNull PsiVariable element) {
        PsiExpression initializer = element.getInitializer();
        if (initializer != null) {
            this.myStartStatementStack.pushStatement((PsiElement)initializer, false);
            this.myEndStatementStack.pushStatement((PsiElement)initializer, false);
            initializer.accept((PsiElementVisitor)this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        if (element instanceof PsiLocalVariable && initializer != null || element instanceof PsiField) {
            if (element instanceof PsiLocalVariable && !this.myPolicy.isLocalVariableAccepted((PsiLocalVariable)element)) {
                return;
            }
            if (this.myAssignmentTargetsAreElements) {
                this.startElement((PsiElement)element);
            }
            this.generateWriteInstruction(element);
            if (this.myAssignmentTargetsAreElements) {
                this.finishElement((PsiElement)element);
            }
        }
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
        PsiExpression condition2;
        this.startElement((PsiElement)statement2);
        PsiStatement body2 = statement2.getBody();
        this.myStartStatementStack.pushStatement((PsiElement)(body2 == null ? statement2 : body2), true);
        this.myEndStatementStack.pushStatement((PsiElement)statement2, false);
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        if ((condition2 = statement2.getCondition()) != null) {
            condition2.accept((PsiElementVisitor)this);
        }
        int offset = this.myCurrentFlow.getStartOffset((PsiElement)statement2);
        Object loopCondition = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)statement2.getCondition());
        if (loopCondition instanceof Boolean) {
            if (((Boolean)loopCondition).booleanValue()) {
                this.myCurrentFlow.addInstruction(new GoToInstruction(offset));
            } else {
                this.emitEmptyInstruction();
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(offset, statement2.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement2);
    }

    public void visitEmptyStatement(PsiEmptyStatement statement2) {
        this.startElement((PsiElement)statement2);
        this.emitEmptyInstruction();
        this.finishElement((PsiElement)statement2);
    }

    public void visitExpressionStatement(PsiExpressionStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiExpression expression2 = statement2.getExpression();
        expression2.accept((PsiElementVisitor)this);
        for (PsiParameter catchParameter : this.myCatchParameters) {
            ProgressManager.checkCanceled();
            PsiType type2 = catchParameter.getType();
            if (!(type2 instanceof PsiClassType)) continue;
            this.generateThrow((PsiClassType)type2, (PsiElement)statement2);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitExpressionListStatement(PsiExpressionListStatement statement2) {
        PsiExpression[] expressions2;
        this.startElement((PsiElement)statement2);
        for (PsiExpression expr : expressions2 = statement2.getExpressionList().getExpressions()) {
            ProgressManager.checkCanceled();
            expr.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitField(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            this.startElement((PsiElement)field);
            initializer.accept((PsiElementVisitor)this);
            this.finishElement((PsiElement)field);
        }
    }

    public void visitForStatement(PsiForStatement statement2) {
        PsiStatement update2;
        Object loopCondition;
        PsiExpression condition2;
        this.startElement((PsiElement)statement2);
        PsiStatement body2 = statement2.getBody();
        this.myStartStatementStack.pushStatement((PsiElement)(body2 == null ? statement2 : body2), false);
        this.myEndStatementStack.pushStatement((PsiElement)statement2, false);
        PsiStatement initialization = statement2.getInitialization();
        if (initialization != null) {
            initialization.accept((PsiElementVisitor)this);
        }
        if ((condition2 = statement2.getCondition()) != null) {
            condition2.accept((PsiElementVisitor)this);
        }
        if ((loopCondition = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)condition2)) instanceof Boolean || condition2 == null) {
            boolean value2;
            boolean bl = value2 = condition2 == null || (Boolean)loopCondition != false;
            if (value2) {
                this.emitEmptyInstruction();
            } else {
                this.myCurrentFlow.addInstruction(new GoToInstruction(0));
                this.addElementOffsetLater((PsiElement)statement2, false);
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater((PsiElement)statement2, false);
        }
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        if ((update2 = statement2.getUpdate()) != null) {
            update2.accept((PsiElementVisitor)this);
        }
        int offset = initialization != null ? this.myCurrentFlow.getEndOffset((PsiElement)initialization) : this.myCurrentFlow.getStartOffset((PsiElement)statement2);
        GoToInstruction instruction = new GoToInstruction(offset);
        this.myCurrentFlow.addInstruction(instruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement2);
    }

    public void visitForeachStatement(PsiForeachStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement body2 = statement2.getBody();
        this.myStartStatementStack.pushStatement((PsiElement)(body2 == null ? statement2 : body2), false);
        this.myEndStatementStack.pushStatement((PsiElement)statement2, false);
        PsiExpression iteratedValue2 = statement2.getIteratedValue();
        if (iteratedValue2 != null) {
            iteratedValue2.accept((PsiElementVisitor)this);
        }
        int gotoTarget = this.myCurrentFlow.getSize();
        ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getIteratedValue());
        this.myCurrentFlow.addInstruction(instruction);
        this.addElementOffsetLater((PsiElement)statement2, false);
        PsiParameter iterationParameter = statement2.getIterationParameter();
        if (this.myPolicy.isParameterAccepted(iterationParameter)) {
            this.generateWriteInstruction((PsiVariable)iterationParameter);
        }
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        GoToInstruction gotoInstruction = new GoToInstruction(gotoTarget);
        this.myCurrentFlow.addInstruction(gotoInstruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement2);
    }

    public void visitIfStatement(PsiIfStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement elseBranch = statement2.getElseBranch();
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpression conditionExpression = statement2.getCondition();
        this.generateConditionalStatementInstructions((PsiElement)statement2, conditionExpression, (PsiElement)thenBranch, (PsiElement)elseBranch);
        this.finishElement((PsiElement)statement2);
    }

    private void generateConditionalStatementInstructions(@NotNull PsiElement statement2, @Nullable PsiExpression conditionExpression, PsiElement thenBranch, PsiElement elseBranch) {
        Object value2;
        if (thenBranch == null) {
            this.myStartStatementStack.pushStatement(statement2, false);
        } else {
            this.myStartStatementStack.pushStatement(thenBranch, true);
        }
        if (elseBranch == null) {
            this.myEndStatementStack.pushStatement(statement2, false);
        } else {
            this.myEndStatementStack.pushStatement(elseBranch, true);
        }
        this.myEndJumpRoles.push((Object)(elseBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.ELSE));
        this.myStartJumpRoles.push((Object)(thenBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.THEN));
        if (conditionExpression != null) {
            conditionExpression.accept((PsiElementVisitor)this);
        }
        boolean generateElseFlow = true;
        boolean generateThenFlow = true;
        boolean generateConditionalJump = true;
        if (this.myEvaluateConstantIfCondition && (value2 = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)conditionExpression)) instanceof Boolean) {
            boolean condition2;
            generateThenFlow = condition2 = ((Boolean)value2).booleanValue();
            generateElseFlow = !condition2;
            generateConditionalJump = false;
            this.myCurrentFlow.setConstantConditionOccurred(true);
        }
        if (generateConditionalJump) {
            BranchingInstruction.Role role = elseBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.ELSE;
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, role, conditionExpression);
            this.myCurrentFlow.addInstruction(instruction);
            if (elseBranch == null) {
                this.addElementOffsetLater(statement2, false);
            } else {
                this.addElementOffsetLater(elseBranch, true);
            }
        }
        if (thenBranch != null && generateThenFlow) {
            thenBranch.accept((PsiElementVisitor)this);
        }
        if (elseBranch != null && generateElseFlow) {
            if (generateThenFlow) {
                GoToInstruction instruction = new GoToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater(statement2, false);
            }
            elseBranch.accept((PsiElementVisitor)this);
        }
        this.myStartJumpRoles.pop();
        this.myEndJumpRoles.pop();
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
    }

    public void visitLabeledStatement(PsiLabeledStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement innerStatement = statement2.getStatement();
        if (innerStatement != null) {
            innerStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitReturnStatement(PsiReturnStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiExpression returnValue = statement2.getReturnValue();
        if (returnValue != null) {
            this.myStartStatementStack.pushStatement((PsiElement)returnValue, false);
            this.myEndStatementStack.pushStatement((PsiElement)returnValue, false);
            returnValue.accept((PsiElementVisitor)this);
        }
        this.addReturnInstruction((PsiElement)statement2);
        if (returnValue != null) {
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        this.finishElement((PsiElement)statement2);
    }

    private void addReturnInstruction(@NotNull PsiElement statement2) {
        int finallyStartOffset;
        PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(statement2, null);
        int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
        if (finallyBlock != null && finallyStartOffset != -1) {
            GoToInstruction instruction = new GoToInstruction(1, BranchingInstruction.Role.END, true);
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(finallyBlock, false);
        } else {
            GoToInstruction instruction = new GoToInstruction(0, BranchingInstruction.Role.END, true);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.myFinallyBlocks.isEmpty()) {
                this.addElementOffsetLater(this.myCodeFragment, false);
            } else {
                instruction.offset = -4;
                this.addElementOffsetLater(((FinallyBlockSubroutine)this.myFinallyBlocks.peek()).getElement(), true);
            }
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiExpression caseValue = statement2.getCaseValue();
        if (caseValue != null) {
            this.myStartStatementStack.pushStatement((PsiElement)caseValue, false);
            this.myEndStatementStack.pushStatement((PsiElement)caseValue, false);
            caseValue.accept((PsiElementVisitor)this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitSwitchStatement(PsiSwitchStatement statement2) {
        PsiCodeBlock body2;
        this.startElement((PsiElement)statement2);
        PsiExpression expr = statement2.getExpression();
        if (expr != null) {
            expr.accept((PsiElementVisitor)this);
        }
        if ((body2 = statement2.getBody()) != null) {
            PsiStatement[] statements = body2.getStatements();
            PsiSwitchLabelStatement defaultLabel = null;
            for (PsiStatement aStatement : statements) {
                ProgressManager.checkCanceled();
                if (!(aStatement instanceof PsiSwitchLabelStatement)) continue;
                if (((PsiSwitchLabelStatement)aStatement).isDefaultCase()) {
                    defaultLabel = (PsiSwitchLabelStatement)aStatement;
                }
                ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getExpression());
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater((PsiElement)aStatement, true);
            }
            if (defaultLabel == null) {
                GoToInstruction instruction = new GoToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater((PsiElement)body2, false);
            }
            body2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement statement2) {
        PsiCodeBlock body2;
        this.startElement((PsiElement)statement2);
        PsiExpression lock = statement2.getLockExpression();
        if (lock != null) {
            lock.accept((PsiElementVisitor)this);
        }
        if ((body2 = statement2.getBody()) != null) {
            body2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitThrowStatement(PsiThrowStatement statement2) {
        List<PsiElement> blocks;
        this.startElement((PsiElement)statement2);
        PsiExpression exception = statement2.getException();
        if (exception != null) {
            exception.accept((PsiElementVisitor)this);
        }
        if ((blocks = this.findThrowToBlocks(statement2)).isEmpty() || blocks.get(0) == null) {
            ThrowToInstruction instruction = new ThrowToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.myFinallyBlocks.isEmpty()) {
                PsiElement element = this.myCodeFragment;
                this.addElementOffsetLater(element, false);
            } else {
                instruction.offset = -2;
                PsiElement element = ((FinallyBlockSubroutine)this.myFinallyBlocks.peek()).getElement();
                this.addElementOffsetLater(element, true);
            }
        } else {
            for (int i = 0; i < blocks.size(); ++i) {
                ProgressManager.checkCanceled();
                PsiElement element = blocks.get(i);
                BranchingInstruction instruction = i == blocks.size() - 1 ? new ThrowToInstruction(0) : new ConditionalThrowToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                instruction.offset = -1;
                this.addElementOffsetLater(element, true);
            }
        }
        this.finishElement((PsiElement)statement2);
    }

    @NotNull
    private List<PsiElement> findThrowToBlocks(@NotNull PsiThrowStatement statement2) {
        PsiExpression exceptionExpr = statement2.getException();
        if (exceptionExpr == null) {
            return Collections.emptyList();
        }
        PsiType throwType = exceptionExpr.getType();
        if (!(throwType instanceof PsiClassType)) {
            return Collections.emptyList();
        }
        return this.findThrowToBlocks((PsiClassType)throwType);
    }

    @NotNull
    private List<PsiElement> findThrowToBlocks(@NotNull PsiClassType throwType) {
        ArrayList<PsiElement> blocks = new ArrayList<PsiElement>();
        for (int i = this.myCatchParameters.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiParameter parameter = (PsiParameter)this.myCatchParameters.get(i);
            PsiType catchType = parameter.getType();
            if (!ControlFlowUtil.isCaughtExceptionType(throwType, catchType)) continue;
            blocks.add((PsiElement)this.myCatchBlocks.get(i));
        }
        if (blocks.isEmpty()) {
            blocks.add(null);
        }
        return blocks;
    }

    public void visitAssertStatement(PsiAssertStatement statement2) {
        PsiExpression description;
        this.startElement((PsiElement)statement2);
        this.myStartStatementStack.pushStatement((PsiElement)statement2, false);
        this.myEndStatementStack.pushStatement((PsiElement)statement2, false);
        ConditionalGoToInstruction passByWhenAssertionsDisabled = new ConditionalGoToInstruction(0, BranchingInstruction.Role.END, null);
        this.myCurrentFlow.addInstruction(passByWhenAssertionsDisabled);
        this.addElementOffsetLater((PsiElement)statement2, false);
        PsiExpression condition2 = statement2.getAssertCondition();
        if (condition2 != null) {
            this.myStartStatementStack.pushStatement((PsiElement)statement2, false);
            this.myEndStatementStack.pushStatement((PsiElement)statement2, false);
            this.myEndJumpRoles.push((Object)BranchingInstruction.Role.END);
            this.myStartJumpRoles.push((Object)BranchingInstruction.Role.END);
            condition2.accept((PsiElementVisitor)this);
            this.myStartJumpRoles.pop();
            this.myEndJumpRoles.pop();
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        if ((description = statement2.getAssertDescription()) != null) {
            description.accept((PsiElementVisitor)this);
        }
        ConditionalThrowToInstruction instruction = new ConditionalThrowToInstruction(0, statement2.getAssertCondition());
        this.myCurrentFlow.addInstruction(instruction);
        this.addElementOffsetLater(this.myCodeFragment, false);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement2);
    }

    public void visitTryStatement(PsiTryStatement statement2) {
        int i;
        PsiCodeBlock tryBlock;
        PsiResourceList resourceList;
        this.startElement((PsiElement)statement2);
        PsiCodeBlock[] catchBlocks = statement2.getCatchBlocks();
        PsiParameter[] catchBlockParameters = statement2.getCatchBlockParameters();
        int catchNum = Math.min(catchBlocks.length, catchBlockParameters.length);
        this.myUnhandledExceptionCatchBlocks.push(null);
        block0: for (int i2 = catchNum - 1; i2 >= 0; --i2) {
            ProgressManager.checkCanceled();
            this.myCatchParameters.push((Object)catchBlockParameters[i2]);
            this.myCatchBlocks.push((Object)catchBlocks[i2]);
            PsiType type2 = catchBlockParameters[i2].getType();
            if (type2 instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)type2)) {
                this.myUnhandledExceptionCatchBlocks.push((Object)catchBlocks[i2]);
                continue;
            }
            if (!(type2 instanceof PsiDisjunctionType)) continue;
            PsiType lub = ((PsiDisjunctionType)type2).getLeastUpperBound();
            if (lub instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)lub)) {
                this.myUnhandledExceptionCatchBlocks.push((Object)catchBlocks[i2]);
                continue;
            }
            if (!(lub instanceof PsiIntersectionType)) continue;
            for (PsiType conjunct : ((PsiIntersectionType)lub).getConjuncts()) {
                if (!(conjunct instanceof PsiClassType) || !ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)conjunct)) continue;
                this.myUnhandledExceptionCatchBlocks.push((Object)catchBlocks[i2]);
                continue block0;
            }
        }
        PsiCodeBlock finallyBlock = statement2.getFinallyBlock();
        FinallyBlockSubroutine finallyBlockSubroutine = null;
        if (finallyBlock != null) {
            finallyBlockSubroutine = new FinallyBlockSubroutine((PsiElement)finallyBlock);
            this.myFinallyBlocks.push((Object)finallyBlockSubroutine);
        }
        if ((resourceList = statement2.getResourceList()) != null) {
            this.generateCheckedExceptionJumps((PsiElement)resourceList);
            resourceList.accept((PsiElementVisitor)this);
        }
        if ((tryBlock = statement2.getTryBlock()) != null) {
            this.generateCheckedExceptionJumps((PsiElement)tryBlock);
            tryBlock.accept((PsiElementVisitor)this);
        }
        while (this.myUnhandledExceptionCatchBlocks.pop() != null) {
        }
        this.myCurrentFlow.addInstruction(new GoToInstruction(finallyBlock == null ? 0 : -6));
        if (finallyBlock == null) {
            this.addElementOffsetLater((PsiElement)statement2, false);
        } else {
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
        }
        for (i = 0; i < catchNum; ++i) {
            this.myCatchParameters.pop();
            this.myCatchBlocks.pop();
        }
        for (i = catchNum - 1; i >= 0; --i) {
            PsiCodeBlock catchBlock;
            ProgressManager.checkCanceled();
            if (this.myPolicy.isParameterAccepted(catchBlockParameters[i])) {
                this.generateWriteInstruction((PsiVariable)catchBlockParameters[i]);
            }
            if ((catchBlock = catchBlocks[i]) != null) {
                catchBlock.accept((PsiElementVisitor)this);
            } else {
                LOG.error("Catch body is null (" + i + ") " + statement2.getText());
            }
            this.myCurrentFlow.addInstruction(new GoToInstruction(finallyBlock == null ? 0 : -6));
            if (finallyBlock == null) {
                this.addElementOffsetLater((PsiElement)statement2, false);
                continue;
            }
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
        }
        if (finallyBlock != null) {
            this.myFinallyBlocks.pop();
        }
        if (finallyBlock != null) {
            CallInstruction normalCompletion = new CallInstruction(0, 0, this.myStack);
            finallyBlockSubroutine.addCall(normalCompletion);
            this.myCurrentFlow.addInstruction(normalCompletion);
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
            this.myCurrentFlow.addInstruction(new GoToInstruction(0));
            this.addElementOffsetLater((PsiElement)statement2, false);
            CallInstruction returnCompletion = new CallInstruction(0, 0, this.myStack);
            finallyBlockSubroutine.addCall(returnCompletion);
            this.myCurrentFlow.addInstruction(returnCompletion);
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
            this.addReturnInstruction((PsiElement)statement2);
            CallInstruction throwExceptionCompletion = new CallInstruction(0, 0, this.myStack);
            finallyBlockSubroutine.addCall(throwExceptionCompletion);
            this.myCurrentFlow.addInstruction(throwExceptionCompletion);
            this.addElementOffsetLater((PsiElement)finallyBlock, true);
            GoToInstruction gotoUncheckedRethrow = new GoToInstruction(0);
            this.myCurrentFlow.addInstruction(gotoUncheckedRethrow);
            this.addElementOffsetLater((PsiElement)finallyBlock, false);
            finallyBlock.accept((PsiElementVisitor)this);
            int procStart = this.myCurrentFlow.getStartOffset((PsiElement)finallyBlock);
            int procEnd = this.myCurrentFlow.getEndOffset((PsiElement)finallyBlock);
            for (CallInstruction callInstruction : finallyBlockSubroutine.getCalls()) {
                callInstruction.procBegin = procStart;
                callInstruction.procEnd = procEnd;
            }
            this.myCurrentFlow.addInstruction(new ReturnInstruction(0, this.myStack, normalCompletion));
            this.myCurrentFlow.addInstruction(new ReturnInstruction(procStart - 3, this.myStack, returnCompletion));
            this.myCurrentFlow.addInstruction(new ReturnInstruction(procStart - 1, this.myStack, throwExceptionCompletion));
            List<PsiElement> unhandledExceptionCatchBlocks = this.finallyBlockToUnhandledExceptions.remove(finallyBlock);
            for (int i3 = 0; unhandledExceptionCatchBlocks != null && i3 < unhandledExceptionCatchBlocks.size(); ++i3) {
                ProgressManager.checkCanceled();
                PsiElement catchBlock = unhandledExceptionCatchBlocks.get(i3);
                ReturnInstruction returnInstruction = new ReturnInstruction(0, this.myStack, throwExceptionCompletion);
                returnInstruction.setRethrowFromFinally();
                this.myCurrentFlow.addInstruction(returnInstruction);
                if (catchBlock == null) {
                    returnInstruction.offset = procStart - 1;
                    continue;
                }
                --returnInstruction.offset;
                this.addElementOffsetLater(catchBlock, true);
            }
            gotoUncheckedRethrow.offset = this.myCurrentFlow.getSize();
            this.generateUncheckedExceptionJumps((PsiElement)statement2, false);
            this.myCurrentFlow.addInstruction(new ThrowToInstruction(0));
            this.addElementOffsetLater(this.myCodeFragment, false);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitResourceList(PsiResourceList resourceList) {
        this.startElement((PsiElement)resourceList);
        for (PsiResourceListElement resource : resourceList) {
            ProgressManager.checkCanceled();
            if (resource instanceof PsiResourceVariable) {
                this.processVariable((PsiVariable)resource);
                continue;
            }
            if (!(resource instanceof PsiResourceExpression)) continue;
            ((PsiResourceExpression)resource).getExpression().accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)resourceList);
    }

    public void visitWhileStatement(PsiWhileStatement statement2) {
        Object loopCondition;
        this.startElement((PsiElement)statement2);
        PsiStatement body2 = statement2.getBody();
        if (body2 == null) {
            this.myStartStatementStack.pushStatement((PsiElement)statement2, false);
        } else {
            this.myStartStatementStack.pushStatement((PsiElement)body2, true);
        }
        this.myEndStatementStack.pushStatement((PsiElement)statement2, false);
        PsiExpression condition2 = statement2.getCondition();
        if (condition2 != null) {
            condition2.accept((PsiElementVisitor)this);
        }
        if ((loopCondition = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)statement2.getCondition())) instanceof Boolean) {
            boolean value2 = (Boolean)loopCondition;
            if (value2) {
                this.emitEmptyInstruction();
            } else {
                this.myCurrentFlow.addInstruction(new GoToInstruction(0));
                this.addElementOffsetLater((PsiElement)statement2, false);
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater((PsiElement)statement2, false);
        }
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        int offset = this.myCurrentFlow.getStartOffset((PsiElement)statement2);
        GoToInstruction instruction = new GoToInstruction(offset);
        this.myCurrentFlow.addInstruction(instruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)statement2);
    }

    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] expressions2;
        for (PsiExpression expression2 : expressions2 = list.getExpressions()) {
            ProgressManager.checkCanceled();
            this.myStartStatementStack.pushStatement((PsiElement)expression2, false);
            this.myEndStatementStack.pushStatement((PsiElement)expression2, false);
            expression2.accept((PsiElementVisitor)this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
        this.startElement((PsiElement)expression2);
        expression2.getArrayExpression().accept((PsiElementVisitor)this);
        PsiExpression indexExpression = expression2.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        PsiExpression[] initializers;
        this.startElement((PsiElement)expression2);
        for (PsiExpression initializer : initializers = expression2.getInitializers()) {
            ProgressManager.checkCanceled();
            initializer.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression rExpr = expression2.getRExpression();
        this.myStartStatementStack.pushStatement((PsiElement)(rExpr == null ? expression2 : rExpr), false);
        this.myEndStatementStack.pushStatement((PsiElement)(rExpr == null ? expression2 : rExpr), false);
        PsiExpression lExpr = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getLExpression());
        if (lExpr instanceof PsiReferenceExpression) {
            PsiVariable variable = this.getUsedVariable((PsiReferenceExpression)lExpr);
            if (variable != null) {
                PsiExpression qualifier;
                if (this.myAssignmentTargetsAreElements) {
                    this.startElement((PsiElement)lExpr);
                }
                if ((qualifier = ((PsiReferenceExpression)lExpr).getQualifierExpression()) != null) {
                    qualifier.accept((PsiElementVisitor)this);
                }
                if (expression2.getOperationTokenType() != JavaTokenType.EQ) {
                    this.generateReadInstruction(variable);
                }
                if (rExpr != null) {
                    rExpr.accept((PsiElementVisitor)this);
                }
                this.generateWriteInstruction(variable);
                if (this.myAssignmentTargetsAreElements) {
                    this.finishElement((PsiElement)lExpr);
                }
            } else {
                if (rExpr != null) {
                    rExpr.accept((PsiElementVisitor)this);
                }
                lExpr.accept((PsiElementVisitor)this);
            }
        } else if (lExpr instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)lExpr).getArrayExpression() instanceof PsiReferenceExpression) {
            PsiVariable variable = this.getUsedVariable((PsiReferenceExpression)((PsiArrayAccessExpression)lExpr).getArrayExpression());
            if (variable != null) {
                this.generateReadInstruction(variable);
                PsiExpression indexExpression = ((PsiArrayAccessExpression)lExpr).getIndexExpression();
                if (indexExpression != null) {
                    indexExpression.accept((PsiElementVisitor)this);
                }
            } else {
                lExpr.accept((PsiElementVisitor)this);
            }
            if (rExpr != null) {
                rExpr.accept((PsiElementVisitor)this);
            }
        } else if (lExpr != null) {
            lExpr.accept((PsiElementVisitor)this);
            if (rExpr != null) {
                rExpr.accept((PsiElementVisitor)this);
            }
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement((PsiElement)expression2);
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        this.startElement((PsiElement)expression2);
        IElementType signTokenType = expression2.getOperationTokenType();
        boolean isAndAnd = signTokenType == JavaTokenType.ANDAND;
        boolean isOrOr = signTokenType == JavaTokenType.OROR;
        PsiExpression[] operands2 = expression2.getOperands();
        Boolean lValue = isAndAnd;
        PsiExpression lOperand = null;
        Boolean rValue = null;
        for (int i = 0; i < operands2.length; ++i) {
            PsiExpression rOperand = operands2[i];
            if ((isAndAnd || isOrOr) && this.myEnabledShortCircuit) {
                boolean gotoIsAtStart;
                Object exprValue = this.myConstantEvaluationHelper.computeConstantExpression((PsiElement)rOperand);
                if (exprValue instanceof Boolean) {
                    this.myCurrentFlow.setConstantConditionOccurred(true);
                    rValue = this.shouldCalculateConstantExpression((PsiExpression)expression2) ? (Boolean)exprValue : null;
                }
                BranchingInstruction.Role role = isAndAnd ? (BranchingInstruction.Role)((Object)this.myEndJumpRoles.peek()) : (BranchingInstruction.Role)((Object)this.myStartJumpRoles.peek());
                PsiElement gotoElement = isAndAnd ? this.myEndStatementStack.peekElement() : this.myStartStatementStack.peekElement();
                boolean bl = gotoIsAtStart = isAndAnd ? this.myEndStatementStack.peekAtStart() : this.myStartStatementStack.peekAtStart();
                Shortcut shortcut = lValue != null ? (lValue == isOrOr ? Shortcut.STOP_EXPRESSION : Shortcut.SKIP_CURRENT_OPERAND) : (rValue != null && rValue == isOrOr ? Shortcut.STOP_EXPRESSION : Shortcut.NO_SHORTCUT);
                switch (shortcut) {
                    case NO_SHORTCUT: {
                        assert (lOperand != null);
                        this.myCurrentFlow.addInstruction(new ConditionalGoToInstruction(0, role, lOperand));
                        this.addElementOffsetLater(gotoElement, gotoIsAtStart);
                        break;
                    }
                    case STOP_EXPRESSION: {
                        if (lOperand == null) break;
                        this.myCurrentFlow.addInstruction(new GoToInstruction(0, role));
                        this.addElementOffsetLater(gotoElement, gotoIsAtStart);
                        break;
                    }
                }
                if (shortcut == Shortcut.STOP_EXPRESSION) break;
            }
            this.generateLOperand(rOperand, i == operands2.length - 1 ? null : operands2[i + 1], signTokenType);
            lOperand = rOperand;
            lValue = rValue;
        }
        this.finishElement((PsiElement)expression2);
    }

    private void generateLOperand(@NotNull PsiExpression lOperand, @Nullable PsiExpression rOperand, @NotNull IElementType signTokenType) {
        if (rOperand != null) {
            this.myStartJumpRoles.push((Object)BranchingInstruction.Role.END);
            this.myEndJumpRoles.push((Object)BranchingInstruction.Role.END);
            PsiExpression then = signTokenType == JavaTokenType.OROR ? this.myStartStatementStack.peekElement() : rOperand;
            boolean thenAtStart = signTokenType != JavaTokenType.OROR || this.myStartStatementStack.peekAtStart();
            this.myStartStatementStack.pushStatement((PsiElement)then, thenAtStart);
            PsiExpression elseS = signTokenType == JavaTokenType.ANDAND ? this.myEndStatementStack.peekElement() : rOperand;
            boolean elseAtStart = signTokenType != JavaTokenType.ANDAND || this.myEndStatementStack.peekAtStart();
            this.myEndStatementStack.pushStatement((PsiElement)elseS, elseAtStart);
        }
        lOperand.accept((PsiElementVisitor)this);
        if (rOperand != null) {
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
            this.myStartJumpRoles.pop();
            this.myEndJumpRoles.pop();
        }
    }

    private static boolean isInsideIfCondition(@NotNull PsiExpression expression2) {
        PsiExpression element = expression2;
        while (element instanceof PsiExpression) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiIfStatement && element == ((PsiIfStatement)parent).getCondition()) {
                return true;
            }
            element = parent;
        }
        return false;
    }

    private boolean shouldCalculateConstantExpression(@NotNull PsiExpression expression2) {
        return this.myEvaluateConstantIfCondition || !ControlFlowAnalyzer.isInsideIfCondition(expression2);
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        this.visitChildren((PsiElement)expression2);
    }

    private void visitChildren(@NotNull PsiElement element) {
        PsiElement[] children2;
        this.startElement(element);
        for (PsiElement child : children2 = element.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept((PsiElementVisitor)this);
        }
        this.finishElement(element);
    }

    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression condition2 = expression2.getCondition();
        PsiExpression thenExpression2 = expression2.getThenExpression();
        PsiExpression elseExpression2 = expression2.getElseExpression();
        this.generateConditionalStatementInstructions((PsiElement)expression2, condition2, (PsiElement)thenExpression2, (PsiElement)elseExpression2);
        this.finishElement((PsiElement)expression2);
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression operand2 = expression2.getOperand();
        operand2.accept((PsiElementVisitor)this);
        this.finishElement((PsiElement)expression2);
    }

    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.finishElement((PsiElement)expression2);
    }

    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiElement body2 = expression2.getBody();
        if (body2 != null) {
            ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
            this.addUsedVariables(array, body2);
            for (PsiVariable var : array) {
                ProgressManager.checkCanceled();
                this.generateReadInstruction(var);
            }
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        methodExpression.accept((PsiElementVisitor)this);
        PsiExpressionList argumentList = expression2.getArgumentList();
        argumentList.accept((PsiElementVisitor)this);
        this.emitEmptyInstruction();
        this.generateCheckedExceptionJumps((PsiElement)expression2);
        this.finishElement((PsiElement)expression2);
    }

    public void visitNewExpression(PsiNewExpression expression2) {
        PsiElement[] children2;
        this.startElement((PsiElement)expression2);
        int pc = this.myCurrentFlow.getSize();
        for (PsiElement child : children2 = expression2.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept((PsiElementVisitor)this);
        }
        this.generateCheckedExceptionJumps((PsiElement)expression2);
        if (pc == this.myCurrentFlow.getSize()) {
            this.emitEmptyInstruction();
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        this.visitChildren((PsiElement)expression2);
    }

    public void visitPostfixExpression(PsiPostfixExpression expression2) {
        this.startElement((PsiElement)expression2);
        IElementType op = expression2.getOperationTokenType();
        PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
        if (operand2 != null) {
            PsiVariable variable;
            operand2.accept((PsiElementVisitor)this);
            if ((op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) && operand2 instanceof PsiReferenceExpression && (variable = this.getUsedVariable((PsiReferenceExpression)operand2)) != null) {
                this.generateWriteInstruction(variable);
            }
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
        if (operand2 != null) {
            PsiVariable variable;
            IElementType operationSign = expression2.getOperationTokenType();
            if (operationSign == JavaTokenType.EXCL) {
                PsiElement topStartStatement = this.myStartStatementStack.peekElement();
                boolean topAtStart = this.myStartStatementStack.peekAtStart();
                this.myStartStatementStack.pushStatement(this.myEndStatementStack.peekElement(), this.myEndStatementStack.peekAtStart());
                this.myEndStatementStack.pushStatement(topStartStatement, topAtStart);
            }
            operand2.accept((PsiElementVisitor)this);
            if (operationSign == JavaTokenType.EXCL) {
                this.myStartStatementStack.popStatement();
                this.myEndStatementStack.popStatement();
            }
            if (operand2 instanceof PsiReferenceExpression && (operationSign == JavaTokenType.PLUSPLUS || operationSign == JavaTokenType.MINUSMINUS) && (variable = this.getUsedVariable((PsiReferenceExpression)operand2)) != null) {
                this.generateWriteInstruction(variable);
            }
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        PsiVariable variable;
        this.startElement((PsiElement)expression2);
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept((PsiElementVisitor)this);
        }
        if ((variable = this.getUsedVariable(expression2)) != null) {
            this.generateReadInstruction(variable);
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitSuperExpression(PsiSuperExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.finishElement((PsiElement)expression2);
    }

    public void visitThisExpression(PsiThisExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.finishElement((PsiElement)expression2);
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression operand2 = expression2.getOperand();
        if (operand2 != null) {
            operand2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitClass(PsiClass aClass) {
        PsiElement arguments;
        this.startElement((PsiElement)aClass);
        if (aClass instanceof PsiAnonymousClass && (arguments = PsiTreeUtil.getChildOfType((PsiElement)aClass, PsiExpressionList.class)) != null) {
            arguments.accept((PsiElementVisitor)this);
        }
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        this.addUsedVariables(array, (PsiElement)aClass);
        for (PsiVariable var : array) {
            ProgressManager.checkCanceled();
            this.generateReadInstruction(var);
        }
        this.finishElement((PsiElement)aClass);
    }

    private void addUsedVariables(@NotNull List<PsiVariable> array, @NotNull PsiElement scope) {
        PsiElement[] children2;
        PsiVariable variable;
        if (scope instanceof PsiReferenceExpression && (variable = this.getUsedVariable((PsiReferenceExpression)scope)) != null && !array.contains(variable)) {
            array.add(variable);
        }
        for (PsiElement child : children2 = scope.getChildren()) {
            ProgressManager.checkCanceled();
            this.addUsedVariables(array, child);
        }
    }

    private void generateReadInstruction(@NotNull PsiVariable variable) {
        ReadVariableInstruction instruction = new ReadVariableInstruction(variable);
        this.myCurrentFlow.addInstruction(instruction);
    }

    private void generateWriteInstruction(@NotNull PsiVariable variable) {
        WriteVariableInstruction instruction = new WriteVariableInstruction(variable);
        this.myCurrentFlow.addInstruction(instruction);
    }

    @Nullable
    private PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        return this.myPolicy.getUsedVariable(refExpr);
    }

    private static class FinallyBlockSubroutine {
        private final PsiElement myElement;
        private final List<CallInstruction> myCalls;

        public FinallyBlockSubroutine(@NotNull PsiElement element) {
            this.myElement = element;
            this.myCalls = new ArrayList<CallInstruction>();
        }

        @NotNull
        public PsiElement getElement() {
            return this.myElement;
        }

        @NotNull
        public List<CallInstruction> getCalls() {
            return this.myCalls;
        }

        private void addCall(@NotNull CallInstruction callInstruction) {
            this.myCalls.add(callInstruction);
        }
    }

    private static enum Shortcut {
        NO_SHORTCUT,
        SKIP_CURRENT_OPERAND,
        STOP_EXPRESSION;

    }

    private static class StatementStack {
        private final Stack<PsiElement> myStatements = new Stack();
        private final TIntArrayList myAtStart = new TIntArrayList();

        private StatementStack() {
        }

        private void popStatement() {
            this.myAtStart.remove(this.myAtStart.size() - 1);
            this.myStatements.pop();
        }

        @NotNull
        private PsiElement peekElement() {
            return (PsiElement)this.myStatements.peek();
        }

        private boolean peekAtStart() {
            return this.myAtStart.get(this.myAtStart.size() - 1) == 1;
        }

        private void pushStatement(@NotNull PsiElement statement2, boolean atStart) {
            this.myStatements.push((Object)statement2);
            this.myAtStart.add(atStart ? 1 : 0);
        }
    }
}

