/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowAnalyzer;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ControlFlowFactory {
    private final ConcurrentMap<PsiElement, ConcurrentList<ControlFlowContext>> cachedFlows = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private static final NotNullLazyKey<ControlFlowFactory, Project> INSTANCE_KEY = ServiceManager.createLazyKey(ControlFlowFactory.class);

    public static ControlFlowFactory getInstance(Project project2) {
        return (ControlFlowFactory)INSTANCE_KEY.getValue((UserDataHolder)project2);
    }

    public ControlFlowFactory(PsiManagerEx psiManager) {
        psiManager.registerRunnableToRunOnChange(() -> this.clearCache());
    }

    private void clearCache() {
        this.cachedFlows.clear();
    }

    void registerSubRange(PsiElement codeFragment, ControlFlowSubRange flow, boolean evaluateConstantIfConfition, boolean enableShortCircuit, ControlFlowPolicy policy) {
        this.registerControlFlow(codeFragment, flow, evaluateConstantIfConfition, enableShortCircuit, policy);
    }

    @NotNull
    public ControlFlow getControlFlow(@NotNull PsiElement element, @NotNull ControlFlowPolicy policy) throws AnalysisCanceledException {
        return this.getControlFlow(element, policy, true, true);
    }

    @NotNull
    public ControlFlow getControlFlow(@NotNull PsiElement element, @NotNull ControlFlowPolicy policy, boolean evaluateConstantIfCondition) throws AnalysisCanceledException {
        return this.getControlFlow(element, policy, true, evaluateConstantIfCondition);
    }

    @NotNull
    public ControlFlow getControlFlow(@NotNull PsiElement element, @NotNull ControlFlowPolicy policy, boolean enableShortCircuit, boolean evaluateConstantIfCondition) throws AnalysisCanceledException {
        ControlFlowContext context2;
        long modificationCount = element.getManager().getModificationTracker().getModificationCount();
        ConcurrentList<ControlFlowContext> cached = this.getOrCreateCachedFlowsForElement(element);
        for (ControlFlowContext context2 : cached) {
            if (!context2.isFor(policy, evaluateConstantIfCondition, enableShortCircuit, modificationCount)) continue;
            return context2.controlFlow;
        }
        ControlFlow controlFlow = new ControlFlowAnalyzer(element, policy, enableShortCircuit, evaluateConstantIfCondition).buildControlFlow();
        context2 = ControlFlowFactory.createContext(evaluateConstantIfCondition, enableShortCircuit, policy, controlFlow, modificationCount);
        cached.addIfAbsent((Object)context2);
        return controlFlow;
    }

    @NotNull
    private static ControlFlowContext createContext(boolean evaluateConstantIfCondition, boolean enableShortCircuit, @NotNull ControlFlowPolicy policy, @NotNull ControlFlow controlFlow, long modificationCount) {
        return new ControlFlowContext(evaluateConstantIfCondition, enableShortCircuit, policy, modificationCount, controlFlow);
    }

    private void registerControlFlow(@NotNull PsiElement element, @NotNull ControlFlow flow, boolean evaluateConstantIfCondition, boolean enableShortCircuit, @NotNull ControlFlowPolicy policy) {
        long modificationCount = element.getManager().getModificationTracker().getModificationCount();
        ControlFlowContext controlFlowContext = ControlFlowFactory.createContext(evaluateConstantIfCondition, enableShortCircuit, policy, flow, modificationCount);
        ConcurrentList<ControlFlowContext> cached = this.getOrCreateCachedFlowsForElement(element);
        cached.addIfAbsent((Object)controlFlowContext);
    }

    @NotNull
    private ConcurrentList<ControlFlowContext> getOrCreateCachedFlowsForElement(@NotNull PsiElement element) {
        ConcurrentList cached = (ConcurrentList)this.cachedFlows.get(element);
        if (cached == null) {
            cached = ContainerUtil.createConcurrentList();
            this.cachedFlows.put(element, (ConcurrentList<ControlFlowContext>)cached);
        }
        return cached;
    }

    private static class ControlFlowContext {
        private final ControlFlowPolicy policy;
        private final boolean evaluateConstantIfCondition;
        private final boolean enableShortCircuit;
        private final long modificationCount;
        private final ControlFlow controlFlow;

        private ControlFlowContext(boolean evaluateConstantIfCondition, boolean enableShortCircuit, @NotNull ControlFlowPolicy policy, long modificationCount, @NotNull ControlFlow controlFlow) {
            this.evaluateConstantIfCondition = evaluateConstantIfCondition;
            this.enableShortCircuit = enableShortCircuit;
            this.policy = policy;
            this.modificationCount = modificationCount;
            this.controlFlow = controlFlow;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ControlFlowContext that = (ControlFlowContext)o;
            return this.isFor(that);
        }

        public int hashCode() {
            int result2 = this.policy.hashCode();
            result2 = 31 * result2 + (this.evaluateConstantIfCondition ? 1 : 0);
            result2 = 31 * result2 + (int)(this.modificationCount ^ this.modificationCount >>> 32);
            return result2;
        }

        private boolean isFor(@NotNull ControlFlowPolicy policy, boolean evaluateConstantIfCondition, boolean enableShortCircuit, long modificationCount) {
            if (modificationCount != this.modificationCount) {
                return false;
            }
            if (!policy.equals(this.policy)) {
                return false;
            }
            if (enableShortCircuit != this.enableShortCircuit) {
                return false;
            }
            if (!this.controlFlow.isConstantConditionOccurred()) {
                return true;
            }
            return evaluateConstantIfCondition == this.evaluateConstantIfCondition;
        }

        private boolean isFor(@NotNull ControlFlowContext that) {
            return this.isFor(that.policy, that.evaluateConstantIfCondition, that.enableShortCircuit, that.modificationCount);
        }
    }
}

