/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class MinifiedFilesUtil {
    private static final int MAX_OFFSET = 2048;
    private static final int MIN_SIZE = 150;
    private static final double MAX_UNNEEDED_OFFSET_PERCENTAGE = 0.01;
    private static final int COUNT_OF_CONSIDERING_CHARACTERS_FROM_END_OF_FILE = 400;

    private MinifiedFilesUtil() {
    }

    public static boolean isMinified(@NotNull CharSequence fileContent, @NotNull ParserDefinition parserDefinition, @NotNull TokenSet noWSRequireBeforeTokenSet, @NotNull TokenSet noWSRequireAfterTokenSet) {
        return MinifiedFilesUtil.isMinified(fileContent, parserDefinition, noWSRequireBeforeTokenSet, noWSRequireAfterTokenSet, parserDefinition.getStringLiteralElements());
    }

    public static boolean isMinified(@NotNull CharSequence fileContent, @NotNull ParserDefinition parserDefinition, @NotNull TokenSet noWSRequireBeforeTokenSet, @NotNull TokenSet noWSRequireAfterTokenSet, @NotNull TokenSet stringsTokenSet) {
        Lexer lexer = parserDefinition.createLexer(null);
        lexer.start(fileContent);
        if (!MinifiedFilesUtil.isMinified(lexer, parserDefinition, noWSRequireBeforeTokenSet, noWSRequireAfterTokenSet, stringsTokenSet)) {
            return false;
        }
        if (lexer.getTokenType() == null) {
            return true;
        }
        int startOffset = fileContent.length() - 400;
        if (startOffset <= 0) {
            return true;
        }
        lexer.start(fileContent, startOffset, fileContent.length());
        return MinifiedFilesUtil.isMinified(lexer, parserDefinition, noWSRequireBeforeTokenSet, noWSRequireAfterTokenSet, stringsTokenSet);
    }

    protected static boolean isMinified(@NotNull Lexer lexer, @NotNull ParserDefinition parserDefinition, @NotNull TokenSet noWSRequireBeforeTokenSet, @NotNull TokenSet noWSRequireAfterTokenSet, @NotNull TokenSet stringLiteralElements) {
        int offsetIgnoringComments = 0;
        int offsetIgnoringCommentsAndStrings = 0;
        int unneededWhitespaceCount = 0;
        String lastTokenText = null;
        IElementType lastTokenType = null;
        TokenSet whitespaceTokens = parserDefinition.getWhitespaceTokens();
        TokenSet commentTokens = parserDefinition.getCommentTokens();
        boolean lastWhiteSpaceWasHandled = false;
        IElementType tokenType = lexer.getTokenType();
        while (tokenType != null) {
            if (commentTokens.contains(tokenType)) {
                lastTokenType = tokenType;
                lastTokenText = lexer.getTokenText();
            } else {
                int tokenLength = lexer.getTokenEnd() - lexer.getTokenStart();
                if (!MinifiedFilesUtil.isNewLine(lexer, tokenLength) || !commentTokens.contains(lastTokenType) || noWSRequireAfterTokenSet.contains(lastTokenType)) {
                    offsetIgnoringComments += tokenLength;
                    if (!stringLiteralElements.contains(tokenType)) {
                        offsetIgnoringCommentsAndStrings += tokenLength;
                    }
                    if (whitespaceTokens.contains(tokenType)) {
                        lastWhiteSpaceWasHandled = false;
                        if (!commentTokens.contains(lastTokenType) && tokenLength > 1) {
                            lexer.advance();
                            if (lexer.getTokenType() == null) break;
                            return false;
                        }
                        if (MinifiedFilesUtil.isNewLine(lexer, tokenLength) && StringUtil.equals((CharSequence)lastTokenText, (CharSequence)"\n") || tokenLength > 0 && noWSRequireAfterTokenSet.contains(lastTokenType)) {
                            ++unneededWhitespaceCount;
                            lastWhiteSpaceWasHandled = true;
                        }
                    } else if (!lastWhiteSpaceWasHandled && whitespaceTokens.contains(lastTokenType) && StringUtil.isNotEmpty((String)lastTokenText) && noWSRequireBeforeTokenSet.contains(tokenType)) {
                        ++unneededWhitespaceCount;
                    }
                    if (stringLiteralElements.contains(tokenType)) {
                        lastTokenType = tokenType;
                        lastTokenText = lexer.getTokenText();
                    } else {
                        if (offsetIgnoringComments >= 2048) break;
                        lastTokenType = tokenType;
                        lastTokenText = lexer.getTokenText();
                    }
                }
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
        return offsetIgnoringComments >= 150 && ((double)unneededWhitespaceCount + 0.0) / (double)offsetIgnoringCommentsAndStrings < 0.01;
    }

    private static boolean isNewLine(@NotNull Lexer lexer, int tokenLength) {
        return tokenLength == 1 && StringUtil.equals((CharSequence)lexer.getTokenText(), (CharSequence)"\n");
    }

    public static boolean isMinified(@NotNull CharSequence fileContent, @NotNull ParserDefinition parserDefinition) {
        return MinifiedFilesUtil.isMinified(fileContent, parserDefinition, TokenSet.EMPTY, TokenSet.EMPTY);
    }
}

