/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InjectedLanguageBlockWrapper
implements BlockEx {
    private final Block myOriginal;
    private final int myOffset;
    private final TextRange myRange;
    @Nullable
    private final Indent myIndent;
    @Nullable
    private final Language myLanguage;
    private List<Block> myBlocks;

    public InjectedLanguageBlockWrapper(@NotNull Block original, int offset, @Nullable TextRange range, @Nullable Indent indent) {
        this(original, offset, range, indent, null);
    }

    public InjectedLanguageBlockWrapper(@NotNull Block original, int offset, @Nullable TextRange range, @Nullable Indent indent, @Nullable Language language) {
        this.myOriginal = original;
        this.myOffset = offset;
        this.myRange = range;
        this.myIndent = indent;
        this.myLanguage = language;
    }

    public Indent getIndent() {
        return this.myIndent != null ? this.myIndent : this.myOriginal.getIndent();
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myOriginal.getAlignment();
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange range = this.myOriginal.getTextRange();
        if (this.myRange != null) {
            range = range.intersection(this.myRange);
        }
        int start = this.myOffset + range.getStartOffset() - (this.myRange != null ? this.myRange.getStartOffset() : 0);
        return TextRange.from((int)start, (int)range.getLength());
    }

    @Override
    @Nullable
    public Language getLanguage() {
        return this.myLanguage;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.myBlocks == null) {
            this.myBlocks = this.buildBlocks();
        }
        return this.myBlocks;
    }

    private List<Block> buildBlocks() {
        List list = this.myOriginal.getSubBlocks();
        if (list.isEmpty()) {
            return AbstractBlock.EMPTY;
        }
        if (this.myOffset == 0 && this.myRange == null) {
            return list;
        }
        ArrayList<Block> result2 = new ArrayList<Block>(list.size());
        if (this.myRange == null) {
            for (Block block : list) {
                result2.add(new InjectedLanguageBlockWrapper(block, this.myOffset, this.myRange, null, this.myLanguage));
            }
        } else {
            this.collectBlocksIntersectingRange(list, result2, this.myRange);
        }
        return result2;
    }

    private void collectBlocksIntersectingRange(List<Block> list, List<Block> result2, @NotNull TextRange range) {
        for (Block block : list) {
            TextRange textRange = block.getTextRange();
            if (block instanceof InjectedLanguageBlockWrapper && block.getTextRange().equals((Object)range)) continue;
            if (range.contains(textRange)) {
                result2.add(new InjectedLanguageBlockWrapper(block, this.myOffset, range, null, this.myLanguage));
                continue;
            }
            if (!textRange.intersectsStrict(range)) continue;
            this.collectBlocksIntersectingRange(block.getSubBlocks(), result2, range);
        }
    }

    @Nullable
    public Wrap getWrap() {
        return this.myOriginal.getWrap();
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        Spacing spacing;
        int shift = 0;
        Block child1ToUse = child1;
        Block child2ToUse = child2;
        if (child1 instanceof InjectedLanguageBlockWrapper) {
            child1ToUse = ((InjectedLanguageBlockWrapper)child1).myOriginal;
            shift = child1.getTextRange().getStartOffset() - child1ToUse.getTextRange().getStartOffset();
        }
        if (child2 instanceof InjectedLanguageBlockWrapper) {
            child2ToUse = ((InjectedLanguageBlockWrapper)child2).myOriginal;
        }
        if ((spacing = this.myOriginal.getSpacing(child1ToUse, child2ToUse)) instanceof DependantSpacingImpl && shift != 0) {
            DependantSpacingImpl hostSpacing = (DependantSpacingImpl)spacing;
            int finalShift = shift;
            List shiftedRanges = ContainerUtil.map(hostSpacing.getDependentRegionRanges(), range -> range.shiftRight(finalShift));
            return new DependantSpacingImpl(hostSpacing.getMinSpaces(), hostSpacing.getMaxSpaces(), shiftedRanges, hostSpacing.shouldKeepLineFeeds(), hostSpacing.getKeepBlankLines(), DependentSpacingRule.DEFAULT);
        }
        return spacing;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return this.myOriginal.getChildAttributes(newChildIndex);
    }

    public boolean isIncomplete() {
        return this.myOriginal.isIncomplete();
    }

    public boolean isLeaf() {
        return this.myOriginal.isLeaf();
    }

    public String toString() {
        return this.myOriginal.toString();
    }

    public Block getOriginal() {
        return this.myOriginal;
    }
}

