/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.BlockFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ChildrenBlocksBuilder {
    private Config myConfig;

    private ChildrenBlocksBuilder(Config builder) {
        this.myConfig = builder;
    }

    public List<Block> buildNodeChildBlocks(ASTNode node, BlockFactory factory) {
        ArrayList blocks = ContainerUtil.newArrayList();
        for (ASTNode child : node.getChildren(null)) {
            if (FormatterUtil.isWhitespaceOrEmpty(child) || child.getTextLength() == 0) continue;
            Alignment alignment = this.myConfig.getAlignment(child);
            IElementType type2 = child.getElementType();
            Indent indent = this.myConfig.getIndent(type2);
            Wrap wrap = this.myConfig.getWrap(type2);
            blocks.add(factory.createBlock(child, indent, alignment, wrap));
        }
        return blocks;
    }

    public static class Config {
        private static final Alignment NO_ALIGNMENT = Alignment.createAlignment();
        private static final Wrap NO_WRAP = Wrap.createWrap((int)0, (boolean)false);
        private Map<IElementType, Alignment> myAlignments = ContainerUtil.newHashMap();
        private Map<IElementType, Indent> myIndents = ContainerUtil.newHashMap();
        private Map<IElementType, Wrap> myWraps = ContainerUtil.newHashMap();
        private Map<IElementType, Condition<ASTNode>> myNoneAlignmentCondition = ContainerUtil.newHashMap();
        private Alignment myDefaultAlignment;
        private Indent myDefaultIndent;
        private Wrap myDefaultWrap;

        public ChildrenBlocksBuilder createBuilder() {
            return new ChildrenBlocksBuilder(this);
        }

        public Config setDefaultAlignment(Alignment alignment) {
            this.myDefaultAlignment = alignment;
            return this;
        }

        public Config setDefaultWrap(Wrap wrap) {
            this.myDefaultWrap = wrap;
            return this;
        }

        public Config setDefaultIndent(Indent indent) {
            this.myDefaultIndent = indent;
            return this;
        }

        public Config setAlignment(@NotNull IElementType elementType, @NotNull Alignment alignment) {
            this.myAlignments.put(elementType, alignment);
            return this;
        }

        public Config setNoAlignment(IElementType elementType) {
            this.myAlignments.put(elementType, NO_ALIGNMENT);
            return this;
        }

        public Config setNoAlignmentIf(IElementType elementType, Condition<ASTNode> applyAlignCondition) {
            this.myNoneAlignmentCondition.put(elementType, applyAlignCondition);
            return this;
        }

        public Config setIndent(IElementType elementType, Indent indent) {
            this.myIndents.put(elementType, indent);
            return this;
        }

        private Indent getIndent(IElementType elementType) {
            Indent indent = this.myIndents.get(elementType);
            return indent != null ? indent : this.myDefaultIndent;
        }

        private Alignment getAlignment(ASTNode node) {
            IElementType elementType = node.getElementType();
            Condition<ASTNode> noneAlignmentCondition = this.myNoneAlignmentCondition.get(elementType);
            if (noneAlignmentCondition != null && noneAlignmentCondition.value((Object)node)) {
                return null;
            }
            Alignment alignment = this.myAlignments.get(elementType);
            if (alignment == null) {
                return this.myDefaultAlignment;
            }
            return alignment == NO_ALIGNMENT ? null : alignment;
        }

        private Wrap getWrap(IElementType elementType) {
            Wrap wrap = this.myWraps.get(elementType);
            if (wrap == NO_WRAP) {
                return null;
            }
            return wrap != null ? wrap : this.myDefaultWrap;
        }

        public Config setNoWrap(IElementType elementType) {
            this.myWraps.put(elementType, NO_WRAP);
            return this;
        }
    }
}

