/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeShortNamesCache
extends PsiShortNamesCache {
    private final PsiShortNamesCache[] myCaches;

    public CompositeShortNamesCache(Project project2) {
        this.myCaches = project2.isDefault() ? new PsiShortNamesCache[]{} : (PsiShortNamesCache[])project2.getExtensions(PsiShortNamesCache.EP_NAME);
    }

    @NotNull
    public PsiFile[] getFilesByName(@NotNull String name) {
        Merger<PsiFile> merger = null;
        for (PsiShortNamesCache cache2 : this.myCaches) {
            PsiFile[] classes2 = cache2.getFilesByName(name);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiFile>();
            }
            merger.add(classes2);
        }
        PsiFile[] result2 = merger == null ? null : (PsiFile[])merger.getResult();
        return result2 != null ? result2 : PsiFile.EMPTY_ARRAY;
    }

    @NotNull
    public String[] getAllFileNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache2 : this.myCaches) {
            merger.add(cache2.getAllFileNames());
        }
        String[] result2 = (String[])merger.getResult();
        return result2 != null ? result2 : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        Merger<PsiClass> merger = null;
        for (PsiShortNamesCache cache2 : this.myCaches) {
            PsiClass[] classes2 = cache2.getClassesByName(name, scope);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiClass>();
            }
            merger.add(classes2);
        }
        PsiClass[] result2 = merger == null ? null : (PsiClass[])merger.getResult();
        return result2 != null ? result2 : PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public String[] getAllClassNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache2 : this.myCaches) {
            String[] names = cache2.getAllClassNames();
            merger.add(names);
        }
        String[] result2 = (String[])merger.getResult();
        return result2 != null ? result2 : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public boolean processAllClassNames(Processor<String> processor2) {
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor2);
        for (PsiShortNamesCache cache2 : this.myCaches) {
            if (cache2.processAllClassNames((Processor)uniqueProcessor)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllClassNames(Processor<String> processor2, GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache2 : this.myCaches) {
            if (cache2.processAllClassNames(processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllMethodNames(Processor<String> processor2, GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache2 : this.myCaches) {
            if (cache2.processAllMethodNames(processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllFieldNames(Processor<String> processor2, GlobalSearchScope scope, IdFilter filter) {
        for (PsiShortNamesCache cache2 : this.myCaches) {
            if (cache2.processAllFieldNames(processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public void getAllClassNames(@NotNull HashSet<String> dest) {
        for (PsiShortNamesCache cache2 : this.myCaches) {
            cache2.getAllClassNames(dest);
        }
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache2 : this.myCaches) {
            PsiMethod[] methods = cache2.getMethodsByName(name, scope);
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        PsiMethod[] result2 = merger == null ? null : (PsiMethod[])merger.getResult();
        return result2 == null ? PsiMethod.EMPTY_ARRAY : result2;
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache2 : this.myCaches) {
            PsiMethod[] methods = cache2.getMethodsByNameIfNotMoreThan(name, scope, maxCount);
            if (methods.length == maxCount) {
                return methods;
            }
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        PsiMethod[] result2 = merger == null ? null : (PsiMethod[])merger.getResult();
        return result2 == null ? PsiMethod.EMPTY_ARRAY : result2;
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache2 : this.myCaches) {
            PsiField[] fields = cache2.getFieldsByNameIfNotMoreThan(name, scope, maxCount);
            if (fields.length == maxCount) {
                return fields;
            }
            if (fields.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(fields);
        }
        PsiField[] result2 = merger == null ? null : (PsiField[])merger.getResult();
        return result2 == null ? PsiField.EMPTY_ARRAY : result2;
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor2) {
        return this.processMethodsWithName(name, processor2, scope, null);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        for (PsiShortNamesCache cache2 : this.myCaches) {
            if (cache2.processMethodsWithName(name, processor2, scope, idFilter)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String[] getAllMethodNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache2 : this.myCaches) {
            merger.add(cache2.getAllMethodNames());
        }
        String[] result2 = (String[])merger.getResult();
        return result2 != null ? result2 : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set2) {
        for (PsiShortNamesCache cache2 : this.myCaches) {
            cache2.getAllMethodNames(set2);
        }
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache2 : this.myCaches) {
            PsiField[] classes2 = cache2.getFieldsByName(name, scope);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(classes2);
        }
        PsiField[] result2 = merger == null ? null : (PsiField[])merger.getResult();
        return result2 == null ? PsiField.EMPTY_ARRAY : result2;
    }

    @NotNull
    public String[] getAllFieldNames() {
        Merger<String> merger = null;
        for (PsiShortNamesCache cache2 : this.myCaches) {
            String[] classes2 = cache2.getAllFieldNames();
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<String>();
            }
            merger.add(classes2);
        }
        String[] result2 = merger == null ? null : (String[])merger.getResult();
        return result2 == null ? ArrayUtil.EMPTY_STRING_ARRAY : result2;
    }

    public void getAllFieldNames(@NotNull HashSet<String> set2) {
        for (PsiShortNamesCache cache2 : this.myCaches) {
            cache2.getAllFieldNames(set2);
        }
    }

    public boolean processFieldsWithName(@NotNull String key2, @NotNull Processor<? super PsiField> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        for (PsiShortNamesCache cache2 : this.myCaches) {
            if (cache2.processFieldsWithName(key2, processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processClassesWithName(@NotNull String key2, @NotNull Processor<? super PsiClass> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        for (PsiShortNamesCache cache2 : this.myCaches) {
            if (cache2.processClassesWithName(key2, processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Composite cache: " + Arrays.asList(this.myCaches);
    }

    private static class Merger<T> {
        private T[] mySingleItem;
        private Set<T> myAllItems;

        private Merger() {
        }

        public void add(@NotNull T[] items) {
            if (items.length == 0) {
                return;
            }
            if (this.mySingleItem == null) {
                this.mySingleItem = items;
                return;
            }
            if (this.myAllItems == null) {
                Object[] elements = this.mySingleItem;
                this.myAllItems = (Set)ContainerUtil.addAll((Collection)new THashSet(elements.length), (Object[])elements);
            }
            ContainerUtil.addAll(this.myAllItems, (Object[])items);
        }

        public T[] getResult() {
            if (this.myAllItems == null) {
                return this.mySingleItem;
            }
            return this.myAllItems.toArray(this.mySingleItem);
        }
    }
}

