/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomDescriptionProvider;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomTarget;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import org.jetbrains.annotations.NotNull;

public class DefaultPomTargetDescriptionProvider
extends PomDescriptionProvider {
    public String getElementDescription(@NotNull PomTarget element, @NotNull ElementDescriptionLocation location) {
        if (element instanceof PsiElement) {
            return null;
        }
        if (location == UsageViewTypeLocation.INSTANCE) {
            return DefaultPomTargetDescriptionProvider.getTypeName(element);
        }
        if (location == UsageViewNodeTextLocation.INSTANCE) {
            return DefaultPomTargetDescriptionProvider.getTypeName(element) + " " + StringUtil.notNullize((String)(element instanceof PomNamedTarget ? ((PomNamedTarget)element).getName() : null), (String)"''");
        }
        if (location instanceof HighlightUsagesDescriptionLocation) {
            return DefaultPomTargetDescriptionProvider.getTypeName(element);
        }
        return null;
    }

    private static String getTypeName(PomTarget element) {
        String s = TypePresentationService.getService().getTypePresentableName(element.getClass());
        return s == null ? "Element" : s;
    }
}

