/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

class EmptyFileManager
implements FileManager {
    private final PsiManagerImpl myManager;
    private final ConcurrentMap<VirtualFile, FileViewProvider> myVFileToViewProviderMap = ContainerUtil.createConcurrentWeakValueMap();

    EmptyFileManager(PsiManagerImpl manager) {
        this.myManager = manager;
    }

    public void dispose() {
    }

    @Override
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider == null ? null : viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        return null;
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file2) {
    }

    @Override
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        return null;
    }

    @Override
    public void cleanupForNextTest() {
        this.myVFileToViewProviderMap.clear();
    }

    @Override
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        return (FileViewProvider)this.myVFileToViewProviderMap.get(file2);
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file2) {
        return (FileViewProvider)this.myVFileToViewProviderMap.get(file2);
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, boolean eventSystemEnabled) {
        return new SingleRootFileViewProvider(this.myManager, file2, eventSystemEnabled);
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, FileViewProvider singleRootFileViewProvider) {
        if (!(virtualFile instanceof VirtualFileWindow)) {
            if (singleRootFileViewProvider == null) {
                this.myVFileToViewProviderMap.remove(virtualFile);
            } else {
                this.myVFileToViewProviderMap.put(virtualFile, singleRootFileViewProvider);
            }
        }
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        return Collections.emptyList();
    }
}

