/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessorBase;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCodeBlockModificationListener
extends PsiTreeChangePreprocessorBase {
    public JavaCodeBlockModificationListener(@NotNull PsiManager psiManager) {
        super(psiManager);
    }

    @Override
    protected boolean acceptsEvent(@NotNull PsiTreeChangeEventImpl event) {
        return event.getFile() instanceof PsiClassOwner;
    }

    @Override
    protected boolean isOutOfCodeBlock(@NotNull PsiElement element) {
        for (PsiElement e : SyntaxTraverser.psiApi().parents((Object)element)) {
            if (e instanceof PsiModifiableCodeBlock && !((PsiModifiableCodeBlock)e).shouldChangeModificationCount(element)) {
                return false;
            }
            if (!(e instanceof PsiClass) && !(e instanceof PsiClassOwner) && !(e instanceof JspDirective)) continue;
            break;
        }
        return true;
    }

    @Override
    protected boolean isOutOfCodeBlock(@NotNull PsiFileSystemItem file2) {
        if (file2 instanceof PsiModifiableCodeBlock) {
            return ((PsiModifiableCodeBlock)file2).shouldChangeModificationCount((PsiElement)file2);
        }
        return super.isOutOfCodeBlock(file2);
    }

    @Override
    protected void onTreeChanged(@NotNull PsiTreeChangeEventImpl event) {
        PsiTreeChangeEventImpl.PsiEventType code2;
        PsiModificationTracker tracker = this.myPsiManager.getModificationTracker();
        long cur = tracker.getOutOfCodeBlockModificationCount();
        super.onTreeChanged(event);
        if (cur == tracker.getOutOfCodeBlockModificationCount() && ((code2 = event.getCode()) == PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED || code2 == PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED || code2 == PsiTreeChangeEventImpl.PsiEventType.CHILD_REPLACED) && (JavaCodeBlockModificationListener.hasClassesInside(event.getOldChild()) || event.getOldChild() != event.getChild() && JavaCodeBlockModificationListener.hasClassesInside(event.getChild()))) {
            this.onOutOfCodeBlockModification(event);
            this.doIncOutOfCodeBlockCounter();
        }
    }

    @Override
    protected void doIncOutOfCodeBlockCounter() {
        ((PsiModificationTrackerImpl)this.myPsiManager.getModificationTracker()).incCounter();
    }

    private static boolean hasClassesInside(@Nullable PsiElement element) {
        return !SyntaxTraverser.psiTraverser((PsiElement)element).traverse().filter(Conditions.instanceOf((Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})).isEmpty();
    }
}

