/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.arrangement.MemberOrderService;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiImplementationHelperImpl
extends JavaPsiImplementationHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.JavaPsiImplementationHelperImpl");
    private final Project myProject;

    public JavaPsiImplementationHelperImpl(Project project2) {
        this.myProject = project2;
    }

    @Override
    public PsiClass getOriginalClass(PsiClass psiClass) {
        PsiCompiledElement cls = (PsiCompiledElement)psiClass.getUserData(ClsElementImpl.COMPILED_ELEMENT);
        if (cls != null && cls.isValid()) {
            return (PsiClass)cls;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            return psiClass;
        }
        VirtualFile vFile = psiClass.getContainingFile().getVirtualFile();
        ProjectFileIndex idx = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (vFile == null || !idx.isInLibrarySource(vFile)) {
            return psiClass;
        }
        String fqn = psiClass.getQualifiedName();
        if (fqn == null) {
            return psiClass;
        }
        HashSet orderEntries = ContainerUtil.newHashSet((Iterable)idx.getOrderEntriesForFile(vFile));
        GlobalSearchScope librariesScope = LibraryScopeCache.getInstance(this.myProject).getLibrariesOnlyScope();
        for (PsiClass original : JavaPsiFacade.getInstance((Project)this.myProject).findClasses(fqn, librariesScope)) {
            VirtualFile candidateFile;
            PsiFile psiFile = original.getContainingFile();
            if (psiFile == null || (candidateFile = psiFile.getVirtualFile()) == null) continue;
            List entries = idx.getOrderEntriesForFile(candidateFile);
            for (int i2 = 0; i2 < entries.size(); ++i2) {
                if (!orderEntries.contains(entries.get(i2))) continue;
                return original;
            }
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiElement getClsFileNavigationElement(PsiJavaFile clsFile) {
        PsiClass[] classes2 = clsFile.getClasses();
        if (classes2.length == 0) {
            return clsFile;
        }
        String sourceFileName = ((ClsClassImpl)classes2[0]).getSourceFileName();
        String packageName = clsFile.getPackageName();
        String relativePath = packageName.isEmpty() ? sourceFileName : packageName.replace('.', '/') + '/' + sourceFileName;
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)clsFile.getProject());
        for (OrderEntry orderEntry : index.getOrderEntriesForFile(clsFile.getContainingFile().getVirtualFile())) {
            if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
            for (VirtualFile root : orderEntry.getFiles(OrderRootType.SOURCES)) {
                PsiFile psiSource;
                VirtualFile source = root.findFileByRelativePath(relativePath);
                if (source == null || !source.isValid() || !((psiSource = clsFile.getManager().findFile(source)) instanceof PsiClassOwner)) continue;
                return psiSource;
            }
        }
        return clsFile;
    }

    @Override
    @NotNull
    public LanguageLevel getEffectiveLanguageLevel(@Nullable VirtualFile virtualFile) {
        LanguageLevel level;
        if (virtualFile == null) {
            return PsiUtil.getLanguageLevel((Project)this.myProject);
        }
        if (this.myProject.isDefault()) {
            return PsiUtil.getLanguageLevel((Project)this.myProject);
        }
        VirtualFile folder = virtualFile.getParent();
        if (folder != null && (level = (LanguageLevel)folder.getUserData(LanguageLevel.KEY)) != null) {
            return level;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        Module module2 = index.getModuleForFile(virtualFile);
        if (module2 != null && index.isInSourceContent(virtualFile)) {
            return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module2);
        }
        LanguageLevel classesLanguageLevel = this.getClassesLanguageLevel(virtualFile);
        return classesLanguageLevel != null ? classesLanguageLevel : PsiUtil.getLanguageLevel((Project)this.myProject);
    }

    @Nullable
    private LanguageLevel getClassesLanguageLevel(VirtualFile virtualFile) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile sourceRoot = index.getSourceRootForFile(virtualFile);
        VirtualFile folder = virtualFile.getParent();
        if (sourceRoot != null && sourceRoot.isDirectory() && folder != null) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)folder, (VirtualFile)sourceRoot, (char)'/');
            if (relativePath == null) {
                LOG.error("Null relative path: folder=" + folder + "; root=" + sourceRoot);
                return null;
            }
            String className = virtualFile.getNameWithoutExtension();
            HashSet visitedRoots = ContainerUtil.newHashSet();
            for (OrderEntry entry : index.getOrderEntriesForFile(virtualFile)) {
                for (VirtualFile rootFile : entry.getFiles(OrderRootType.CLASSES)) {
                    PsiJavaFile javaFile;
                    if (!visitedRoots.add(rootFile)) continue;
                    VirtualFile classFile = rootFile.findFileByRelativePath(relativePath);
                    PsiJavaFile psiJavaFile = javaFile = classFile == null ? null : this.getPsiFileInRoot(classFile, className);
                    if (javaFile == null) continue;
                    return javaFile.getLanguageLevel();
                }
            }
            return LanguageLevelProjectExtension.getInstance((Project)this.myProject).getLanguageLevel();
        }
        return null;
    }

    @Nullable
    private PsiJavaFile getPsiFileInRoot(VirtualFile dirFile, @Nullable String className) {
        VirtualFile[] children2;
        PsiFile psiFile;
        VirtualFile classFile;
        if (className != null && (classFile = dirFile.findChild(StringUtil.getQualifiedName((String)className, (String)StdFileTypes.CLASS.getDefaultExtension()))) != null && (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(classFile)) instanceof PsiJavaFile) {
            return (PsiJavaFile)psiFile;
        }
        for (VirtualFile child : children2 = dirFile.getChildren()) {
            PsiFile psiFile2;
            if (!StdFileTypes.CLASS.equals(child.getFileType()) || !child.isValid() || !((psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(child)) instanceof PsiJavaFile)) continue;
            return (PsiJavaFile)psiFile2;
        }
        return null;
    }

    @Override
    public ASTNode getDefaultImportAnchor(PsiImportList list, PsiImportStatementBase statement2) {
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)list.getProject());
        ImportHelper importHelper = new ImportHelper(settings);
        return importHelper.getDefaultAnchor(list, statement2);
    }

    @Override
    @Nullable
    public PsiElement getDefaultMemberAnchor(@NotNull PsiClass aClass, @NotNull PsiMember member) {
        PsiElement lBrace;
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)aClass.getProject());
        MemberOrderService service = (MemberOrderService)ServiceManager.getService(MemberOrderService.class);
        PsiElement anchor = service.getAnchor((PsiElement)member, settings.getCommonSettings((Language)JavaLanguage.INSTANCE), (PsiElement)aClass);
        PsiElement newAnchor = JavaPsiImplementationHelperImpl.skipWhitespaces(aClass, anchor);
        if (newAnchor != null) {
            return newAnchor;
        }
        if (anchor != null && anchor != aClass) {
            anchor = anchor.getNextSibling();
            while (anchor instanceof PsiJavaToken && (anchor.getText().equals(",") || anchor.getText().equals(";"))) {
                boolean afterComma = anchor.getText().equals(",");
                anchor = anchor.getNextSibling();
                if (!afterComma || (newAnchor = JavaPsiImplementationHelperImpl.skipWhitespaces(aClass, anchor)) == null) continue;
                return newAnchor;
            }
            if (anchor != null) {
                return anchor;
            }
        }
        if ((lBrace = aClass.getLBrace()) != null) {
            PsiElement result2 = lBrace.getNextSibling();
            while (result2 instanceof PsiWhiteSpace) {
                result2 = result2.getNextSibling();
            }
            return result2;
        }
        return aClass.getRBrace();
    }

    private static PsiElement skipWhitespaces(PsiClass aClass, PsiElement anchor) {
        if (anchor != null && PsiTreeUtil.skipSiblingsForward((PsiElement)anchor, (Class[])new Class[]{PsiWhiteSpace.class}) == aClass.getRBrace()) {
            return aClass.getRBrace();
        }
        return null;
    }

    @Override
    public void setupCatchBlock(@NotNull String exceptionName, @NotNull PsiType exceptionType, PsiElement context, @NotNull PsiCatchSection catchSection) {
        PsiCodeBlock codeBlockFromText;
        PsiDirectory directory;
        FileTemplate catchBodyTemplate = FileTemplateManager.getInstance(catchSection.getProject()).getCodeTemplate("Catch Statement Body.java");
        LOG.assertTrue(catchBodyTemplate != null);
        Properties props = FileTemplateManager.getInstance(this.myProject).getDefaultProperties();
        props.setProperty("EXCEPTION", exceptionName);
        props.setProperty("EXCEPTION_TYPE", exceptionType.getCanonicalText());
        if (context != null && context.isPhysical() && (directory = context.getContainingFile().getContainingDirectory()) != null) {
            JavaTemplateUtil.setPackageNameAttribute(props, directory);
        }
        try {
            codeBlockFromText = PsiElementFactory.SERVICE.getInstance((Project)this.myProject).createCodeBlockFromText("{\n" + catchBodyTemplate.getText(props) + "\n}", null);
        }
        catch (ProcessCanceledException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Incorrect file template", (Throwable)e);
        }
        catchSection.getCatchBlock().replace((PsiElement)codeBlockFromText);
    }
}

