/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiDocumentManagerBase
extends PsiDocumentManager
implements DocumentListener,
ProjectComponent {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiDocumentManagerImpl");
    private static final Key<Document> HARD_REF_TO_DOCUMENT = Key.create((String)"HARD_REFERENCE_TO_DOCUMENT");
    private final Key<PsiFile> HARD_REF_TO_PSI = Key.create((String)"HARD_REF_TO_PSI");
    private static final Key<List<Runnable>> ACTION_AFTER_COMMIT = Key.create((String)"ACTION_AFTER_COMMIT");
    protected final Project myProject;
    private final PsiManager myPsiManager;
    private final DocumentCommitProcessor myDocumentCommitProcessor;
    protected final Set<Document> myUncommittedDocuments = ContainerUtil.newConcurrentSet();
    private final Map<Document, UncommittedInfo> myUncommittedInfos = ContainerUtil.newConcurrentMap();
    protected boolean myStopTrackingDocuments;
    private boolean myPerformBackgroundCommit = true;
    private volatile boolean myIsCommitInProgress;
    private final PsiToDocumentSynchronizer mySynchronizer;
    private final List<PsiDocumentManager.Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Map<Object, Runnable> actionsWhenAllDocumentsAreCommitted = new LinkedHashMap<Object, Runnable>();
    private static final Object PERFORM_ALWAYS_KEY = new Object(){

        @NonNls
        public String toString() {
            return "PERFORM_ALWAYS";
        }
    };

    protected PsiDocumentManagerBase(@NotNull Project project2, @NotNull PsiManager psiManager, @NotNull MessageBus bus, @NonNls @NotNull DocumentCommitProcessor documentCommitProcessor) {
        this.myProject = project2;
        this.myPsiManager = psiManager;
        this.myDocumentCommitProcessor = documentCommitProcessor;
        this.mySynchronizer = new PsiToDocumentSynchronizer(this, bus);
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)this.mySynchronizer);
        bus.connect().subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document document, @NotNull PsiFile file2) {
                PsiDocumentManagerBase.this.myUncommittedDocuments.remove(document);
            }

            @Override
            public void transactionCompleted(@NotNull Document document, @NotNull PsiFile file2) {
            }
        });
    }

    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        if (document instanceof DocumentWindow && !((DocumentWindow)document).isValid()) {
            return null;
        }
        PsiFile userData = (PsiFile)document.getUserData(this.HARD_REF_TO_PSI);
        if (userData != null) {
            return PsiDocumentManagerBase.ensureValidFile(userData, "From hard ref");
        }
        PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            return PsiDocumentManagerBase.ensureValidFile(psiFile, "Cached PSI");
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        psiFile = this.getPsiFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        this.fireFileCreated(document, psiFile);
        return psiFile;
    }

    @NotNull
    private static PsiFile ensureValidFile(@NotNull PsiFile psiFile, @NotNull String debugInfo) {
        if (!psiFile.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)psiFile, debugInfo);
        }
        return psiFile;
    }

    @Deprecated
    public static void cachePsi(@NotNull Document document, @Nullable PsiFile file2) {
        LOG.warn("Unsupported method");
    }

    public void associatePsi(@NotNull Document document, @Nullable PsiFile file2) {
        document.putUserData(this.HARD_REF_TO_PSI, (Object)file2);
    }

    public PsiFile getCachedPsiFile(@NotNull Document document) {
        PsiFile userData = (PsiFile)document.getUserData(this.HARD_REF_TO_PSI);
        if (userData != null) {
            return userData;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return this.getCachedPsiFile(virtualFile);
    }

    @Nullable
    FileViewProvider getCachedViewProvider(@NotNull Document document) {
        VirtualFile virtualFile = PsiDocumentManagerBase.getVirtualFile(document);
        if (virtualFile == null) {
            return null;
        }
        return this.getCachedViewProvider(virtualFile);
    }

    private FileViewProvider getCachedViewProvider(@NotNull VirtualFile virtualFile) {
        return ((PsiManagerEx)this.myPsiManager).getFileManager().findCachedViewProvider(virtualFile);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return virtualFile;
    }

    @Nullable
    PsiFile getCachedPsiFile(@NotNull VirtualFile virtualFile) {
        return ((PsiManagerEx)this.myPsiManager).getFileManager().getCachedPsiFile(virtualFile);
    }

    @Nullable
    private PsiFile getPsiFile(@NotNull VirtualFile virtualFile) {
        return ((PsiManagerEx)this.myPsiManager).getFileManager().findFile(virtualFile);
    }

    public Document getDocument(@NotNull PsiFile file2) {
        if (file2 instanceof PsiBinaryFile) {
            return null;
        }
        Document document = this.getCachedDocument(file2);
        if (document != null) {
            if (!file2.getViewProvider().isPhysical() && document.getUserData(this.HARD_REF_TO_PSI) == null) {
                PsiUtilCore.ensureValid((PsiElement)file2);
                this.associatePsi(document, file2);
            }
            return document;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        if (!viewProvider.isEventSystemEnabled()) {
            return null;
        }
        document = FileDocumentManager.getInstance().getDocument(viewProvider.getVirtualFile());
        if (document != null) {
            if (document.getTextLength() != file2.getTextLength()) {
                String message2 = "Document/PSI mismatch: " + file2 + " (" + file2.getClass() + "); physical=" + viewProvider.isPhysical();
                if (document.getTextLength() + file2.getTextLength() < 8096) {
                    message2 = message2 + "\n=== document ===\n" + document.getText() + "\n=== PSI ===\n" + file2.getText();
                }
                throw new AssertionError((Object)message2);
            }
            if (!viewProvider.isPhysical()) {
                PsiUtilCore.ensureValid((PsiElement)file2);
                this.associatePsi(document, file2);
                file2.putUserData(HARD_REF_TO_DOCUMENT, (Object)document);
            }
        }
        return document;
    }

    public Document getCachedDocument(@NotNull PsiFile file2) {
        if (!file2.isPhysical()) {
            return null;
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        return FileDocumentManager.getInstance().getCachedDocument(vFile);
    }

    public void commitAllDocuments() {
        Document[] documents;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (this.myUncommittedDocuments.isEmpty()) {
            return;
        }
        for (Document document : documents = this.getUncommittedDocuments()) {
            this.commitDocument(document);
        }
        LOG.assertTrue(!this.hasUncommitedDocuments(), this.myUncommittedDocuments);
    }

    public void performForCommittedDocument(@NotNull Document doc, @NotNull Runnable action) {
        Document document;
        Document document2 = document = doc instanceof DocumentWindow ? ((DocumentWindow)doc).getDelegate() : doc;
        if (this.isCommitted(document)) {
            action.run();
        } else {
            PsiDocumentManagerBase.addRunOnCommit(document, action);
        }
    }

    public boolean cancelAndRunWhenAllCommitted(@NonNls @NotNull Object key2, @NotNull Runnable action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            action.run();
            return true;
        }
        if (this.myUncommittedDocuments.isEmpty()) {
            if (!this.isCommitInProgress()) assert (this.actionsWhenAllDocumentsAreCommitted.isEmpty()) : this.actionsWhenAllDocumentsAreCommitted;
            action.run();
            return true;
        }
        this.checkWeAreOutsideAfterCommitHandler();
        this.actionsWhenAllDocumentsAreCommitted.put(key2, action);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRunOnCommit(@NotNull Document document, @NotNull Runnable action) {
        Key<List<Runnable>> key2 = ACTION_AFTER_COMMIT;
        synchronized (key2) {
            List list = (List)document.getUserData(ACTION_AFTER_COMMIT);
            if (list == null) {
                list = new SmartList();
                document.putUserData(ACTION_AFTER_COMMIT, (Object)list);
            }
            list.add(action);
        }
    }

    public void commitDocument(@NotNull Document doc) {
        Document document;
        Document document2 = document = doc instanceof DocumentWindow ? ((DocumentWindow)doc).getDelegate() : doc;
        if (this.isEventSystemEnabled(document)) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        }
        if (!this.isCommitted(document)) {
            this.doCommit(document);
        }
    }

    private boolean isEventSystemEnabled(Document document) {
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        return viewProvider != null && viewProvider.isEventSystemEnabled() && !SingleRootFileViewProvider.isFreeThreaded(viewProvider);
    }

    public boolean finishCommit(final @NotNull Document document, final @NotNull List<Processor<Document>> finishProcessors, final boolean synchronously, @NotNull Object reason) {
        assert (!this.myProject.isDisposed()) : "Already disposed";
        ApplicationManager.getApplication().assertIsDispatchThread();
        final boolean[] ok = new boolean[]{true};
        DocumentRunnable runnable2 = new DocumentRunnable(document, this.myProject){

            public void run() {
                ok[0] = PsiDocumentManagerBase.this.finishCommitInWriteAction(document, finishProcessors, synchronously);
            }
        };
        if (synchronously) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().runWriteAction((Runnable)runnable2);
        }
        if (ok[0]) {
            if (!this.mySynchronizer.isDocumentAffectedByTransactions(document)) {
                InjectedLanguageManager.getInstance((Project)this.myProject).startRunInjectors(document, synchronously);
            }
            this.runAfterCommitActions(document);
            if (DebugUtil.DO_EXPENSIVE_CHECKS && !ApplicationInfoImpl.isInStressTest()) {
                this.checkAllElementsValid(document, reason);
            }
        }
        return ok[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return false;
        }
        assert (!(document instanceof DocumentWindow));
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile != null) {
            this.getSmartPointerManager().fastenBelts(virtualFile);
        }
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        this.myIsCommitInProgress = true;
        boolean success = true;
        try {
            if (viewProvider != null) {
                success = this.commitToExistingPsi(document, finishProcessors, synchronously, virtualFile, viewProvider);
            } else {
                this.handleCommitWithoutPsi(document);
            }
        }
        catch (Throwable e) {
            this.forceReload(virtualFile, viewProvider);
            LOG.error(e);
        }
        finally {
            if (success) {
                this.myUncommittedDocuments.remove(document);
            }
            this.myIsCommitInProgress = false;
        }
        return success;
    }

    private boolean commitToExistingPsi(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously, @Nullable VirtualFile virtualFile, @NotNull FileViewProvider viewProvider) {
        for (Processor<Document> finishRunnable : finishProcessors) {
            boolean success = finishRunnable.process((Object)document);
            if (synchronously) assert (success) : finishRunnable + " in " + finishProcessors;
            if (success) continue;
            return false;
        }
        this.clearUncommittedInfo(document);
        if (virtualFile != null) {
            this.getSmartPointerManager().updatePointerTargetsAfterReparse(virtualFile);
        }
        viewProvider.contentsSynchronized();
        return true;
    }

    void forceReload(VirtualFile virtualFile, @Nullable FileViewProvider viewProvider) {
        if (viewProvider instanceof SingleRootFileViewProvider) {
            ((SingleRootFileViewProvider)viewProvider).markInvalidated();
        }
        if (virtualFile != null) {
            ((FileManagerImpl)((PsiManagerEx)this.myPsiManager).getFileManager()).forceReload(virtualFile);
        }
    }

    private void checkAllElementsValid(@NotNull Document document, final @NotNull Object reason) {
        final PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (!element.isValid()) {
                        throw new AssertionError((Object)("Commit to '" + psiFile.getVirtualFile() + "' has led to invalid element: " + element + "; Reason: '" + reason + "'"));
                    }
                }
            });
        }
    }

    private void doCommit(@NotNull Document document) {
        assert (!this.myIsCommitInProgress) : "Do not call commitDocument() from inside PSI change listener";
        if (this.getSynchronizer().isDocumentAffectedByTransactions(document)) {
            return;
        }
        PsiFile psiFile = this.getPsiFile(document);
        if (psiFile == null) {
            this.myUncommittedDocuments.remove(document);
            return;
        }
        Runnable runnable2 = () -> {
            this.myIsCommitInProgress = true;
            try {
                this.myDocumentCommitProcessor.commitSynchronously(document, this.myProject, psiFile);
            }
            finally {
                this.myIsCommitInProgress = false;
            }
            assert (!this.isInUncommittedSet(document)) : "Document :" + document;
        };
        if (SingleRootFileViewProvider.isFreeThreaded(psiFile.getViewProvider())) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().runWriteAction(runnable2);
        }
    }

    public boolean isCommitInProgress() {
        return this.myIsCommitInProgress;
    }

    public <T> T commitAndRunReadAction(@NotNull Computable<T> computation) {
        Ref ref = Ref.create(null);
        this.commitAndRunReadAction(() -> ref.set(computation.compute()));
        return (T)ref.get();
    }

    public void reparseFiles(@NotNull Collection<VirtualFile> files, boolean includeOpenFiles) {
        FileContentUtilCore.reparseFiles(files);
    }

    public void commitAndRunReadAction(@NotNull Runnable runnable2) {
        boolean executed;
        Application application = ApplicationManager.getApplication();
        if (SwingUtilities.isEventDispatchThread()) {
            this.commitAllDocuments();
            runnable2.run();
            return;
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("Don't call commitAndRunReadAction inside ReadAction, it will cause a deadlock otherwise. " + Thread.currentThread());
        }
        while (!(executed = ((Boolean)application.runReadAction(() -> {
            if (this.myUncommittedDocuments.isEmpty()) {
                runnable2.run();
                return true;
            }
            return false;
        })).booleanValue())) {
            Semaphore semaphore = new Semaphore();
            semaphore.down();
            application.invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    semaphore.up();
                    return;
                }
                this.performWhenAllCommitted(() -> semaphore.up());
            }, ModalityState.any());
            semaphore.waitFor();
        }
    }

    public boolean performWhenAllCommitted(@NotNull Runnable action) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkWeAreOutsideAfterCommitHandler();
        assert (!this.myProject.isDisposed()) : "Already disposed: " + this.myProject;
        if (this.myUncommittedDocuments.isEmpty()) {
            action.run();
            return true;
        }
        CompositeRunnable actions = (CompositeRunnable)this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY);
        if (actions == null) {
            actions = new CompositeRunnable();
            this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, actions);
        }
        actions.add(action);
        ModalityState current = ModalityState.current();
        if (current != ModalityState.NON_MODAL) {
            for (Document document : this.myUncommittedDocuments) {
                this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, document, "re-added with modality " + current + " because performWhenAllCommitted(" + current + ") was called", current);
            }
        }
        return false;
    }

    public void performLaterWhenAllCommitted(@NotNull Runnable runnable2) {
        this.performLaterWhenAllCommitted(runnable2, ModalityState.defaultModalityState());
    }

    public void performLaterWhenAllCommitted(@NotNull Runnable runnable2, ModalityState modalityState) {
        Runnable whenAllCommitted = () -> ApplicationManager.getApplication().invokeLater(() -> {
            if (this.hasUncommitedDocuments()) {
                this.performLaterWhenAllCommitted(runnable2);
            } else {
                runnable2.run();
            }
        }, modalityState, this.myProject.getDisposed());
        if (ApplicationManager.getApplication().isDispatchThread() && this.isInsideCommitHandler()) {
            whenAllCommitted.run();
        } else {
            UIUtil.invokeLaterIfNeeded(() -> this.performWhenAllCommitted(whenAllCommitted));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAfterCommitActions(@NotNull Document document) {
        ArrayList list;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Key<List<Runnable>> key2 = ACTION_AFTER_COMMIT;
        synchronized (key2) {
            list = (ArrayList)document.getUserData(ACTION_AFTER_COMMIT);
            if (list != null) {
                list = new ArrayList(list);
                document.putUserData(ACTION_AFTER_COMMIT, null);
            }
        }
        if (list != null) {
            for (Runnable runnable2 : list) {
                runnable2.run();
            }
        }
        if (!this.hasUncommitedDocuments() && !this.actionsWhenAllDocumentsAreCommitted.isEmpty()) {
            ArrayList<Map.Entry<Object, Runnable>> entries = new ArrayList<Map.Entry<Object, Runnable>>(new LinkedHashMap<Object, Runnable>(this.actionsWhenAllDocumentsAreCommitted).entrySet());
            this.beforeCommitHandler();
            try {
                for (Map.Entry entry : entries) {
                    Runnable action = (Runnable)entry.getValue();
                    try {
                        action.run();
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    catch (Throwable e) {
                        LOG.error("During running " + action, e);
                    }
                }
            }
            finally {
                this.actionsWhenAllDocumentsAreCommitted.clear();
            }
        }
    }

    private void beforeCommitHandler() {
        this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, EmptyRunnable.getInstance());
    }

    private void checkWeAreOutsideAfterCommitHandler() {
        if (this.isInsideCommitHandler()) {
            throw new IncorrectOperationException("You must not call performWhenAllCommitted()/cancelAndRunWhenCommitted() from within after-commit handler");
        }
    }

    private boolean isInsideCommitHandler() {
        return this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY) == EmptyRunnable.getInstance();
    }

    public void addListener(@NotNull PsiDocumentManager.Listener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull PsiDocumentManager.Listener listener2) {
        this.myListeners.remove(listener2);
    }

    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        return false;
    }

    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
    }

    void fireDocumentCreated(@NotNull Document document, PsiFile file2) {
        for (PsiDocumentManager.Listener listener2 : this.myListeners) {
            listener2.documentCreated(document, file2);
        }
    }

    private void fireFileCreated(@NotNull Document document, @NotNull PsiFile file2) {
        for (PsiDocumentManager.Listener listener2 : this.myListeners) {
            listener2.fileCreated(file2, document);
        }
    }

    @NotNull
    public CharSequence getLastCommittedText(@NotNull Document document) {
        return this.getLastCommittedDocument(document).getImmutableCharSequence();
    }

    public long getLastCommittedStamp(@NotNull Document document) {
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        return this.getLastCommittedDocument(document).getModificationStamp();
    }

    @Nullable
    public Document getLastCommittedDocument(@NotNull PsiFile file2) {
        Document document = this.getDocument(file2);
        return document == null ? null : this.getLastCommittedDocument(document);
    }

    @NotNull
    public DocumentEx getLastCommittedDocument(@NotNull Document document) {
        if (document instanceof FrozenDocument) {
            return (DocumentEx)document;
        }
        if (document instanceof DocumentWindow) {
            DocumentWindow answer;
            DocumentWindow window = (DocumentWindow)document;
            Document delegate = window.getDelegate();
            if (delegate instanceof FrozenDocument) {
                return (DocumentEx)window;
            }
            if (!window.isValid()) {
                throw new AssertionError((Object)("host committed: " + this.isCommitted(delegate) + ", window=" + window));
            }
            UncommittedInfo info = this.myUncommittedInfos.get(delegate);
            DocumentWindow documentWindow = answer = info == null ? null : (DocumentWindow)info.myFrozenWindows.get(document);
            if (answer == null) {
                answer = this.freezeWindow(window);
            }
            if (info != null) {
                answer = (DocumentWindow)ConcurrencyUtil.cacheOrGet((ConcurrentMap)info.myFrozenWindows, (Object)window, (Object)answer);
            }
            return (DocumentEx)answer;
        }
        assert (document instanceof DocumentImpl);
        UncommittedInfo info = this.myUncommittedInfos.get(document);
        return info != null ? info.myFrozen : ((DocumentImpl)document).freeze();
    }

    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public List<DocumentEvent> getEventsSinceCommit(@NotNull Document document) {
        assert (document instanceof DocumentImpl);
        UncommittedInfo info = this.myUncommittedInfos.get(document);
        if (info != null) {
            return info.myEvents;
        }
        return Collections.emptyList();
    }

    @NotNull
    public Document[] getUncommittedDocuments() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object[] documents = this.myUncommittedDocuments.toArray(new Document[this.myUncommittedDocuments.size()]);
        return (Document[])ArrayUtil.stripTrailingNulls((Object[])documents);
    }

    boolean isInUncommittedSet(@NotNull Document document) {
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        return this.myUncommittedDocuments.contains(document);
    }

    public boolean isUncommited(@NotNull Document document) {
        return !this.isCommitted(document);
    }

    public boolean isCommitted(@NotNull Document document) {
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        if (this.getSynchronizer().isInSynchronization(document)) {
            return true;
        }
        return !((DocumentEx)document).isInEventsHandling() && !this.isInUncommittedSet(document);
    }

    public boolean hasUncommitedDocuments() {
        return !this.myIsCommitInProgress && !this.myUncommittedDocuments.isEmpty();
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        FileViewProvider viewProvider;
        boolean inMyProject;
        boolean isRelevant;
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean bl = isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        if (document instanceof DocumentImpl && !this.myUncommittedInfos.containsKey(document)) {
            this.myUncommittedInfos.put(document, new UncommittedInfo((DocumentImpl)document));
        }
        boolean bl2 = inMyProject = (viewProvider = this.getCachedViewProvider(document)) != null && viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            return;
        }
        List files = viewProvider.getAllFiles();
        PsiFile psiCause = null;
        for (PsiFile file2 : files) {
            if (file2 == null) {
                throw new AssertionError((Object)("View provider " + viewProvider + " (" + viewProvider.getClass() + ") returned null in its files array: " + files + " for file " + viewProvider.getVirtualFile()));
            }
            if (!PsiToDocumentSynchronizer.isInsideAtomicChange(file2)) continue;
            psiCause = file2;
        }
        if (psiCause == null) {
            this.beforeDocumentChangeOnUnlockedDocument(viewProvider);
        }
        ((SingleRootFileViewProvider)viewProvider).beforeDocumentChanged(psiCause);
    }

    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
    }

    public void documentChanged(DocumentEvent event) {
        boolean forceCommit;
        boolean inMyProject;
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        boolean isRelevant = virtualFile != null && this.isRelevant(virtualFile);
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        if (viewProvider == null) {
            this.handleCommitWithoutPsi(document);
            return;
        }
        boolean bl = inMyProject = viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            this.clearUncommittedInfo(document);
            return;
        }
        List files = viewProvider.getAllFiles();
        boolean commitNecessary = files.stream().noneMatch(file2 -> PsiToDocumentSynchronizer.isInsideAtomicChange(file2) || !(file2 instanceof PsiFileImpl));
        boolean bl2 = forceCommit = ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class) && (SystemProperties.getBooleanProperty((String)"idea.force.commit.on.external.change", (boolean)false) || ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode());
        if (event.isWholeTextReplaced() && document.getTextLength() > 100000) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)Boolean.TRUE);
        }
        if (commitNecessary) {
            assert (!(document instanceof DocumentWindow));
            this.myUncommittedDocuments.add(document);
            if (forceCommit) {
                this.commitDocument(document);
            } else if (!((DocumentEx)document).isInBulkUpdate() && this.myPerformBackgroundCommit) {
                this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, document, event, ApplicationManager.getApplication().getCurrentModalityState());
            }
        } else {
            this.clearUncommittedInfo(document);
        }
    }

    void handleCommitWithoutPsi(@NotNull Document document) {
        UncommittedInfo prevInfo = this.clearUncommittedInfo(document);
        if (prevInfo == null) {
            return;
        }
        if (!this.myProject.isInitialized() || this.myProject.isDisposed()) {
            return;
        }
        this.myUncommittedDocuments.remove(document);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !FileIndexFacade.getInstance((Project)this.myProject).isInContent(virtualFile)) {
            return;
        }
        final PsiFile psiFile = this.getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

            @Override
            public void run() {
                FileViewProvider viewProvider = psiFile.getViewProvider();
                if (viewProvider instanceof SingleRootFileViewProvider) {
                    ((SingleRootFileViewProvider)viewProvider).onContentReload();
                } else {
                    LOG.error("Invalid view provider: " + viewProvider + " of " + viewProvider.getClass());
                }
            }
        });
    }

    @Nullable
    private UncommittedInfo clearUncommittedInfo(@NotNull Document document) {
        UncommittedInfo info = this.myUncommittedInfos.remove(document);
        if (info != null) {
            this.getSmartPointerManager().updatePointers(document, info.myFrozen, info.myEvents);
            info.removeListener();
        }
        return info;
    }

    private SmartPointerManagerImpl getSmartPointerManager() {
        return (SmartPointerManagerImpl)SmartPointerManager.getInstance((Project)this.myProject);
    }

    private boolean isRelevant(@NotNull VirtualFile virtualFile) {
        return !virtualFile.getFileType().isBinary() && !this.myProject.isDisposed();
    }

    public static boolean checkConsistency(@NotNull PsiFile psiFile, @NotNull Document document) {
        int i2;
        if (psiFile.getVirtualFile() == null) {
            return true;
        }
        CharSequence editorText = document.getCharsSequence();
        int documentLength = document.getTextLength();
        if (psiFile.textMatches(editorText)) {
            LOG.assertTrue(psiFile.getTextLength() == documentLength);
            return true;
        }
        char[] fileText = psiFile.textToCharArray();
        String error = "File '" + psiFile.getName() + "' text mismatch after reparse. File length=" + fileText.length + "; Doc length=" + documentLength + "\n";
        for (i2 = 0; i2 < documentLength; ++i2) {
            if (i2 >= fileText.length) {
                error = error + "editorText.length > psiText.length i=" + i2 + "\n";
                break;
            }
            if (i2 >= editorText.length()) {
                error = error + "editorText.length > psiText.length i=" + i2 + "\n";
                break;
            }
            if (editorText.charAt(i2) == fileText[i2]) continue;
            error = error + "first unequal char i=" + i2 + "\n";
            break;
        }
        error = error + "*********************************************\n";
        error = error + "Editor Text tail:(" + (documentLength - i2) + ")\n";
        error = error + "*********************************************\n";
        error = error + "Psi Text tail:(" + (fileText.length - i2) + ")\n";
        error = error + "*********************************************\n";
        if (document instanceof DocumentWindow) {
            error = error + "doc: '" + document.getText() + "'\n";
            error = error + "psi: '" + psiFile.getText() + "'\n";
            error = error + "ast: '" + psiFile.getNode().getText() + "'\n";
            error = error + psiFile.getLanguage() + "\n";
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getInjectionHost((PsiElement)psiFile);
            if (context != null) {
                error = error + "context: " + context + "; text: '" + context.getText() + "'\n";
                error = error + "context file: " + context.getContainingFile() + "\n";
            }
            error = error + "document window ranges: " + Arrays.asList(((DocumentWindow)document).getHostRanges()) + "\n";
        }
        LOG.error(error);
        return false;
    }

    @VisibleForTesting
    public void clearUncommittedDocuments() {
        for (UncommittedInfo info : this.myUncommittedInfos.values()) {
            info.removeListener();
        }
        this.myUncommittedInfos.clear();
        this.myUncommittedDocuments.clear();
        this.mySynchronizer.cleanupForNextTest();
    }

    public void disableBackgroundCommit(@NotNull Disposable parentDisposable) {
        assert (this.myPerformBackgroundCommit);
        this.myPerformBackgroundCommit = false;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                PsiDocumentManagerBase.this.myPerformBackgroundCommit = true;
            }
        });
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.clearUncommittedDocuments();
    }

    @NotNull
    public String getComponentName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    @NotNull
    public PsiToDocumentSynchronizer getSynchronizer() {
        return this.mySynchronizer;
    }

    private static class UncommittedInfo
    extends DocumentAdapter
    implements PrioritizedInternalDocumentListener {
        private final DocumentImpl myOriginal;
        private final FrozenDocument myFrozen;
        private final List<DocumentEvent> myEvents = ContainerUtil.newArrayList();
        private final ConcurrentMap<DocumentWindow, DocumentWindow> myFrozenWindows = ContainerUtil.newConcurrentMap();

        private UncommittedInfo(DocumentImpl original) {
            this.myOriginal = original;
            this.myFrozen = original.freeze();
            this.myOriginal.addDocumentListener(this);
        }

        @Override
        public int getPriority() {
            return 40;
        }

        public void documentChanged(DocumentEvent e) {
            this.myEvents.add(e);
        }

        @Override
        public void moveTextHappened(int start, int end, int base) {
            this.myEvents.add(new RetargetRangeMarkers(this.myOriginal, start, end, base));
        }

        public void removeListener() {
            this.myOriginal.removeDocumentListener(this);
        }
    }

    private static class CompositeRunnable
    extends ArrayList<Runnable>
    implements Runnable {
        private CompositeRunnable() {
        }

        @Override
        public void run() {
            for (Runnable runnable2 : this) {
                runnable2.run();
            }
        }
    }
}

