/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.AppTopics;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.EditorWindowImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.util.FileContentUtil;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDocumentManagerImpl
extends PsiDocumentManagerBase
implements SettingsSavingComponent {
    private final DocumentCommitProcessor myDocumentCommitThread;
    private final boolean myUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();

    public PsiDocumentManagerImpl(final @NotNull Project project2, @NotNull PsiManager psiManager, @NotNull EditorFactory editorFactory, @NotNull MessageBus bus, final @NonNls @NotNull DocumentCommitProcessor documentCommitThread) {
        super(project2, psiManager, bus, documentCommitThread);
        this.myDocumentCommitThread = documentCommitThread;
        editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)this, (Disposable)project2);
        MessageBusConnection connection = bus.connect();
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentLoaded(@NotNull VirtualFile virtualFile, @NotNull Document document) {
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiDocumentManagerImpl.this.myProject.isDisposed() || !virtualFile.isValid() ? null : PsiDocumentManagerImpl.this.getCachedPsiFile(virtualFile));
                PsiDocumentManagerImpl.this.fireDocumentCreated(document, psiFile);
            }
        });
        connection.subscribe(DocumentBulkUpdateListener.TOPIC, (Object)new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateFinished(@NotNull Document doc) {
                documentCommitThread.commitAsynchronously(project2, doc, "Bulk update finished", ApplicationManager.getApplication().getDefaultModalityState());
            }
        });
        Disposer.register((Disposable)project2, () -> ((DocumentCommitThread)this.myDocumentCommitThread).cancelTasksOnProjectDispose(project2));
    }

    @Override
    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        Collection projects;
        VirtualFile virtualFile;
        PsiFile psiFile = super.getPsiFile(document);
        if (this.myUnitTestMode && (virtualFile = FileDocumentManager.getInstance().getFile(document)) != null && virtualFile.isValid() && !(projects = ProjectLocator.getInstance().getProjectsForFile(virtualFile)).isEmpty() && !projects.contains(this.myProject)) {
            LOG.error("Trying to get PSI for an alien project. VirtualFile=" + virtualFile + ";\n myProject=" + this.myProject + ";\n projects returned: " + projects);
        }
        return psiFile;
    }

    @Override
    public void documentChanged(DocumentEvent event) {
        super.documentChanged(event);
        if (FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(this.myUncommittedDocuments)) {
            if (this.myUnitTestMode) {
                this.myStopTrackingDocuments = true;
                try {
                    LOG.error("Too many uncommitted documents for " + this.myProject + "(" + this.myUncommittedDocuments.size() + "):\n" + StringUtil.join((Iterable)this.myUncommittedDocuments, (String)"\n") + "\n\n Project creation trace: " + (String)this.myProject.getUserData(ProjectImpl.CREATION_TRACE));
                }
                finally {
                    this.clearUncommittedDocuments();
                }
            }
            if (PomModelImpl.isAllowPsiModification()) {
                this.commitAllDocuments();
            }
        }
    }

    @Override
    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        PostprocessReformattingAspect.getInstance(this.myProject).beforeDocumentChanged(viewProvider);
        super.beforeDocumentChangeOnUnlockedDocument(viewProvider);
    }

    @Override
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously) {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            EditorWindowImpl.disposeInvalidEditors();
        }
        return super.finishCommitInWriteAction(document, finishProcessors, synchronously);
    }

    @Override
    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        FileViewProvider viewProvider = this.getCachedViewProvider(doc);
        return viewProvider != null && PostprocessReformattingAspect.getInstance(this.myProject).isViewProviderLocked(viewProvider);
    }

    @Override
    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc instanceof DocumentWindow) {
            doc = ((DocumentWindow)doc).getDelegate();
        }
        PostprocessReformattingAspect component = (PostprocessReformattingAspect)this.myProject.getComponent(PostprocessReformattingAspect.class);
        FileViewProvider viewProvider = this.getCachedViewProvider(doc);
        if (viewProvider != null && component != null) {
            component.doPostponedFormatting(viewProvider);
        }
    }

    public void save() {
        try {
            this.commitAllDocuments();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void clearUncommittedDocuments() {
        super.clearUncommittedDocuments();
        ((DocumentCommitThread)this.myDocumentCommitThread).clearQueue();
    }

    @NonNls
    public String toString() {
        return super.toString() + " for the project " + this.myProject + ".";
    }

    @Override
    public void reparseFiles(@NotNull Collection<VirtualFile> files, boolean includeOpenFiles) {
        FileContentUtil.reparseFiles((Project)this.myProject, files, (boolean)includeOpenFiles);
    }

    @Override
    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document) {
        return MultiHostRegistrarImpl.freezeWindow((DocumentWindowImpl)document);
    }
}

