/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassOwnerEx;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementFinderImpl
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;
    private final JavaFileManager myFileManager;

    public PsiElementFinderImpl(Project project2, JavaFileManager javaFileManager) {
        this.myProject = project2;
        this.myFileManager = javaFileManager;
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        return this.myFileManager.findClass(qualifiedName, scope);
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        return this.myFileManager.findClasses(qualifiedName, scope);
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        return this.myFileManager.findPackage(qualifiedName);
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        HashMap packagesMap = new HashMap();
        String qualifiedName = psiPackage.getQualifiedName();
        for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
            PsiDirectory[] subDirs;
            for (PsiDirectory subDir : subDirs = dir.getSubdirectories()) {
                String subQualifiedName;
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subDir);
                if (aPackage == null || !(subQualifiedName = aPackage.getQualifiedName()).startsWith(qualifiedName) || packagesMap.containsKey(subQualifiedName)) continue;
                packagesMap.put(aPackage.getQualifiedName(), aPackage);
            }
        }
        packagesMap.remove(qualifiedName);
        return packagesMap.values().toArray(new PsiPackage[packagesMap.size()]);
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        return this.getClasses(null, psiPackage, scope);
    }

    @NotNull
    public PsiClass[] getClasses(@Nullable String shortName, @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        ArrayList<PsiClass> list = null;
        String packageName = psiPackage.getQualifiedName();
        for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
            PsiClass[] classes2 = JavaDirectoryService.getInstance().getClasses(dir);
            if (classes2.length == 0) continue;
            if (list == null) {
                list = new ArrayList<PsiClass>();
            }
            for (PsiClass aClass : classes2) {
                String qualifiedName = aClass.getQualifiedName();
                if (qualifiedName != null) {
                    qualifiedName = StringUtil.getPackageName((String)qualifiedName);
                }
                if (!Comparing.strEqual((String)qualifiedName, (String)packageName) || shortName != null && !shortName.equals(aClass.getName())) continue;
                list.add(aClass);
            }
        }
        if (list == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        if (list.size() > 1) {
            ContainerUtil.quickSort((List)list, (Comparator)PsiClassUtil.createScopeComparator((GlobalSearchScope)scope));
        }
        return list.toArray(new PsiClass[list.size()]);
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        HashSet names = null;
        FileIndexFacade facade = FileIndexFacade.getInstance((Project)this.myProject);
        for (PsiDirectory dir : psiPackage.getDirectories(scope)) {
            for (PsiFile file2 : dir.getFiles()) {
                Set inFile;
                VirtualFile vFile;
                if (!(file2 instanceof PsiClassOwner) || file2.getViewProvider().getLanguages().size() != 1 || (vFile = file2.getVirtualFile()) != null && !(file2 instanceof PsiCompiledElement) && !facade.isInSourceContent(vFile) && (!scope.isForceSearchingInLibrarySources() || !StubTreeLoader.getInstance().canHaveStub(vFile))) continue;
                Set set2 = inFile = file2 instanceof PsiClassOwnerEx ? ((PsiClassOwnerEx)file2).getClassNames() : PsiElementFinderImpl.getClassNames((PsiClass[])((PsiClassOwner)file2).getClasses());
                if (inFile.isEmpty()) continue;
                if (names == null) {
                    names = new HashSet();
                }
                names.addAll(inFile);
            }
        }
        return names == null ? Collections.emptySet() : names;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope, final @NotNull Processor<PsiDirectory> consumer2, boolean includeLibrarySources) {
        final PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        return PackageIndex.getInstance((Project)this.myProject).getDirsByPackageName(psiPackage.getQualifiedName(), includeLibrarySources).forEach((Processor)new ReadActionProcessor<VirtualFile>(){

            public boolean processInReadAction(VirtualFile dir) {
                if (!scope.contains(dir)) {
                    return true;
                }
                PsiDirectory psiDir = psiManager.findDirectory(dir);
                return psiDir == null || consumer2.process((Object)psiDir);
            }
        });
    }
}

