/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiImplUtil");
    private static final Key<Boolean> TYPE_ANNO_MARK = Key.create((String)"type.annotation.mark");

    private PsiImplUtil() {
    }

    @NotNull
    public static PsiMethod[] getConstructors(@NotNull PsiClass aClass) {
        List result2 = null;
        for (PsiMethod method2 : aClass.getMethods()) {
            if (!method2.isConstructor()) continue;
            if (result2 == null) {
                result2 = ContainerUtil.newSmartList();
            }
            result2.add(method2);
        }
        return result2 == null ? PsiMethod.EMPTY_ARRAY : result2.toArray(new PsiMethod[result2.size()]);
    }

    @Nullable
    public static PsiAnnotationMemberValue findDeclaredAttributeValue(@NotNull PsiAnnotation annotation, @NonNls @Nullable String attributeName) {
        PsiNameValuePair attribute = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)attributeName);
        return attribute == null ? null : attribute.getValue();
    }

    @Nullable
    public static PsiAnnotationMemberValue findAttributeValue(@NotNull PsiAnnotation annotation, @Nullable @NonNls String attributeName) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotationMemberValue value2 = PsiImplUtil.findDeclaredAttributeValue(annotation, attributeName);
        if (value2 != null) {
            return value2;
        }
        if (attributeName == null) {
            attributeName = "value";
        }
        if ((referenceElement = annotation.getNameReferenceElement()) != null && (resolved = referenceElement.resolve()) != null) {
            PsiMethod[] methods;
            for (PsiMethod method2 : methods = ((PsiClass)resolved).findMethodsByName(attributeName, false)) {
                if (!PsiUtil.isAnnotationMethod((PsiElement)method2)) continue;
                return ((PsiAnnotationMethod)method2).getDefaultValue();
            }
        }
        return null;
    }

    @NotNull
    public static PsiTypeParameter[] getTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        PsiTypeParameterList typeParameterList = owner.getTypeParameterList();
        if (typeParameterList != null) {
            return typeParameterList.getTypeParameters();
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    @NotNull
    public static PsiJavaCodeReferenceElement[] namesToPackageReferences(@NotNull PsiManager manager, @NotNull String[] names) {
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[names.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            try {
                refs[i2] = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createPackageReferenceElement(name);
                continue;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        return refs;
    }

    public static int getParameterIndex(@NotNull PsiParameter parameter, @NotNull PsiParameterList parameterList) {
        int i2;
        PsiElement parameterParent = parameter.getParent();
        assert (parameterParent == parameterList) : parameterList + "; " + parameterParent;
        PsiParameter[] parameters2 = parameterList.getParameters();
        for (int i3 = 0; i3 < parameters2.length; ++i3) {
            PsiParameter paramInList = parameters2[i3];
            if (!parameter.equals(paramInList)) continue;
            return i3;
        }
        String name = parameter.getName();
        PsiParameter suspect = null;
        for (i2 = parameters2.length - 1; i2 >= 0; --i2) {
            PsiParameter paramInList = parameters2[i2];
            if (!Comparing.equal((String)name, (String)paramInList.getName())) continue;
            suspect = paramInList;
            break;
        }
        String message2 = parameter + ":" + parameter.getClass() + " not found among parameters: " + Arrays.asList(parameters2) + ". parameterList' parent: " + parameterList.getParent() + "; parameter.isValid()=" + parameter.isValid() + "; parameterList.isValid()= " + parameterList.isValid() + "; parameterList stub: " + (parameterList instanceof StubBasedPsiElement ? ((StubBasedPsiElement)parameterList).getStub() : "---") + ";  parameter stub: " + (parameter instanceof StubBasedPsiElement ? ((StubBasedPsiElement)parameter).getStub() : "---") + "; suspect: " + suspect + " (index=" + i2 + "); " + (suspect == null ? null : suspect.getClass()) + " suspect stub: " + (suspect instanceof StubBasedPsiElement ? ((StubBasedPsiElement)suspect).getStub() : (suspect == null ? "-null-" : "---" + suspect.getClass())) + "; parameter.equals(suspect) = " + parameter.equals(suspect) + ";  parameter.getNode() == suspect.getNode():  " + (parameter.getNode() == (suspect == null ? null : suspect.getNode())) + "; .";
        LOG.error(message2);
        return i2;
    }

    public static int getTypeParameterIndex(@NotNull PsiTypeParameter typeParameter, @NotNull PsiTypeParameterList typeParameterList) {
        PsiTypeParameter[] typeParameters = typeParameterList.getTypeParameters();
        for (int i2 = 0; i2 < typeParameters.length; ++i2) {
            if (!typeParameter.equals(typeParameters[i2])) continue;
            return i2;
        }
        LOG.error(typeParameter + " in " + typeParameterList);
        return -1;
    }

    @NotNull
    public static Object[] getReferenceVariantsByFilter(@NotNull PsiJavaCodeReferenceElement reference, @NotNull ElementFilter filter) {
        FilterScopeProcessor processor2 = new FilterScopeProcessor(filter);
        PsiScopesUtil.resolveAndWalk(processor2, reference, null, true);
        return processor2.getResults().toArray();
    }

    public static boolean processDeclarationsInMethod(@NotNull PsiMethod method2, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (lastParent instanceof DummyHolder) {
            lastParent = lastParent.getFirstChild();
        }
        boolean fromBody = lastParent instanceof PsiCodeBlock;
        PsiTypeParameterList typeParameterList = method2.getTypeParameterList();
        return PsiImplUtil.processDeclarationsInMethodLike((PsiParameterListOwner)method2, processor2, state, place, fromBody, typeParameterList);
    }

    public static boolean processDeclarationsInLambda(@NotNull PsiLambdaExpression lambda2, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        boolean fromBody = lastParent != null && lastParent == lambda2.getBody();
        return PsiImplUtil.processDeclarationsInMethodLike((PsiParameterListOwner)lambda2, processor2, state, place, fromBody, null);
    }

    private static boolean processDeclarationsInMethodLike(@NotNull PsiParameterListOwner element, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @NotNull PsiElement place, boolean fromBody, @Nullable PsiTypeParameterList typeParameterList) {
        ElementClassHint hint;
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)element);
        if (typeParameterList != null && ((hint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY)) == null || hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && !typeParameterList.processDeclarations(processor2, state, null, place)) {
            return false;
        }
        if (fromBody) {
            PsiParameter[] parameters2;
            for (PsiParameter parameter : parameters2 = element.getParameterList().getParameters()) {
                if (processor2.execute((PsiElement)parameter, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processDeclarationsInResourceList(@NotNull PsiResourceList resourceList, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent) {
        PsiResourceListElement resource;
        ElementClassHint hint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (hint != null && !hint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext() && (resource = (PsiResourceListElement)iterator.next()) != lastParent) {
            if (!(resource instanceof PsiResourceVariable) || processor2.execute((PsiElement)resource, state)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasTypeParameters(@NotNull PsiTypeParameterListOwner owner) {
        PsiTypeParameterList typeParameterList = owner.getTypeParameterList();
        return typeParameterList != null && typeParameterList.getTypeParameters().length != 0;
    }

    @NotNull
    public static PsiType[] typesByReferenceParameterList(@NotNull PsiReferenceParameterList parameterList) {
        PsiTypeElement[] typeElements = parameterList.getTypeParameterElements();
        return PsiImplUtil.typesByTypeElements(typeElements);
    }

    @NotNull
    public static PsiType[] typesByTypeElements(@NotNull PsiTypeElement[] typeElements) {
        PsiType[] types = PsiType.createArray((int)typeElements.length);
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = typeElements[i2].getType();
        }
        if (types.length == 1 && types[0] instanceof PsiDiamondType) {
            return ((PsiDiamondType)types[0]).resolveInferredTypes().getTypes();
        }
        return types;
    }

    @NotNull
    public static PsiType getType(@NotNull PsiClassObjectAccessExpression classAccessExpression) {
        PsiTypeParameter[] typeParameters;
        GlobalSearchScope resolveScope = classAccessExpression.getResolveScope();
        PsiManager manager = classAccessExpression.getManager();
        PsiClass classClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Class", resolveScope);
        if (classClass == null) {
            return new PsiClassReferenceType(new LightClassReference(manager, "Class", "java.lang.Class", resolveScope), null);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)classAccessExpression)) {
            return JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createType(classClass);
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiType operandType = classAccessExpression.getOperand().getType();
        if (operandType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)operandType)) {
            operandType = PsiType.VOID.equals((Object)operandType) ? JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Void", classAccessExpression.getResolveScope()) : ((PsiPrimitiveType)operandType).getBoxedType((PsiElement)classAccessExpression);
        }
        if ((typeParameters = classClass.getTypeParameters()).length == 1) {
            substitutor = substitutor.put(typeParameters[0], operandType);
        }
        return new PsiImmediateClassType(classClass, substitutor);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiAnnotationOwner annotationOwner, @NotNull String qualifiedName) {
        if (annotationOwner == null) {
            return null;
        }
        PsiAnnotation[] annotations2 = annotationOwner.getAnnotations();
        if (annotations2.length == 0) {
            return null;
        }
        String shortName = StringUtil.getShortName((String)qualifiedName);
        for (PsiAnnotation annotation : annotations2) {
            PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
            if (referenceElement == null || !shortName.equals(referenceElement.getReferenceName()) || !qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    public static PsiAnnotation.TargetType findApplicableTarget(@NotNull PsiAnnotation annotation, PsiAnnotation.TargetType ... types) {
        return AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])types);
    }

    public static PsiAnnotation.TargetType findApplicableTarget(@NotNull PsiClass annotationType, PsiAnnotation.TargetType ... types) {
        return AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationType, (PsiAnnotation.TargetType[])types);
    }

    public static Set<PsiAnnotation.TargetType> getAnnotationTargets(@NotNull PsiClass annotationType) {
        return AnnotationTargetUtil.getAnnotationTargets((PsiClass)annotationType);
    }

    public static PsiAnnotation.TargetType[] getTargetsForLocation(@Nullable PsiAnnotationOwner owner) {
        return AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)owner);
    }

    @Nullable
    public static ASTNode findDocComment(@NotNull CompositeElement element) {
        TreeElement node;
        for (node = element.getFirstChildNode(); node != null && PsiImplUtil.isWhitespaceOrComment(node) && !(node.getPsi() instanceof PsiDocComment); node = node.getTreeNext()) {
        }
        return node == null || node.getElementType() != JavaDocElementType.DOC_COMMENT ? null : node;
    }

    @Deprecated
    public static PsiType normalizeWildcardTypeByPosition(@NotNull PsiType type2, @NotNull PsiExpression expression2) {
        PsiExpression topLevel;
        PsiUtilCore.ensureValid((PsiElement)expression2);
        PsiUtil.ensureValidType((PsiType)type2);
        for (topLevel = expression2; topLevel.getParent() instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)topLevel.getParent()).getArrayExpression() == topLevel; topLevel = (PsiExpression)topLevel.getParent()) {
        }
        if (topLevel instanceof PsiArrayAccessExpression && !PsiUtil.isAccessedForWriting((PsiExpression)topLevel)) {
            return PsiUtil.captureToplevelWildcards((PsiType)type2, (PsiElement)expression2);
        }
        PsiType normalized = PsiImplUtil.doNormalizeWildcardByPosition(type2, expression2, topLevel);
        LOG.assertTrue(normalized.isValid(), (Object)type2);
        if (normalized instanceof PsiClassType && !PsiUtil.isAccessedForWriting((PsiExpression)topLevel)) {
            return PsiUtil.captureToplevelWildcards((PsiType)normalized, (PsiElement)expression2);
        }
        return normalized;
    }

    private static PsiType doNormalizeWildcardByPosition(PsiType type2, @NotNull PsiExpression expression2, @NotNull PsiExpression topLevel) {
        PsiType componentType;
        PsiType normalizedComponentType;
        if (type2 instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            if (PsiUtil.isAccessedForWriting((PsiExpression)topLevel)) {
                return wildcardType.isSuper() ? wildcardType.getBound() : PsiCapturedWildcardType.create((PsiWildcardType)wildcardType, (PsiElement)expression2);
            }
            if (wildcardType.isExtends()) {
                return wildcardType.getBound();
            }
            return PsiType.getJavaLangObject((PsiManager)expression2.getManager(), (GlobalSearchScope)expression2.getResolveScope());
        }
        if (type2 instanceof PsiArrayType && (normalizedComponentType = PsiImplUtil.doNormalizeWildcardByPosition(componentType = ((PsiArrayType)type2).getComponentType(), expression2, topLevel)) != componentType) {
            return normalizedComponentType.createArrayType();
        }
        return type2;
    }

    @NotNull
    public static SearchScope getMemberUseScope(@NotNull PsiMember member) {
        PsiPackage aPackage;
        int accessLevel;
        PsiFile file2 = member.getContainingFile();
        PsiMember topElement = file2 == null ? member : file2;
        Project project2 = topElement.getProject();
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getInstance(project2).getUseScope((PsiElement)topElement);
        if (PsiImplUtil.isInServerPage((PsiElement)file2)) {
            return maximalUseScope;
        }
        PsiClass aClass = member.getContainingClass();
        if (!(!(aClass instanceof PsiAnonymousClass) || aClass instanceof PsiEnumConstantInitializer && member instanceof PsiMethod && member.hasModifierProperty("public") && ((PsiMethod)member).findSuperMethods().length > 0)) {
            PsiElement methodCallExpr = PsiUtil.isLanguageLevel8OrHigher((PsiElement)aClass) ? PsiTreeUtil.getTopmostParentOfType((PsiElement)aClass, PsiStatement.class) : PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiMethodCallExpression.class);
            return new LocalSearchScope((PsiElement)(methodCallExpr != null ? methodCallExpr : aClass));
        }
        PsiModifierList modifierList = member.getModifierList();
        int n = accessLevel = modifierList == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList);
        if (accessLevel == 4 || accessLevel == 3) {
            return maximalUseScope;
        }
        if (accessLevel == 1) {
            PsiClass topClass = PsiUtil.getTopLevelClass((PsiElement)member);
            return topClass != null ? new LocalSearchScope((PsiElement)topClass) : (file2 == null ? maximalUseScope : new LocalSearchScope((PsiElement)file2));
        }
        if (file2 instanceof PsiJavaFile && (aPackage = JavaPsiFacade.getInstance((Project)project2).findPackage(((PsiJavaFile)file2).getPackageName())) != null) {
            GlobalSearchScope scope = PackageScope.packageScope((PsiPackage)aPackage, (boolean)false);
            return scope.intersectWith((SearchScope)maximalUseScope);
        }
        return maximalUseScope;
    }

    public static boolean isInServerPage(@Nullable PsiElement element) {
        return PsiImplUtil.getServerPageFile(element) != null;
    }

    @Nullable
    private static ServerPageFile getServerPageFile(PsiElement element) {
        PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)element);
        return psiFile instanceof ServerPageFile ? (ServerPageFile)psiFile : null;
    }

    public static PsiElement setName(@NotNull PsiElement element, @NotNull String name) throws IncorrectOperationException {
        PsiManager manager = element.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiIdentifier newNameIdentifier = factory.createIdentifier(name);
        return element.replace((PsiElement)newNameIdentifier);
    }

    public static boolean isDeprecatedByAnnotation(@NotNull PsiModifierListOwner owner) {
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{"java.lang.Deprecated"}) != null;
    }

    public static boolean isDeprecatedByDocTag(@NotNull PsiJavaDocumentedElement owner) {
        PsiDocComment docComment = owner.getDocComment();
        return docComment != null && docComment.findTagByName("deprecated") != null;
    }

    @Nullable
    public static PsiJavaDocumentedElement findDocCommentOwner(@NotNull PsiDocComment comment) {
        PsiJavaDocumentedElement owner;
        PsiElement parent = comment.getParent();
        if (parent instanceof PsiJavaDocumentedElement && (owner = (PsiJavaDocumentedElement)parent).getDocComment() == comment) {
            return owner;
        }
        return null;
    }

    @Nullable
    public static PsiAnnotationMemberValue setDeclaredAttributeValue(@NotNull PsiAnnotation psiAnnotation, @Nullable String attributeName, @Nullable PsiAnnotationMemberValue value2, @NotNull PairFunction<Project, String, PsiAnnotation> annotationCreator) {
        PsiAnnotationMemberValue existing = psiAnnotation.findDeclaredAttributeValue(attributeName);
        if (value2 == null) {
            if (existing == null) {
                return null;
            }
            existing.getParent().delete();
        } else if (existing != null) {
            ((PsiNameValuePair)existing.getParent()).setValue(value2);
        } else {
            PsiNameValuePair attribute;
            PsiNameValuePair[] attributes = psiAnnotation.getParameterList().getAttributes();
            if (attributes.length == 1 && (attribute = attributes[0]).getName() == null) {
                PsiAnnotationMemberValue defValue = attribute.getValue();
                assert (defValue != null) : attribute;
                attribute.replace((PsiElement)PsiImplUtil.createNameValuePair(defValue, "value=", annotationCreator));
            }
            boolean allowNoName = attributes.length == 0 && ("value".equals(attributeName) || null == attributeName);
            String namePrefix = allowNoName ? "" : attributeName + "=";
            psiAnnotation.getParameterList().addBefore((PsiElement)PsiImplUtil.createNameValuePair(value2, namePrefix, annotationCreator), null);
        }
        return psiAnnotation.findDeclaredAttributeValue(attributeName);
    }

    private static PsiNameValuePair createNameValuePair(@NotNull PsiAnnotationMemberValue value2, @NotNull String namePrefix, @NotNull PairFunction<Project, String, PsiAnnotation> annotationCreator) {
        return ((PsiAnnotation)annotationCreator.fun((Object)value2.getProject(), (Object)("@A(" + namePrefix + value2.getText() + ")"))).getParameterList().getAttributes()[0];
    }

    @Nullable
    public static ASTNode skipWhitespaceAndComments(ASTNode node) {
        return TreeUtil.skipWhitespaceAndComments(node, true);
    }

    @Nullable
    public static ASTNode skipWhitespaceCommentsAndTokens(ASTNode node, @NotNull TokenSet alsoSkip) {
        return TreeUtil.skipWhitespaceCommentsAndTokens(node, alsoSkip, true);
    }

    public static boolean isWhitespaceOrComment(ASTNode element) {
        return TreeUtil.isWhitespaceOrComment(element);
    }

    @Nullable
    public static ASTNode skipWhitespaceAndCommentsBack(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (!PsiImplUtil.isWhitespaceOrComment(node)) {
            return node;
        }
        ASTNode parent = node.getTreeParent();
        ASTNode prev = node;
        while (prev instanceof CompositeElement) {
            if (!PsiImplUtil.isWhitespaceOrComment(prev)) {
                return prev;
            }
            prev = prev.getTreePrev();
        }
        if (prev == null) {
            return null;
        }
        ASTNode lastRelevant = null;
        for (ASTNode firstChildNode = parent.getFirstChildNode(); firstChildNode != prev; firstChildNode = firstChildNode.getTreeNext()) {
            if (PsiImplUtil.isWhitespaceOrComment(firstChildNode)) continue;
            lastRelevant = firstChildNode;
        }
        return lastRelevant;
    }

    @Nullable
    public static ASTNode findStatementChild(@NotNull CompositePsiElement statement2) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (TreeElement element = statement2.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!(element.getPsi() instanceof PsiStatement)) continue;
            return element;
        }
        return null;
    }

    public static PsiStatement[] getChildStatements(@NotNull CompositeElement psiCodeBlock) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count = 0;
        for (TreeElement child1 = psiCodeBlock.getFirstChildNode(); child1 != null; child1 = child1.getTreeNext()) {
            if (!(child1.getPsi() instanceof PsiStatement)) continue;
            ++count;
        }
        PsiStatement[] result2 = (PsiStatement[])PsiStatement.ARRAY_FACTORY.create(count);
        if (count == 0) {
            return result2;
        }
        int idx = 0;
        for (TreeElement child = psiCodeBlock.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            PsiElement element = child.getPsi();
            if (!(element instanceof PsiStatement)) continue;
            result2[idx++] = (PsiStatement)element;
        }
        return result2;
    }

    public static boolean isVarArgs(@NotNull PsiMethod method2) {
        PsiParameter[] parameters2 = method2.getParameterList().getParameters();
        return parameters2.length > 0 && parameters2[parameters2.length - 1].isVarArgs();
    }

    public static PsiElement handleMirror(PsiElement element) {
        return element instanceof PsiMirrorElement ? ((PsiMirrorElement)element).getPrototype() : element;
    }

    @Nullable
    public static PsiModifierList findNeighbourModifierList(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement grandParent;
        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)ref, (Class[])new Class[]{PsiJavaCodeReferenceElement.class});
        if (parent instanceof PsiTypeElement && (grandParent = parent.getParent()) instanceof PsiModifierListOwner) {
            return ((PsiModifierListOwner)grandParent).getModifierList();
        }
        return null;
    }

    public static boolean isTypeAnnotation(@Nullable PsiElement element) {
        return element instanceof PsiAnnotation && AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)((PsiAnnotation)element));
    }

    public static void collectTypeUseAnnotations(@NotNull PsiModifierList modifierList, @NotNull List<PsiAnnotation> annotations2) {
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            if (!AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)annotation)) continue;
            annotations2.add(annotation);
        }
    }

    public static void markTypeAnnotations(@NotNull PsiTypeElement typeElement) {
        PsiElement left = PsiTreeUtil.skipSiblingsBackward((PsiElement)typeElement, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class});
        if (left instanceof PsiModifierList) {
            for (PsiAnnotation annotation : ((PsiModifierList)left).getAnnotations()) {
                if (!AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)annotation)) continue;
                annotation.putUserData(TYPE_ANNO_MARK, (Object)Boolean.TRUE);
            }
        }
    }

    public static void deleteTypeAnnotations(@NotNull PsiTypeElement typeElement) {
        PsiElement left = PsiTreeUtil.skipSiblingsBackward((PsiElement)typeElement, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class});
        if (left instanceof PsiModifierList) {
            for (PsiAnnotation annotation : ((PsiModifierList)left).getAnnotations()) {
                if (TYPE_ANNO_MARK.get((UserDataHolder)annotation) != Boolean.TRUE) continue;
                annotation.delete();
            }
        }
    }

    public static boolean isLeafElementOfType(@Nullable PsiElement element, @NotNull IElementType type2) {
        return element instanceof LeafElement && ((LeafElement)element).getElementType() == type2;
    }

    public static boolean isLeafElementOfType(PsiElement element, @NotNull TokenSet tokenSet) {
        return element instanceof LeafElement && tokenSet.contains(((LeafElement)element).getElementType());
    }

    public static PsiType buildTypeFromTypeString(@NotNull String typeName, @NotNull PsiElement context, @NotNull PsiFile psiFile) {
        Object resultType;
        PsiClass aClass;
        PsiManager psiManager = psiFile.getManager();
        if (typeName.indexOf(60) != -1 || typeName.indexOf(91) != -1 || typeName.indexOf(46) == -1) {
            try {
                return JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createTypeFromText(typeName, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((aClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(typeName, context.getResolveScope())) == null) {
            LightClassReference ref = new LightClassReference(psiManager, PsiNameHelper.getShortClassName((String)typeName), typeName, PsiSubstitutor.EMPTY, (PsiElement)psiFile);
            resultType = new PsiClassReferenceType(ref, null);
        } else {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            PsiSubstitutor substitutor = factory.createRawSubstitutor((PsiTypeParameterListOwner)aClass);
            resultType = factory.createType(aClass, substitutor);
        }
        return resultType;
    }

    @NotNull
    public static <T extends PsiJavaCodeReferenceElement> JavaResolveResult[] multiResolveImpl(@NotNull T element, boolean incompleteCode, @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver) {
        Map map2;
        PsiManager manager;
        FileASTNode fileElement = SharedImplUtil.findFileElement(element.getNode());
        if (fileElement == null) {
            PsiUtilCore.ensureValid(element);
            LOG.error("fileElement == null!");
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiFile psiFile = SharedImplUtil.getContainingFile((ASTNode)fileElement);
        PsiManager psiManager = manager = psiFile == null ? null : psiFile.getManager();
        if (manager == null) {
            PsiUtilCore.ensureValid(element);
            LOG.error("getManager() == null!");
            return JavaResolveResult.EMPTY_ARRAY;
        }
        boolean valid = psiFile.isValid();
        if (!valid) {
            PsiUtilCore.ensureValid(element);
            LOG.error("psiFile.isValid() == false!");
            return JavaResolveResult.EMPTY_ARRAY;
        }
        if (element instanceof PsiMethodReferenceExpression && (map2 = (Map)LambdaUtil.ourFunctionTypes.get()) != null && map2.containsKey(element)) {
            return (JavaResolveResult[])resolver.resolve(element, psiFile, incompleteCode);
        }
        return PsiImplUtil.multiResolveImpl(manager.getProject(), psiFile, element, incompleteCode, resolver);
    }

    public static <T extends PsiJavaCodeReferenceElement> JavaResolveResult[] multiResolveImpl(@NotNull Project project2, @NotNull PsiFile psiFile, @NotNull T element, boolean incompleteCode, @NotNull ResolveCache.PolyVariantContextResolver<? super T> resolver) {
        ResolveResult[] results = ResolveCache.getInstance(project2).resolveWithCaching(element, resolver, true, incompleteCode, psiFile);
        return results.length == 0 ? JavaResolveResult.EMPTY_ARRAY : (JavaResolveResult[])results;
    }

    public static VirtualFile getModuleVirtualFile(@NotNull PsiJavaModule module2) {
        if (module2 instanceof LightJavaModule) {
            return ((LightJavaModule)module2).getRootVirtualFile();
        }
        return module2.getContainingFile().getVirtualFile();
    }
}

