/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SyntheticFileSystemItem
extends PsiElementBase
implements PsiFileSystemItem {
    private static final Logger LOG = Logger.getInstance((String)("#" + SyntheticFileSystemItem.class.getPackage().getName()));
    protected final Project myProject;
    protected final PsiManager myManager;

    public SyntheticFileSystemItem(Project project2) {
        this.myProject = project2;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
    }

    protected static boolean processFileSystemItem(PsiElementProcessor<PsiFileSystemItem> processor2, PsiFileSystemItem element) {
        if (processor2 instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor2).acceptItem(element.getName(), true)) {
            return true;
        }
        return processor2.execute((PsiElement)element);
    }

    public boolean isDirectory() {
        return true;
    }

    public ASTNode getNode() {
        return null;
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isValid() {
        VirtualFile virtualFile = this.getVirtualFile();
        return virtualFile != null && virtualFile.isValid();
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        throw new IncorrectOperationException("Frameworks cannot be changed");
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        throw new IncorrectOperationException("Frameworks cannot be deleted");
    }

    @Override
    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException("Frameworks cannot be deleted");
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElementProcessor.CollectElements collector = new PsiElementProcessor.CollectElements();
        this.processChildren((PsiElementProcessor)collector);
        return collector.toArray((PsiElement[])new PsiFileSystemItem[0]);
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @NotNull
    public Language getLanguage() {
        return Language.ANY;
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Frameworks cannot be renamed");
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Frameworks cannot be renamed");
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return null;
    }

    @Nullable
    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return -1;
    }

    public int getTextLength() {
        return -1;
    }

    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return -1;
    }

    @Nullable
    public String getText() {
        return null;
    }

    @NotNull
    public char[] textToCharArray() {
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        return false;
    }

    @Override
    public PsiElement copy() {
        LOG.error("method not implemented");
        return null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }
}

