/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.beanProperties;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateBeanPropertyFix
implements LocalQuickFix,
IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.beanProperties.CreateBeanPropertyFix");
    private static final CreateBeanPropertyFix[] NO_FIXES = new CreateBeanPropertyFix[0];
    protected final String myPropertyName;
    @NotNull
    protected final PsiClass myPsiClass;
    @NotNull
    protected final PsiType myType;

    public static LocalQuickFix[] createFixes(String propertyName, @NotNull PsiClass psiClass, @Nullable PsiType type2, boolean createSetter) {
        return (LocalQuickFix[])CreateBeanPropertyFix.create(propertyName, psiClass, type2, createSetter);
    }

    public static IntentionAction[] createActions(String propertyName, @NotNull PsiClass psiClass, @Nullable PsiType type2, boolean createSetter) {
        return (IntentionAction[])CreateBeanPropertyFix.create(propertyName, psiClass, type2, createSetter);
    }

    private static Object[] create(String propertyName, PsiClass psiClass, PsiType type2, final boolean createSetter) {
        if (psiClass instanceof PsiCompiledElement) {
            return NO_FIXES;
        }
        if (type2 == null) {
            Project project2 = psiClass.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
            PsiClass aClass = facade.findClass("java.lang.String", GlobalSearchScope.allScope((Project)project2));
            if (aClass == null) {
                return NO_FIXES;
            }
            type2 = facade.getElementFactory().createType(aClass);
        }
        if (psiClass.isInterface()) {
            return new CreateBeanPropertyFix[]{new CreateAccessorFix(propertyName, psiClass, type2, createSetter)};
        }
        return new CreateBeanPropertyFix[]{new CreateBeanPropertyFix(propertyName, psiClass, type2){

            @NotNull
            public String getName() {
                return QuickFixBundle.message("create.readable.writable.property.with.field", this.myPropertyName);
            }

            @Override
            protected void doFix() throws IncorrectOperationException {
                this.createField();
                this.createSetter(true);
                this.createGetter(true);
            }
        }, new CreateAccessorFix(propertyName, psiClass, type2, createSetter), new CreateBeanPropertyFix(propertyName, psiClass, type2){

            @Override
            protected void doFix() throws IncorrectOperationException {
                this.createField();
                if (createSetter) {
                    this.createSetter(true);
                } else {
                    this.createGetter(true);
                }
            }

            @NotNull
            public String getName() {
                return QuickFixBundle.message(createSetter ? "create.writable.property.with.field" : "create.readable.property.with.field", this.myPropertyName);
            }
        }};
    }

    protected CreateBeanPropertyFix(String propertyName, @NotNull PsiClass psiClass, @NotNull PsiType type2) {
        this.myPropertyName = propertyName;
        this.myPsiClass = psiClass;
        this.myType = type2;
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        this.applyFix(project2);
    }

    private void applyFix(Project project2) {
        new WriteCommandAction.Simple(project2, this.getName(), new PsiFile[]{this.myPsiClass.getContainingFile()}){

            protected void run() throws Throwable {
                try {
                    CreateBeanPropertyFix.this.doFix();
                }
                catch (IncorrectOperationException e) {
                    LOG.error("Cannot create property", (Throwable)e);
                }
            }
        }.execute();
    }

    @NotNull
    public String getText() {
        return this.getName();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.applyFix(project2);
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract void doFix() throws IncorrectOperationException;

    private String getFieldName() {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myPsiClass.getProject());
        return styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)this.myPropertyName, null, (PsiType)this.myType).names[0];
    }

    protected PsiElement createSetter(boolean createField) throws IncorrectOperationException {
        String text;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory();
        String methodName = PropertyUtil.suggestSetterName((String)this.myPropertyName);
        String typeName = this.myType.getCanonicalText();
        boolean isInterface = this.myPsiClass.isInterface();
        if (isInterface) {
            text = "public void " + methodName + "(" + typeName + " " + this.myPropertyName + ");";
        } else if (createField) {
            String fieldName = this.getFieldName();
            if (fieldName.equals(this.myPropertyName)) {
                fieldName = "this." + fieldName;
            }
            text = "public void " + methodName + "(" + typeName + " " + this.myPropertyName + ") {" + fieldName + "=" + this.myPropertyName + ";}";
        } else {
            text = "public void " + methodName + "(" + typeName + " " + this.myPropertyName + ") {}";
        }
        PsiMethod method2 = elementFactory.createMethodFromText(text, null);
        PsiMethod psiElement = (PsiMethod)this.myPsiClass.add((PsiElement)method2);
        if (!isInterface && !createField) {
            CreateFromUsageUtils.setupMethodBody(psiElement, this.myPsiClass);
        }
        return psiElement;
    }

    protected PsiElement createGetter(boolean createField) throws IncorrectOperationException {
        String text;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory();
        String methodName = PropertyUtil.suggestGetterName((String)this.myPropertyName, (PsiType)this.myType);
        String typeName = this.myType.getCanonicalText();
        boolean isInterface = this.myPsiClass.isInterface();
        if (createField) {
            String fieldName = this.getFieldName();
            text = "public " + typeName + " " + methodName + "() { return " + fieldName + "; }";
        } else {
            text = isInterface ? typeName + " " + methodName + "();" : "public " + typeName + " " + methodName + "() { return null; }";
        }
        PsiMethod method2 = elementFactory.createMethodFromText(text, null);
        PsiMethod psiElement = (PsiMethod)this.myPsiClass.add((PsiElement)method2);
        if (!createField && !isInterface) {
            CreateFromUsageUtils.setupMethodBody(psiElement);
        }
        return psiElement;
    }

    protected PsiElement createField() throws IncorrectOperationException {
        String fieldName = this.getFieldName();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).getElementFactory();
        PsiField psiField = elementFactory.createField(fieldName, this.myType);
        return this.myPsiClass.add((PsiElement)psiField);
    }

    private static class CreateAccessorFix
    extends CreateBeanPropertyFix {
        private final boolean myCreateSetter;

        public CreateAccessorFix(String propertyName, PsiClass psiClass, PsiType type2, boolean createSetter) {
            super(propertyName, psiClass, type2);
            this.myCreateSetter = createSetter;
        }

        @Override
        protected void doFix() throws IncorrectOperationException {
            if (this.myCreateSetter) {
                this.createSetter(false);
            } else {
                this.createGetter(false);
            }
        }

        @NotNull
        public String getName() {
            return QuickFixBundle.message(this.myCreateSetter ? "create.writable.property" : "create.readable.property", this.myPropertyName);
        }
    }
}

