/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.BitUtil;
import com.intellij.util.SmartList;
import com.intellij.util.io.StringRef;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeInfo {
    private static final String[] ourIndexFrequentType = new String[]{"", "boolean", "byte", "char", "double", "float", "int", "long", "null", "short", "void", "Object", "java.lang.Object", "String", "java.lang.String"};
    private static final TObjectIntHashMap<String> ourFrequentTypeIndex = new TObjectIntHashMap();
    private static final int FREQUENT_INDEX_MASK = 63;
    private static final int HAS_ARRAY_COUNT = 64;
    private static final int HAS_ELLIPSIS = 128;
    private static final TypeInfo NULL;
    public final String text;
    public final byte arrayCount;
    public final boolean isEllipsis;
    private final PsiAnnotationStub[] myAnnotationStubs;

    public TypeInfo(String text, byte arrayCount, boolean ellipsis, @NotNull PsiAnnotationStub[] annotationStubs) {
        this.text = text == null ? null : TypeInfo.internFrequentType(text);
        this.arrayCount = arrayCount;
        this.isEllipsis = ellipsis;
        this.myAnnotationStubs = annotationStubs;
    }

    @NotNull
    public TypeInfo applyAnnotations(@NotNull StubBase<?> owner) {
        PsiModifierListStub modifierList = (PsiModifierListStub)owner.findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        if (modifierList == null) {
            return this;
        }
        List annotationStubs = null;
        for (StubElement child : modifierList.getChildrenStubs()) {
            PsiAnnotationStub annotationStub;
            if (!(child instanceof PsiAnnotationStub) || !PsiImplUtil.isTypeAnnotation((PsiElement)(annotationStub = (PsiAnnotationStub)child).getPsiElement())) continue;
            if (annotationStubs == null) {
                annotationStubs = new SmartList();
            }
            annotationStubs.add(annotationStub);
        }
        PsiAnnotationStub[] stubArray = PsiAnnotationStub.EMPTY_ARRAY;
        if (annotationStubs != null) {
            stubArray = annotationStubs.toArray(new PsiAnnotationStub[annotationStubs.size()]);
        }
        return new TypeInfo(this.text, this.arrayCount, this.isEllipsis, stubArray);
    }

    @NotNull
    public String getShortTypeText() {
        if (this.text == null) {
            return "";
        }
        String name = PsiNameHelper.getShortClassName((String)this.text);
        if (this.arrayCount > 0) {
            name = name + StringUtil.repeat((String)"[]", (int)this.arrayCount);
        }
        return name;
    }

    public String toString() {
        String text = TypeInfo.createTypeText(this);
        return text != null ? text : "null";
    }

    @NotNull
    public static TypeInfo createConstructorType() {
        return NULL;
    }

    @NotNull
    public static TypeInfo create(@NotNull LighterAST tree, @NotNull LighterASTNode element, StubElement parentStub) {
        String text;
        byte arrayCount = 0;
        boolean isEllipsis = false;
        if (element.getTokenType() == JavaElementType.ENUM_CONSTANT) {
            text = ((PsiClassStub)parentStub).getName();
        } else {
            LighterASTNode nested;
            LighterASTNode typeElement = null;
            for (LighterASTNode child : tree.getChildren(element)) {
                IElementType type2 = child.getTokenType();
                if (type2 == JavaElementType.TYPE) {
                    typeElement = child;
                    continue;
                }
                if (type2 != JavaTokenType.LBRACKET) continue;
                arrayCount = (byte)(arrayCount + 1);
            }
            if (typeElement == null && element.getTokenType() == JavaElementType.FIELD) {
                LighterASTNode parent = tree.getParent(element);
                assert (parent != null) : element;
                List<LighterASTNode> fields = LightTreeUtil.getChildrenOfType(tree, parent, JavaElementType.FIELD);
                int idx = fields.indexOf(element);
                for (int i = idx - 1; i >= 0 && typeElement == null; --i) {
                    typeElement = LightTreeUtil.firstChildOfType(tree, fields.get(i), JavaElementType.TYPE);
                }
            }
            assert (typeElement != null) : element + " in " + parentStub;
            boolean bl = isEllipsis = LightTreeUtil.firstChildOfType(tree, typeElement, JavaTokenType.ELLIPSIS) != null;
            while ((nested = LightTreeUtil.firstChildOfType(tree, typeElement, JavaElementType.TYPE)) != null) {
                typeElement = nested;
                arrayCount = (byte)(arrayCount + 1);
            }
            text = LightTreeUtil.toFilteredString(tree, typeElement, null);
        }
        return new TypeInfo(text, arrayCount, isEllipsis, PsiAnnotationStub.EMPTY_ARRAY);
    }

    @NotNull
    public static TypeInfo fromString(@NotNull String typeText, boolean isEllipsis) {
        assert (!typeText.endsWith("...")) : typeText;
        byte arrayCount = 0;
        while (typeText.endsWith("[]")) {
            arrayCount = (byte)(arrayCount + 1);
            typeText = typeText.substring(0, typeText.length() - 2);
        }
        return new TypeInfo(typeText, arrayCount, isEllipsis, PsiAnnotationStub.EMPTY_ARRAY);
    }

    @NotNull
    public static TypeInfo fromString(@NotNull String typeText) {
        boolean isEllipsis = false;
        if (typeText.endsWith("...")) {
            isEllipsis = true;
            typeText = typeText.substring(0, typeText.length() - 3);
        }
        return TypeInfo.fromString(typeText, isEllipsis);
    }

    @NotNull
    public static TypeInfo readTYPE(@NotNull StubInputStream record) throws IOException {
        int flags = record.readByte() & 0xFF;
        if (flags == 63) {
            return NULL;
        }
        byte arrayCount = BitUtil.isSet((int)flags, (int)64) ? record.readByte() : (byte)0;
        boolean hasEllipsis = BitUtil.isSet((int)flags, (int)128);
        int frequentIndex = 0x3F & flags;
        String text = frequentIndex == 0 ? StringRef.toString((StringRef)record.readName()) : ourIndexFrequentType[frequentIndex];
        return new TypeInfo(text, arrayCount, hasEllipsis, PsiAnnotationStub.EMPTY_ARRAY);
    }

    public static void writeTYPE(@NotNull StubOutputStream dataStream, @NotNull TypeInfo typeInfo) throws IOException {
        if (typeInfo == NULL) {
            dataStream.writeByte(63);
            return;
        }
        String text = typeInfo.text;
        byte arrayCount = typeInfo.arrayCount;
        int frequentIndex = ourFrequentTypeIndex.get((Object)text);
        int flags = (typeInfo.isEllipsis ? 128 : 0) | (arrayCount != 0 ? 64 : 0) | frequentIndex;
        dataStream.writeByte(flags);
        if (arrayCount != 0) {
            dataStream.writeByte((int)arrayCount);
        }
        if (frequentIndex == 0) {
            dataStream.writeName(text);
        }
    }

    @Nullable
    public static String createTypeText(@NotNull TypeInfo typeInfo) {
        if (typeInfo == NULL || typeInfo.text == null) {
            return null;
        }
        if (typeInfo.arrayCount == 0 && typeInfo.myAnnotationStubs.length == 0) {
            return typeInfo.text;
        }
        StringBuilder buf = new StringBuilder();
        for (PsiAnnotationStub stub : typeInfo.myAnnotationStubs) {
            buf.append(stub.getText()).append(' ');
        }
        buf.append(typeInfo.text);
        int arrayCount = typeInfo.isEllipsis ? typeInfo.arrayCount - 1 : typeInfo.arrayCount;
        for (int i = 0; i < arrayCount; ++i) {
            buf.append("[]");
        }
        if (typeInfo.isEllipsis) {
            buf.append("...");
        }
        return TypeInfo.internFrequentType(buf.toString());
    }

    @NotNull
    public static String internFrequentType(@NotNull String type2) {
        int frequentIndex = ourFrequentTypeIndex.get((Object)type2);
        return frequentIndex == 0 ? type2 : ourIndexFrequentType[frequentIndex];
    }

    static {
        for (int i = 0; i < ourIndexFrequentType.length; ++i) {
            ourFrequentTypeIndex.put((Object)ourIndexFrequentType[i], i);
        }
        NULL = new TypeInfo(null, 0, false, PsiAnnotationStub.EMPTY_ARRAY);
    }
}

