/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.VersionedTodoIndexer;
import com.intellij.psi.search.IndexPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PlainTextTodoIndexer
extends VersionedTodoIndexer {
    @NotNull
    public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
        String chars = inputData.getContentAsText().toString();
        IndexPattern[] indexPatterns = IndexPatternUtil.getIndexPatterns();
        if (indexPatterns.length <= 0) {
            return Collections.emptyMap();
        }
        OccurrenceConsumer occurrenceConsumer = new OccurrenceConsumer(null, true);
        for (IndexPattern indexPattern : indexPatterns) {
            Pattern pattern = indexPattern.getOptimizedIndexingPattern();
            if (pattern == null) continue;
            Matcher matcher = pattern.matcher(chars);
            while (matcher.find()) {
                if (matcher.start() == matcher.end()) continue;
                occurrenceConsumer.incTodoOccurrence(indexPattern);
            }
        }
        HashMap<TodoIndexEntry, Integer> map2 = new HashMap<TodoIndexEntry, Integer>();
        for (IndexPattern indexPattern : indexPatterns) {
            int count = occurrenceConsumer.getOccurrenceCount(indexPattern);
            if (count <= 0) continue;
            map2.put(new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), count);
        }
        return map2;
    }
}

