/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClassFileStubBuilder");
    public static final int STUB_VERSION = 19;
    private static final Comparator<Object> CLASS_NAME_COMPARATOR = Comparator.comparing(o -> o.getClass().getName());

    public boolean acceptsFile(@NotNull VirtualFile file2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public StubElement buildStubTree(@NotNull FileContent fileContent) {
        byte[] content;
        VirtualFile file2;
        block11: {
            file2 = fileContent.getFile();
            content = fileContent.getContent();
            file2.setPreloadedContentHint(content);
            ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find((VirtualFile)file2);
            if (!(decompiler instanceof ClassFileDecompilers.Full)) break block11;
            PsiFileStub psiFileStub = ((ClassFileDecompilers.Full)decompiler).getStubBuilder().buildFileStub(fileContent);
            file2.setPreloadedContentHint(null);
            return psiFileStub;
        }
        try {
            block14: {
                break block14;
                catch (ClsFormatException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(file2.getPath(), (Throwable)e);
                    }
                    LOG.info(file2.getPath() + ": " + e.getMessage());
                }
            }
            try {
                PsiJavaFileStub stub = ClsFileImpl.buildFileStub(file2, content);
                if (stub == null && fileContent.getFileName().indexOf(36) < 0) {
                    LOG.info("No stub built for file " + fileContent);
                }
                PsiJavaFileStub psiJavaFileStub = stub;
                return psiJavaFileStub;
            }
            catch (ClsFormatException e) {
                block12: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(file2.getPath(), (Throwable)e);
                        break block12;
                    }
                    LOG.info(file2.getPath() + ": " + e.getMessage());
                }
                file2.setPreloadedContentHint(null);
            }
        }
        finally {
            file2.setPreloadedContentHint(null);
        }
        return null;
    }

    public int getStubVersion() {
        int version = 19;
        ArrayList decompilers = ContainerUtil.newArrayList((Object[])ClassFileDecompilers.EP_NAME.getExtensions());
        decompilers.sort(CLASS_NAME_COMPARATOR);
        for (ClassFileDecompilers.Decompiler decompiler : decompilers) {
            if (!(decompiler instanceof ClassFileDecompilers.Full)) continue;
            version = version * 31 + ((ClassFileDecompilers.Full)decompiler).getStubBuilder().getStubVersion() + decompiler.getClass().getName().hashCode();
        }
        return version;
    }
}

