/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaTokenImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class ClsBinaryExpressionImpl
extends ClsElementImpl
implements PsiBinaryExpression {
    private final ClsElementImpl myParent;
    private final PsiJavaToken myOperator;
    private final PsiExpression myLOperand;
    private final PsiExpression myROperand;

    ClsBinaryExpressionImpl(ClsElementImpl parent, PsiJavaToken sign, PsiExpression left, PsiExpression right) {
        this.myParent = parent;
        this.myOperator = new ClsJavaTokenImpl(this, sign.getTokenType(), sign.getText());
        this.myLOperand = ClsParsingUtil.psiToClsExpression(left, this);
        this.myROperand = ClsParsingUtil.psiToClsExpression(right, this);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        buffer.append(this.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, JavaElementType.BINARY_EXPRESSION);
    }

    @Override
    public String getText() {
        return StringUtil.join((String[])new String[]{this.myLOperand.getText(), " ", this.myOperator.getText(), " ", this.myROperand.getText()});
    }

    @NotNull
    public PsiElement[] getChildren() {
        return new PsiElement[]{this.myLOperand, this.myOperator, this.myROperand};
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitBinaryExpression((PsiBinaryExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiExpression getLOperand() {
        return this.myLOperand;
    }

    @NotNull
    public PsiExpression getROperand() {
        return this.myROperand;
    }

    @NotNull
    public PsiJavaToken getOperationSign() {
        return this.myOperator;
    }

    @NotNull
    public IElementType getOperationTokenType() {
        return this.myOperator.getTokenType();
    }

    public PsiJavaToken getTokenBeforeOperand(@NotNull PsiExpression operand2) {
        return this.getOperationSign();
    }

    public PsiType getType() {
        return this.myLOperand.getType();
    }

    @NotNull
    public PsiExpression[] getOperands() {
        return new PsiExpression[]{this.getLOperand(), this.getROperand()};
    }

    public String toString() {
        return "PsiBinaryExpression:" + this.getText();
    }
}

