/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsReferenceParameterListImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsJavaCodeReferenceElementImpl
extends ClsElementImpl
implements PsiAnnotatedJavaCodeReferenceElement {
    private final PsiElement myParent;
    private final String myCanonicalText;
    private final String myQualifiedName;
    private final PsiReferenceParameterList myRefParameterList;

    public ClsJavaCodeReferenceElementImpl(PsiElement parent, @NotNull String canonicalText) {
        String canonical;
        this.myParent = parent;
        this.myCanonicalText = canonical = TypeInfo.internFrequentType(canonicalText);
        String qName = TypeInfo.internFrequentType(PsiNameHelper.getQualifiedClassName((String)this.myCanonicalText, (boolean)false));
        this.myQualifiedName = qName.equals(canonical) ? canonical : qName;
        String[] classParameters = PsiNameHelper.getClassParametersText((String)canonicalText);
        this.myRefParameterList = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl((PsiElement)this, classParameters);
    }

    @NotNull
    public PsiElement[] getChildren() {
        return PsiElement.EMPTY_ARRAY;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        return PsiNameHelper.getPresentableText((PsiJavaCodeReferenceElement)this);
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myCanonicalText;
    }

    @NotNull
    public String getCanonicalText(boolean annotated, @Nullable PsiAnnotation[] annotations2) {
        String text = this.getCanonicalText();
        if (!annotated || annotations2 == null) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        String prefix = ClsJavaCodeReferenceElementImpl.getOuterClassRef(text);
        int tailStart = 0;
        if (!StringUtil.isEmpty((String)prefix)) {
            sb.append(prefix).append('.');
            tailStart = prefix.length() + 1;
        }
        PsiNameHelper.appendAnnotations((StringBuilder)sb, Arrays.asList(annotations2), (boolean)true);
        sb.append(text, tailStart, text.length());
        return sb.toString();
    }

    private JavaResolveResult advancedResolveImpl(@NotNull PsiFile containingFile) {
        PsiTypeElement[] typeElements = this.myRefParameterList == null ? PsiTypeElement.EMPTY_ARRAY : this.myRefParameterList.getTypeParameterElements();
        PsiElement resolve2 = this.resolveElement(containingFile);
        if (resolve2 == null) {
            return null;
        }
        if (resolve2 instanceof PsiClass) {
            HashMap substitutionMap = new HashMap();
            int index = 0;
            for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)((PsiClass)resolve2))) {
                if (index >= typeElements.length) {
                    PsiTypeParameterListOwner parameterOwner = parameter.getOwner();
                    if (parameterOwner == resolve2) {
                        substitutionMap.put(parameter, null);
                    } else if (parameterOwner instanceof PsiClass) {
                        PsiElement containingClass = this.myParent;
                        while ((containingClass = PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class, (boolean)true)) != null) {
                            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)((PsiClass)parameterOwner), (PsiClass)((PsiClass)containingClass), (PsiSubstitutor)PsiSubstitutor.EMPTY);
                            if (superClassSubstitutor == null) continue;
                            substitutionMap.put(parameter, superClassSubstitutor.substitute(parameter));
                            break;
                        }
                    }
                } else {
                    substitutionMap.put(parameter, typeElements[index].getType());
                }
                ++index;
            }
            this.collectOuterClassTypeArgs((PsiClass)resolve2, this.myCanonicalText, (Map<PsiTypeParameter, PsiType>)substitutionMap);
            return new CandidateInfo(resolve2, PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)substitutionMap));
        }
        return new CandidateInfo(resolve2, PsiSubstitutor.EMPTY);
    }

    private void collectOuterClassTypeArgs(@NotNull PsiClass psiClass, String canonicalText, Map<PsiTypeParameter, PsiType> substitutionMap) {
        PsiClass containingClass = psiClass.getContainingClass();
        if (containingClass != null) {
            String outerClassRef = ClsJavaCodeReferenceElementImpl.getOuterClassRef(canonicalText);
            String[] classParameters = PsiNameHelper.getClassParametersText((String)outerClassRef);
            PsiType[] args = classParameters.length == 0 ? null : new ClsReferenceParameterListImpl((PsiElement)this, classParameters).getTypeArguments();
            PsiTypeParameter[] typeParameters = containingClass.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (args != null) {
                    if (i >= args.length) continue;
                    substitutionMap.put(typeParameters[i], args[i]);
                    continue;
                }
                substitutionMap.put(typeParameters[i], null);
            }
            if (!containingClass.hasModifierProperty("static")) {
                this.collectOuterClassTypeArgs(containingClass, outerClassRef, substitutionMap);
            }
        }
    }

    @NotNull
    @Contract(pure=true)
    private static String getOuterClassRef(String ref) {
        int stack = 0;
        block5: for (int i = ref.length() - 1; i >= 0; --i) {
            char c = ref.charAt(i);
            switch (c) {
                case '<': {
                    --stack;
                    continue block5;
                }
                case '>': {
                    ++stack;
                    continue block5;
                }
                case '.': {
                    if (stack != 0) continue block5;
                    return ref.substring(0, i);
                }
            }
        }
        return "";
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            return results[0];
        }
        return JavaResolveResult.EMPTY;
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.getContainingFile();
        ResolveCache resolveCache = ResolveCache.getInstance(file2.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, Resolver.INSTANCE, true, incompleteCode, file2);
        if (results.length == 0) {
            return JavaResolveResult.EMPTY_ARRAY;
        }
        return (JavaResolveResult[])results;
    }

    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Nullable
    private PsiElement resolveElement(@NotNull PsiFile containingFile) {
        for (PsiElement element = this.getParent(); element != null && !(element instanceof PsiFile); element = element.getParent()) {
            Object parameter2;
            if (element instanceof PsiMethod) {
                for (Object parameter2 : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)((PsiMethod)element))) {
                    if (!this.myQualifiedName.equals(parameter2.getName())) continue;
                    return parameter2;
                }
                continue;
            }
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) continue;
            PsiClass psiClass = (PsiClass)element;
            if (this.myQualifiedName.equals(psiClass.getQualifiedName())) {
                return element;
            }
            parameter2 = PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)psiClass).iterator();
            while (parameter2.hasNext()) {
                PsiTypeParameter parameter3 = (PsiTypeParameter)parameter2.next();
                if (!this.myQualifiedName.equals(parameter3.getName())) continue;
                return parameter3;
            }
            for (PsiClass innerClass : psiClass.getInnerClasses()) {
                if (!this.myQualifiedName.equals(innerClass.getQualifiedName())) continue;
                return innerClass;
            }
        }
        Project project2 = containingFile.getProject();
        GlobalSearchScope scope = ResolveScopeManager.getInstance(project2).getResolveScope((PsiElement)this);
        return JavaPsiFacade.getInstance((Project)project2).findClass(this.myQualifiedName, scope);
    }

    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        throw new RuntimeException("Variants are not available for light references");
    }

    public PsiElement getReferenceNameElement() {
        return null;
    }

    public PsiReferenceParameterList getParameterList() {
        return this.myRefParameterList;
    }

    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    public String getReferenceName() {
        return PsiNameHelper.getShortClassName((String)this.myCanonicalText);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw ClsJavaCodeReferenceElementImpl.cannotModifyException(this);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw ClsJavaCodeReferenceElementImpl.cannotModifyException(this);
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)element;
        return this.myCanonicalText.equals(aClass.getQualifiedName()) || this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for references to compiled code");
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        buffer.append(this.getCanonicalText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, JavaElementType.JAVA_CODE_REFERENCE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    public PsiElement getElement() {
        return this;
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        return this.myRefParameterList == null ? PsiType.EMPTY_ARRAY : this.myRefParameterList.getTypeArguments();
    }

    public boolean isQualified() {
        return false;
    }

    public PsiElement getQualifier() {
        return null;
    }

    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    private static class Resolver
    implements ResolveCache.PolyVariantContextResolver<ClsJavaCodeReferenceElementImpl> {
        public static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        @NotNull
        public JavaResolveResult[] resolve(@NotNull ClsJavaCodeReferenceElementImpl ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            JavaResolveResult resolveResult = ref.advancedResolveImpl(containingFile);
            if (resolveResult == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = resolveResult;
            }
            return javaResolveResultArray;
        }
    }
}

