/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsMemberImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsMethodImpl
extends ClsMemberImpl<PsiMethodStub>
implements PsiAnnotationMethod {
    private final NotNullLazyValue<PsiTypeElement> myReturnType = this.isConstructor() ? null : new AtomicNotNullLazyValue<PsiTypeElement>(){

        @NotNull
        protected PsiTypeElement compute() {
            PsiMethodStub stub = (PsiMethodStub)ClsMethodImpl.this.getStub();
            String typeText = TypeInfo.createTypeText(stub.getReturnTypeText(false));
            assert (typeText != null) : stub;
            return new ClsTypeElementImpl((PsiElement)ClsMethodImpl.this, typeText, '\u0000');
        }
    };
    private final NotNullLazyValue<PsiAnnotationMemberValue> myDefaultValue;

    public ClsMethodImpl(PsiMethodStub stub) {
        super(stub);
        final String text = ((PsiMethodStub)this.getStub()).getDefaultValueText();
        this.myDefaultValue = StringUtil.isEmptyOrSpaces((String)text) ? null : new AtomicNotNullLazyValue<PsiAnnotationMemberValue>(){

            @NotNull
            protected PsiAnnotationMemberValue compute() {
                return ClsParsingUtil.createMemberValueFromText(text, ClsMethodImpl.this.getManager(), ClsMethodImpl.this);
            }
        };
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        return this.getChildren(new PsiElement[]{this.getDocComment(), this.getModifierList(), this.getReturnTypeElement(), this.getNameIdentifier(), this.getParameterList(), this.getThrowsList(), this.getDefaultValue()});
    }

    public PsiClass getContainingClass() {
        return (PsiClass)this.getParent();
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this);
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        return PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic((PsiMethod)this, checkAccess);
    }

    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod((PsiMethod)this);
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethods((PsiMethod)this);
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        return PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)this);
    }

    public PsiTypeElement getReturnTypeElement() {
        return this.myReturnType != null ? (PsiTypeElement)this.myReturnType.getValue() : null;
    }

    public PsiType getReturnType() {
        PsiTypeElement typeElement = this.getReturnTypeElement();
        return typeElement == null ? null : typeElement.getType();
    }

    @NotNull
    public PsiModifierList getModifierList() {
        return (PsiModifierList)((PsiMethodStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST).getPsi();
    }

    public boolean hasModifierProperty(@NotNull String name) {
        return this.getModifierList().hasModifierProperty(name);
    }

    @NotNull
    public PsiParameterList getParameterList() {
        return (PsiParameterList)((PsiMethodStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.PARAMETER_LIST).getPsi();
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        return (PsiReferenceList)((PsiMethodStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.THROWS_LIST).getPsi();
    }

    public PsiTypeParameterList getTypeParameterList() {
        return (PsiTypeParameterList)((PsiMethodStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.TYPE_PARAMETER_LIST).getPsi();
    }

    public PsiCodeBlock getBody() {
        return null;
    }

    public boolean isDeprecated() {
        return ((PsiMethodStub)this.getStub()).isDeprecated() || PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public PsiAnnotationMemberValue getDefaultValue() {
        return this.myDefaultValue != null ? (PsiAnnotationMemberValue)this.myDefaultValue.getValue() : null;
    }

    public boolean isConstructor() {
        return ((PsiMethodStub)this.getStub()).isConstructor();
    }

    public boolean isVarArgs() {
        return ((PsiMethodStub)this.getStub()).isVarArgs();
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        return MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        PsiAnnotationMemberValue defaultValue;
        ClsMethodImpl.appendText((PsiElement)this.getDocComment(), indentLevel, buffer, "go_to_next_line_and_indent");
        ClsMethodImpl.appendText((PsiElement)this.getModifierList(), indentLevel, buffer, "");
        ClsMethodImpl.appendText((PsiElement)this.getTypeParameterList(), indentLevel, buffer, " ");
        if (!this.isConstructor()) {
            ClsMethodImpl.appendText((PsiElement)this.getReturnTypeElement(), indentLevel, buffer, " ");
        }
        ClsMethodImpl.appendText((PsiElement)this.getNameIdentifier(), indentLevel, buffer, "");
        ClsMethodImpl.appendText((PsiElement)this.getParameterList(), indentLevel, buffer);
        PsiReferenceList throwsList = this.getThrowsList();
        if (throwsList.getReferencedTypes().length > 0) {
            buffer.append(' ');
            ClsMethodImpl.appendText((PsiElement)throwsList, indentLevel, buffer);
        }
        if ((defaultValue = this.getDefaultValue()) != null) {
            buffer.append(" default ");
            ClsMethodImpl.appendText((PsiElement)defaultValue, indentLevel, buffer);
        }
        if (this.hasModifierProperty("abstract") || this.hasModifierProperty("native")) {
            buffer.append(";");
        } else {
            buffer.append(" { /* compiled code */ }");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, null);
        PsiMethod mirror = (PsiMethod)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsMethodImpl.setMirrorIfPresent(this.getDocComment(), mirror.getDocComment());
        ClsMethodImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsMethodImpl.setMirror(this.getTypeParameterList(), mirror.getTypeParameterList());
        if (!this.isConstructor()) {
            ClsMethodImpl.setMirror(this.getReturnTypeElement(), mirror.getReturnTypeElement());
        }
        ClsMethodImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsMethodImpl.setMirror(this.getParameterList(), mirror.getParameterList());
        ClsMethodImpl.setMirror(this.getThrowsList(), mirror.getThrowsList());
        PsiAnnotationMemberValue defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            assert (mirror instanceof PsiAnnotationMethod) : this;
            ClsMethodImpl.setMirror(defaultValue, ((PsiAnnotationMethod)mirror).getDefaultValue());
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod((PsiMethod)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiParameter[] parameters2;
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null) {
            return true;
        }
        if (!PsiScopesUtil.walkChildrenScopes((PsiElement)this, processor2, state, lastParent, place)) {
            return false;
        }
        for (PsiParameter parameter : parameters2 = this.getParameterList().getParameters()) {
            if (processor2.execute((PsiElement)parameter, state)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public PsiMethod getSourceMirrorMethod() {
        return (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcSourceMirrorMethod(), (Object[])new Object[]{this.getContainingFile(), this.getContainingFile().getNavigationElement(), FileIndexFacade.getInstance((Project)this.getProject()).getRootModificationTracker()}));
    }

    @Nullable
    private PsiMethod calcSourceMirrorMethod() {
        PsiClass sourceClassMirror = ((ClsClassImpl)this.getParent()).getSourceMirrorClass();
        if (sourceClassMirror == null) {
            return null;
        }
        for (PsiMethod sourceMethod : sourceClassMirror.findMethodsByName(this.getName(), false)) {
            if (!MethodSignatureUtil.areParametersErasureEqual((PsiMethod)this, (PsiMethod)sourceMethod)) continue;
            return sourceMethod;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        for (ClsCustomNavigationPolicy customNavigationPolicy : (ClsCustomNavigationPolicy[])Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            try {
                PsiElement navigationElement = customNavigationPolicy.getNavigationElement(this);
                if (navigationElement == null) continue;
                return navigationElement;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        try {
            PsiMethod method2 = this.getSourceMirrorMethod();
            return method2 != null ? method2.getNavigationElement() : this;
        }
        catch (IndexNotReadyException e) {
            return this;
        }
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        return PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(methodIcon, (PsiModifierListOwner)this, false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo((PsiMethod)this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        return PsiImplUtil.getMemberUseScope((PsiMember)this);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public String toString() {
        return "PsiMethod:" + this.getName();
    }
}

