/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsParameterImpl
extends ClsRepositoryPsiElement<PsiParameterStub>
implements PsiParameter {
    private final NotNullLazyValue<PsiTypeElement> myType = new AtomicNotNullLazyValue<PsiTypeElement>(){

        @NotNull
        protected PsiTypeElement compute() {
            PsiParameterStub stub = (PsiParameterStub)ClsParameterImpl.this.getStub();
            String typeText = TypeInfo.createTypeText(stub.getType(false));
            assert (typeText != null) : stub;
            return new ClsTypeElementImpl((PsiElement)ClsParameterImpl.this, typeText, '\u0000');
        }
    };
    private volatile String myMirrorName;

    public ClsParameterImpl(@NotNull PsiParameterStub stub) {
        super(stub);
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public String getName() {
        return (String)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcName(), (Object[])new Object[]{this.getContainingFile(), this.getContainingFile().getNavigationElement(), FileIndexFacade.getInstance((Project)this.getProject()).getRootModificationTracker(), DumbService.getInstance((Project)this.getProject()).getModificationTracker()}));
    }

    @Nullable
    private String calcName() {
        PsiParameterStubImpl parameterStub = (PsiParameterStubImpl)this.getStub();
        if (!parameterStub.isAutoGeneratedName()) {
            return parameterStub.getName();
        }
        if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
            return null;
        }
        ClsMethodImpl method2 = (ClsMethodImpl)this.getDeclarationScope();
        PsiMethod sourceMethod = method2.getSourceMirrorMethod();
        if (sourceMethod != null) {
            assert (sourceMethod != method2) : method2;
            return sourceMethod.getParameterList().getParameters()[this.getIndex()].getName();
        }
        return this.getMirrorName();
    }

    public boolean isAutoGeneratedName() {
        return ((PsiParameterStubImpl)this.getStub()).isAutoGeneratedName() && !DumbService.getInstance((Project)this.getProject()).isDumb() && ((ClsMethodImpl)this.getDeclarationScope()).getSourceMirrorMethod() == null;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        throw ClsParameterImpl.cannotModifyException(this);
    }

    @NotNull
    public PsiTypeElement getTypeElement() {
        return (PsiTypeElement)this.myType.getValue();
    }

    @NotNull
    public PsiType getType() {
        return this.getTypeElement().getType();
    }

    @NotNull
    public PsiModifierList getModifierList() {
        StubElement child = ((PsiParameterStub)this.getStub()).findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        assert (child != null);
        return (PsiModifierList)child.getPsi();
    }

    public boolean hasModifierProperty(@NotNull String name) {
        return this.getModifierList().hasModifierProperty(name);
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public Object computeConstantValue() {
        return null;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        PsiAnnotation[] annotations2;
        for (PsiAnnotation annotation : annotations2 = this.getModifierList().getAnnotations()) {
            ClsParameterImpl.appendText((PsiElement)annotation, indentLevel, buffer);
            buffer.append(' ');
        }
        ClsParameterImpl.appendText((PsiElement)this.getTypeElement(), indentLevel, buffer, " ");
        buffer.append(this.getMirrorName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMirrorName() {
        String mirrorName = this.myMirrorName;
        if (mirrorName == null) {
            PsiElement psiElement = this.getParent();
            synchronized (psiElement) {
                mirrorName = this.myMirrorName;
                if (mirrorName == null) {
                    this.myMirrorName = mirrorName = this.calcNiceParameterName();
                }
            }
        }
        return mirrorName;
    }

    private String calcNiceParameterName() {
        String name = null;
        PsiParameterStubImpl stub = (PsiParameterStubImpl)this.getStub();
        if (!stub.isAutoGeneratedName() || DumbService.getInstance((Project)this.getProject()).isDumb()) {
            name = stub.getName();
        }
        if (name == null) {
            name = "p";
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.getProject());
            String[] nameSuggestions = codeStyleManager.suggestCompiledParameterName((PsiType)this.getType()).names;
            if (nameSuggestions.length > 0 && nameSuggestions[0] != null) {
                name = nameSuggestions[0];
            }
            String base = name;
            int n = 0;
            block0: while (true) {
                PsiParameter[] psiParameterArray = ((PsiParameterList)this.getParent()).getParameters();
                int n2 = psiParameterArray.length;
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) continue block0;
                    PsiParameter parameter = psiParameterArray[n3];
                    if (parameter == this) break block0;
                    String prevName = ((ClsParameterImpl)parameter).getMirrorName();
                    if (name.equals(prevName)) {
                        name = base + ++n;
                        continue block0;
                    }
                    ++n3;
                }
                break;
            }
        }
        return name;
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, null);
        PsiParameter mirror = (PsiParameter)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsParameterImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsParameterImpl.setMirror(this.getTypeElement(), mirror.getTypeElement());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParameter((PsiParameter)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        return this.getParent().getParent();
    }

    private int getIndex() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        return stub.getParentStub().getChildrenStubs().indexOf(stub);
    }

    public boolean isVarArgs() {
        PsiParameterList paramList = (PsiParameterList)this.getParent();
        PsiMethod method2 = (PsiMethod)paramList.getParent();
        return method2.isVarArgs() && this.getIndex() == paramList.getParametersCount() - 1;
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ClsParameterImpl.createLayeredIcon((Iconable)this, (Icon)PlatformIcons.PARAMETER_ICON, (int)0);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        return new LocalSearchScope(this.getDeclarationScope());
    }

    public String toString() {
        return "PsiParameter";
    }
}

