/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaTokenImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class ClsPrefixExpressionImpl
extends ClsElementImpl
implements PsiPrefixExpression {
    private final ClsElementImpl myParent;
    private final PsiJavaToken myOperator;
    private final PsiExpression myOperand;

    ClsPrefixExpressionImpl(ClsElementImpl parent, PsiJavaToken sign, PsiExpression operand2) {
        this.myParent = parent;
        this.myOperator = new ClsJavaTokenImpl(this, sign.getTokenType(), sign.getText());
        this.myOperand = ClsParsingUtil.psiToClsExpression(operand2, this);
    }

    @NotNull
    public PsiExpression getOperand() {
        return this.myOperand;
    }

    @NotNull
    public PsiJavaToken getOperationSign() {
        return this.myOperator;
    }

    @NotNull
    public IElementType getOperationTokenType() {
        return this.myOperator.getTokenType();
    }

    public PsiType getType() {
        return this.myOperand.getType();
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    @NotNull
    public PsiElement[] getChildren() {
        return new PsiElement[]{this.myOperator, this.myOperand};
    }

    @Override
    public String getText() {
        return StringUtil.join((String[])new String[]{this.myOperator.getText(), this.myOperand.getText()});
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        buffer.append(this.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, JavaElementType.PREFIX_EXPRESSION);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPrefixExpression((PsiPrefixExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiPrefixExpression:" + this.getText();
    }
}

