/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsReferenceExpressionImpl
extends ClsElementImpl
implements PsiReferenceExpression {
    private final ClsElementImpl myParent;
    private final PsiReferenceExpression myPatternExpression;
    private final PsiReferenceExpression myQualifier;
    private final String myName;
    private final PsiIdentifier myNameElement;

    public ClsReferenceExpressionImpl(ClsElementImpl parent, PsiReferenceExpression patternExpression) {
        this.myParent = parent;
        this.myPatternExpression = patternExpression;
        PsiReferenceExpression patternQualifier = (PsiReferenceExpression)this.myPatternExpression.getQualifierExpression();
        this.myQualifier = patternQualifier != null ? new ClsReferenceExpressionImpl(this, patternQualifier) : null;
        this.myName = this.myPatternExpression.getReferenceName();
        this.myNameElement = new ClsIdentifierImpl((PsiElement)this, this.myName);
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public PsiExpression getQualifierExpression() {
        return this.myQualifier;
    }

    public PsiElement bindToElementViaStaticImport(@NotNull PsiClass aClass) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        throw new IncorrectOperationException("This method should not be called for compiled elements");
    }

    public PsiElement getReferenceNameElement() {
        return this.myNameElement;
    }

    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @NotNull
    public PsiElement[] getChildren() {
        if (this.myQualifier != null) {
            return new PsiElement[]{this.myQualifier, this.myNameElement};
        }
        return new PsiElement[]{this.myNameElement};
    }

    @Override
    public String getText() {
        return this.myQualifier != null ? this.myQualifier.getText() + "." + this.myName : this.myName;
    }

    public boolean isQualified() {
        return this.myQualifier != null;
    }

    public PsiType getType() {
        return this.myPatternExpression.getType();
    }

    public PsiElement resolve() {
        return this.myPatternExpression.resolve();
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        return this.myPatternExpression.advancedResolve(incompleteCode);
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        JavaResolveResult result2 = this.advancedResolve(incompleteCode);
        if (result2 != JavaResolveResult.EMPTY) {
            JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
            javaResolveResultArray = javaResolveResultArray2;
            javaResolveResultArray2[0] = result2;
        } else {
            javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
        }
        return javaResolveResultArray;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        return this.myPatternExpression.getCanonicalText();
    }

    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    public String getReferenceName() {
        return this.myPatternExpression.getReferenceName();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myPatternExpression.isReferenceTo(element);
    }

    @NotNull
    public Object[] getVariants() {
        return this.myPatternExpression.getVariants();
    }

    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        this.myPatternExpression.processVariants(processor2);
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        buffer.append(this.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, JavaElementType.REFERENCE_EXPRESSION);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceExpression((PsiReferenceExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        return PsiType.EMPTY_ARRAY;
    }

    public PsiElement getQualifier() {
        return this.getQualifierExpression();
    }

    public String toString() {
        return "PsiReferenceExpression:" + this.getText();
    }
}

