/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

public class ClsTypeElementImpl
extends ClsElementImpl
implements PsiTypeElement {
    static final char VARIANCE_NONE = '\u0000';
    static final char VARIANCE_EXTENDS = '+';
    static final char VARIANCE_SUPER = '-';
    static final char VARIANCE_INVARIANT = '*';
    private final PsiElement myParent;
    private final String myTypeText;
    private final char myVariance;
    private final NullableLazyValue<ClsElementImpl> myChild;
    private final NotNullLazyValue<PsiType> myCachedType;

    public ClsTypeElementImpl(@NotNull PsiElement parent, @NotNull String typeText, char variance) {
        this.myParent = parent;
        this.myTypeText = TypeInfo.internFrequentType(typeText);
        this.myVariance = variance;
        this.myChild = new AtomicNullableLazyValue<ClsElementImpl>(){

            protected ClsElementImpl compute() {
                return ClsTypeElementImpl.this.calculateChild();
            }
        };
        this.myCachedType = new AtomicNotNullLazyValue<PsiType>(){

            @NotNull
            protected PsiType compute() {
                return ClsTypeElementImpl.this.calculateType();
            }
        };
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        ClsElementImpl child = (ClsElementImpl)((Object)this.myChild.getValue());
        if (child != null) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = child;
        } else {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        }
        return psiElementArray;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        String shortClassName = PsiNameHelper.getShortClassName((String)this.myTypeText);
        return this.decorateTypeText(shortClassName);
    }

    private String decorateTypeText(String shortClassName) {
        switch (this.myVariance) {
            case '\u0000': {
                return shortClassName;
            }
            case '+': {
                return "? extends " + shortClassName;
            }
            case '-': {
                return "? super " + shortClassName;
            }
            case '*': {
                return "?";
            }
        }
        assert (false) : this.myVariance;
        return null;
    }

    public String getCanonicalText() {
        return this.decorateTypeText(this.myTypeText);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        buffer.append(this.decorateTypeText(this.myTypeText));
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, JavaElementType.TYPE);
        ClsElementImpl child = (ClsElementImpl)((Object)this.myChild.getValue());
        if (child != null) {
            child.setMirror(element.getFirstChildNode());
        }
    }

    private boolean isArray() {
        return this.myTypeText.endsWith("[]");
    }

    private boolean isVarArgs() {
        return this.myTypeText.endsWith("...");
    }

    @NotNull
    public PsiType getType() {
        return (PsiType)this.myCachedType.getValue();
    }

    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        return null;
    }

    private ClsElementImpl calculateChild() {
        if (PsiJavaParserFacadeImpl.getPrimitiveType(this.myTypeText) != null) {
            return null;
        }
        if (this.isArray()) {
            return this.myVariance == '\u0000' ? new ClsTypeElementImpl((PsiElement)this, this.myTypeText.substring(0, this.myTypeText.length() - 2), this.myVariance) : new ClsTypeElementImpl((PsiElement)this, this.myTypeText, '\u0000');
        }
        if (this.isVarArgs()) {
            return new ClsTypeElementImpl((PsiElement)this, this.myTypeText.substring(0, this.myTypeText.length() - 3), this.myVariance);
        }
        return this.myVariance == '*' ? null : new ClsJavaCodeReferenceElementImpl((PsiElement)this, this.myTypeText);
    }

    @NotNull
    private PsiType calculateType() {
        PsiModifierList modifierList = this.myParent instanceof PsiModifierListOwner ? ((PsiModifierListOwner)this.myParent).getModifierList() : null;
        return JavaSharedImplUtil.applyAnnotations(this.calculateBaseType(), modifierList);
    }

    @NotNull
    private PsiType calculateBaseType() {
        PsiPrimitiveType result2 = PsiJavaParserFacadeImpl.getPrimitiveType(this.myTypeText);
        if (result2 != null) {
            return result2;
        }
        ClsElementImpl childElement = (ClsElementImpl)((Object)this.myChild.getValue());
        if (childElement instanceof ClsTypeElementImpl) {
            if (this.isArray()) {
                switch (this.myVariance) {
                    case '\u0000': {
                        return ((PsiTypeElement)childElement).getType().createArrayType();
                    }
                    case '+': {
                        return PsiWildcardType.createExtends((PsiManager)this.getManager(), (PsiType)((PsiTypeElement)childElement).getType());
                    }
                    case '-': {
                        return PsiWildcardType.createSuper((PsiManager)this.getManager(), (PsiType)((PsiTypeElement)childElement).getType());
                    }
                }
                assert (false) : this.myVariance;
                return null;
            }
            assert (this.isVarArgs()) : this;
            return new PsiEllipsisType(((PsiTypeElement)childElement).getType());
        }
        if (childElement instanceof ClsJavaCodeReferenceElementImpl) {
            PsiClassReferenceType psiClassReferenceType = new PsiClassReferenceType((PsiJavaCodeReferenceElement)childElement, null);
            switch (this.myVariance) {
                case '\u0000': {
                    return psiClassReferenceType;
                }
                case '+': {
                    return PsiWildcardType.createExtends((PsiManager)this.getManager(), (PsiType)psiClassReferenceType);
                }
                case '-': {
                    return PsiWildcardType.createSuper((PsiManager)this.getManager(), (PsiType)psiClassReferenceType);
                }
                case '*': {
                    return PsiWildcardType.createUnbounded((PsiManager)this.getManager());
                }
            }
            assert (false) : this.myVariance;
            return null;
        }
        assert (childElement == null) : this;
        return PsiWildcardType.createUnbounded((PsiManager)this.getManager());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement((PsiTypeElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        throw new UnsupportedOperationException();
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        return PsiImplUtil.findAnnotation((PsiAnnotationOwner)this, qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull String qualifiedName) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        return this.getAnnotations();
    }

    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }
}

