/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiDirectoryImpl
extends PsiElementBase
implements PsiDirectory,
Queryable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.PsiDirectoryImpl");
    private final PsiManagerImpl myManager;
    private final VirtualFile myFile;

    public PsiDirectoryImpl(PsiManagerImpl manager, @NotNull VirtualFile file2) {
        this.myManager = manager;
        this.myFile = file2;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myFile;
    }

    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && !this.getProject().isDisposed();
    }

    @NotNull
    public Language getLanguage() {
        return Language.ANY;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myFile.getName();
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        this.checkSetName(name);
        try {
            this.myFile.rename((Object)this.myManager, name);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        return this;
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        VirtualFile parentFile = this.myFile.getParent();
        if (parentFile == null) {
            throw new IncorrectOperationException(VfsBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{this.myFile.getPath()}));
        }
        VirtualFile child = parentFile.findChild(name);
        if (child != null && !child.equals(this.myFile)) {
            throw new IncorrectOperationException(VfsBundle.message((String)"file.already.exists.error", (Object[])new Object[]{child.getPresentableUrl()}));
        }
    }

    public PsiDirectory getParentDirectory() {
        VirtualFile parentFile = this.myFile.getParent();
        if (parentFile == null) {
            return null;
        }
        if (!parentFile.isValid()) {
            LOG.error("Invalid parent: " + parentFile + " of dir " + this.myFile + ", dir.valid=" + this.myFile.isValid());
            return null;
        }
        return this.myManager.findDirectory(parentFile);
    }

    @NotNull
    public PsiDirectory[] getSubdirectories() {
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile file2 : files) {
            PsiDirectory dir = this.myManager.findDirectory(file2);
            if (dir == null) continue;
            dirs.add(dir);
        }
        return dirs.toArray(new PsiDirectory[dirs.size()]);
    }

    @NotNull
    public PsiFile[] getFiles() {
        if (!this.myFile.isValid()) {
            throw new InvalidVirtualFileAccessException(this.myFile);
        }
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList<PsiFile> psiFiles2 = new ArrayList<PsiFile>();
        for (VirtualFile file2 : files) {
            PsiFile psiFile = this.myManager.findFile(file2);
            if (psiFile == null) continue;
            psiFiles2.add(psiFile);
        }
        return PsiUtilCore.toPsiFileArray(psiFiles2);
    }

    public PsiDirectory findSubdirectory(@NotNull String name) {
        ProgressManager.checkCanceled();
        VirtualFile childVFile = this.myFile.findChild(name);
        if (childVFile == null) {
            return null;
        }
        return this.myManager.findDirectory(childVFile);
    }

    public PsiFile findFile(@NotNull String name) {
        ProgressManager.checkCanceled();
        VirtualFile childVFile = this.myFile.findChild(name);
        if (childVFile == null) {
            return null;
        }
        if (!childVFile.isValid()) {
            LOG.error("Invalid file: " + childVFile + " in dir " + this.myFile + ", dir.valid=" + this.myFile.isValid());
            return null;
        }
        return this.myManager.findFile(childVFile);
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor2) {
        this.checkValid();
        ProgressIndicatorProvider.checkCanceled();
        for (VirtualFile vFile : this.myFile.getChildren()) {
            PsiDirectory item;
            boolean isDir = vFile.isDirectory();
            if (processor2 instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor2).acceptItem(vFile.getName(), isDir)) continue;
            Object object = item = isDir ? this.myManager.findDirectory(vFile) : this.myManager.findFile(vFile);
            if (item == null || processor2.execute((PsiElement)item)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiElement[] getChildren() {
        this.checkValid();
        VirtualFile[] files = this.myFile.getChildren();
        final ArrayList children2 = new ArrayList(files.length);
        this.processChildren(new PsiElementProcessor<PsiFileSystemItem>(){

            public boolean execute(@NotNull PsiFileSystemItem element) {
                children2.add(element);
                return true;
            }
        });
        return PsiUtilCore.toPsiElementArray(children2);
    }

    private void checkValid() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
    }

    public PsiDirectory getParent() {
        return this.getParentDirectory();
    }

    @Override
    public PsiFile getContainingFile() {
        return null;
    }

    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return -1;
    }

    public int getTextLength() {
        return -1;
    }

    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return -1;
    }

    public String getText() {
        return "";
    }

    @NotNull
    public char[] textToCharArray() {
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        return false;
    }

    @Override
    public final boolean isWritable() {
        return this.myFile.isWritable();
    }

    @Override
    public boolean isPhysical() {
        return !(this.myFile.getFileSystem() instanceof NonPhysicalFileSystem) && !this.myFile.getFileSystem().getProtocol().equals("temp");
    }

    @Override
    public PsiElement copy() {
        throw new IncorrectOperationException();
    }

    @NotNull
    public PsiDirectory createSubdirectory(@NotNull String name) throws IncorrectOperationException {
        this.checkCreateSubdirectory(name);
        try {
            VirtualFile file2 = this.getVirtualFile().createChildDirectory((Object)this.myManager, name);
            PsiDirectory directory = this.myManager.findDirectory(file2);
            if (directory == null) {
                throw new IncorrectOperationException("Cannot find directory in '" + file2.getPresentableUrl() + "'");
            }
            return directory;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
    }

    public void checkCreateSubdirectory(@NotNull String name) throws IncorrectOperationException {
        VirtualFile existingFile = this.getVirtualFile().findChild(name);
        if (existingFile != null) {
            throw new IncorrectOperationException(VfsBundle.message((String)"file.already.exists.error", (Object[])new Object[]{existingFile.getPresentableUrl()}));
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @NotNull
    public PsiFile createFile(@NotNull String name) throws IncorrectOperationException {
        this.checkCreateFile(name);
        try {
            VirtualFile vFile = this.getVirtualFile().createChildData((Object)this.myManager, name);
            PsiFile psiFile = this.myManager.findFile(vFile);
            assert (psiFile != null) : vFile.getPath();
            return psiFile;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
    }

    @NotNull
    public PsiFile copyFileFrom(@NotNull String newName, @NotNull PsiFile originalFile) throws IncorrectOperationException {
        this.checkCreateFile(newName);
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(originalFile);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
        VirtualFile parent = this.getVirtualFile();
        try {
            VirtualFile copyVFile;
            VirtualFile vFile = originalFile.getVirtualFile();
            if (vFile == null) {
                throw new IncorrectOperationException("Cannot copy non-physical file: " + originalFile);
            }
            if (parent.getFileSystem() == vFile.getFileSystem()) {
                copyVFile = vFile.copy((Object)this, parent, newName);
            } else if (vFile instanceof LightVirtualFile) {
                copyVFile = parent.createChildData((Object)this, newName);
                copyVFile.setBinaryContent(originalFile.getText().getBytes(copyVFile.getCharset()));
            } else {
                copyVFile = VfsUtilCore.copyFile((Object)((Object)this), (VirtualFile)vFile, (VirtualFile)parent, (String)newName);
            }
            if (copyVFile == null) {
                throw new IncorrectOperationException("File was not copied: " + vFile);
            }
            DumbService.getInstance((Project)this.getProject()).completeJustSubmittedTasks();
            PsiFile copyPsi = this.myManager.findFile(copyVFile);
            if (copyPsi == null) {
                throw new IncorrectOperationException("Could not find file " + copyVFile + " after copying " + vFile);
            }
            PsiDirectoryImpl.updateAddedFile(copyPsi);
            return copyPsi;
        }
        catch (IOException e) {
            throw new IncorrectOperationException((Throwable)e);
        }
    }

    private static void updateAddedFile(@NotNull PsiFile copyPsi) throws IncorrectOperationException {
        UpdateAddedFileProcessor processor2 = UpdateAddedFileProcessor.forElement(copyPsi);
        if (processor2 != null) {
            TreeElement tree = (TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)copyPsi);
            if (tree != null) {
                ChangeUtil.encodeInformation(tree);
            }
            processor2.update(copyPsi, null);
            if (tree != null) {
                ChangeUtil.decodeInformation(tree);
            }
        }
    }

    public void checkCreateFile(@NotNull String name) throws IncorrectOperationException {
        VirtualFile existingFile = this.getVirtualFile().findChild(name);
        if (existingFile != null) {
            throw new IncorrectOperationException(VfsBundle.message((String)"file.already.exists.error", (Object[])new Object[]{existingFile.getPresentableUrl()}));
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        this.checkAdd(element);
        if (element instanceof PsiFile) {
            PsiFile originalFile = (PsiFile)element;
            try {
                VirtualFile newVFile;
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myManager.getProject());
                if (originalFile instanceof PsiFileImpl) {
                    newVFile = this.myFile.createChildData((Object)this.myManager, originalFile.getName());
                    String text = originalFile.getText();
                    PsiFile psiFile = this.getManager().findFile(newVFile);
                    Document document = psiFile == null ? null : psiDocumentManager.getDocument(psiFile);
                    FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                    if (document != null) {
                        document.setText((CharSequence)text);
                        fileDocumentManager.saveDocument(document);
                    } else {
                        String lineSeparator = fileDocumentManager.getLineSeparator(newVFile, this.getProject());
                        if (!lineSeparator.equals("\n")) {
                            text = StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
                        }
                        LoadTextUtil.write(this.getProject(), newVFile, (Object)this.myManager, text, -1L);
                    }
                } else {
                    byte[] storedContents = ((PsiBinaryFileImpl)originalFile).getStoredContents();
                    if (storedContents != null) {
                        newVFile = this.myFile.createChildData((Object)this.myManager, originalFile.getName());
                        newVFile.setBinaryContent(storedContents);
                    } else {
                        newVFile = VfsUtilCore.copyFile(null, (VirtualFile)originalFile.getVirtualFile(), (VirtualFile)this.myFile);
                    }
                }
                psiDocumentManager.commitAllDocuments();
                PsiFile newFile = this.myManager.findFile(newVFile);
                if (newFile == null) {
                    throw new IncorrectOperationException("Could not find file " + newVFile);
                }
                PsiDirectoryImpl.updateAddedFile(newFile);
                return newFile;
            }
            catch (IOException e) {
                throw new IncorrectOperationException((Throwable)e);
            }
        }
        throw new IncorrectOperationException(element + " (" + element.getClass() + ")");
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        if (element instanceof PsiDirectory) {
            String name = ((PsiDirectory)element).getName();
            this.checkName(name, (PsiFileSystemItem[])this.getSubdirectories(), "dir.already.exists.error");
        } else if (element instanceof PsiFile) {
            String name = ((PsiFile)element).getName();
            this.checkName(name, (PsiFileSystemItem[])this.getFiles(), "file.already.exists.error");
        } else {
            throw new IncorrectOperationException(element.getClass().getName());
        }
    }

    private void checkName(String name, PsiFileSystemItem[] items, String key2) {
        boolean caseSensitive = this.getVirtualFile().getFileSystem().isCaseSensitive();
        for (PsiFileSystemItem item : items) {
            if (!Comparing.strEqual((String)item.getName(), (String)name, (boolean)caseSensitive)) continue;
            throw new IncorrectOperationException(VfsBundle.message((String)key2, (Object[])new Object[]{item.getVirtualFile().getPresentableUrl()}));
        }
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        try {
            this.myFile.delete((Object)this.myManager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException((Throwable)e);
        }
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkDelete(this.myFile);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        visitor.visitDirectory((PsiDirectory)this);
    }

    public String toString() {
        return "PsiDirectory:" + this.myFile.getPresentableUrl();
    }

    public ASTNode getNode() {
        return null;
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().navigateToDirectory((PsiDirectory)this, requestFocus);
    }

    protected Icon getElementIcon(int flags) {
        return PlatformIcons.DIRECTORY_CLOSED_ICON;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        info.put("fileName", this.getName());
    }
}

