/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileResolveScopeProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ResolveScopeManagerImpl
extends ResolveScopeManager {
    private final Project myProject;
    private final ProjectRootManager myProjectRootManager;
    private final PsiManager myManager;
    private final Map<VirtualFile, GlobalSearchScope> myDefaultResolveScopesCache = new FactoryMap<VirtualFile, GlobalSearchScope>(){

        protected Map<VirtualFile, GlobalSearchScope> createMap() {
            return ContainerUtil.createConcurrentWeakKeySoftValueMap();
        }

        protected GlobalSearchScope create(@NotNull VirtualFile key2) {
            ResolveScopeProvider resolveScopeProvider;
            GlobalSearchScope scope = null;
            Object[] objectArray = (ResolveScopeProvider[])ResolveScopeProvider.EP_NAME.getExtensions();
            int n = objectArray.length;
            for (int j = 0; j < n && (scope = (resolveScopeProvider = objectArray[j]).getResolveScope(key2, ResolveScopeManagerImpl.this.myProject)) == null; ++j) {
            }
            if (scope == null) {
                scope = ResolveScopeManagerImpl.this.getInherentResolveScope(key2);
            }
            for (ResolveScopeEnlarger enlarger : (ResolveScopeEnlarger[])ResolveScopeEnlarger.EP_NAME.getExtensions()) {
                SearchScope extra = enlarger.getAdditionalResolveScope(key2, ResolveScopeManagerImpl.this.myProject);
                if (extra == null) continue;
                scope = scope.union(extra);
            }
            return scope;
        }
    };
    private final AdditionalIndexableFileSet myAdditionalIndexableFileSet;

    public ResolveScopeManagerImpl(Project project2, ProjectRootManager projectRootManager, PsiManager psiManager) {
        this.myProject = project2;
        this.myProjectRootManager = projectRootManager;
        this.myManager = psiManager;
        this.myAdditionalIndexableFileSet = new AdditionalIndexableFileSet(project2);
        ((PsiManagerImpl)psiManager).registerRunnableToRunOnChange(this.myDefaultResolveScopesCache::clear);
    }

    private GlobalSearchScope getResolveScopeFromProviders(@NotNull VirtualFile vFile) {
        return this.myDefaultResolveScopesCache.get(vFile);
    }

    private GlobalSearchScope getInherentResolveScope(VirtualFile vFile) {
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module2 = projectFileIndex.getModuleForFile(vFile);
        if (module2 != null) {
            boolean includeTests = TestSourcesFilter.isTestSources((VirtualFile)vFile, (Project)this.myProject);
            return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2, (boolean)includeTests);
        }
        if (!projectFileIndex.isInLibrarySource(vFile) && !projectFileIndex.isInLibraryClasses(vFile)) {
            GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (!allScope.contains(vFile)) {
                return GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)vFile).uniteWith(allScope);
            }
            return allScope;
        }
        return LibraryScopeCache.getInstance(this.myProject).getLibraryScope(projectFileIndex.getOrderEntriesForFile(vFile));
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        PsiFile contextFile;
        VirtualFile vFile;
        ProgressIndicatorProvider.checkCanceled();
        if (element instanceof PsiDirectory) {
            vFile = ((PsiDirectory)element).getVirtualFile();
            contextFile = null;
        } else {
            PsiElement context;
            GlobalSearchScope forcedScope;
            PsiFile containingFile = element.getContainingFile();
            if (containingFile instanceof PsiCodeFragment && (forcedScope = ((PsiCodeFragment)containingFile).getForcedResolveScope()) != null) {
                return forcedScope;
            }
            if (containingFile != null && (context = containingFile.getContext()) != null) {
                return this.getResolveScope(context);
            }
            contextFile = containingFile;
            if (containingFile == null) {
                return GlobalSearchScope.allScope((Project)this.myProject);
            }
            if (contextFile instanceof FileResolveScopeProvider) {
                return ((FileResolveScopeProvider)contextFile).getFileResolveScope();
            }
            vFile = contextFile.getOriginalFile().getVirtualFile();
        }
        if (vFile == null || contextFile == null) {
            return GlobalSearchScope.allScope((Project)this.myProject);
        }
        return this.getResolveScopeFromProviders(vFile);
    }

    @Override
    public GlobalSearchScope getDefaultResolveScope(VirtualFile vFile) {
        PsiFile psiFile = this.myManager.findFile(vFile);
        assert (psiFile != null) : "directory=" + vFile.isDirectory() + "; " + this.myProject;
        return this.getResolveScopeFromProviders(vFile);
    }

    @Override
    @NotNull
    public GlobalSearchScope getUseScope(@NotNull PsiElement element) {
        RefResolveService resolveService;
        GlobalSearchScope scope;
        PsiFile containingFile;
        VirtualFile virtualFile;
        VirtualFile vDirectory;
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myManager.getProject());
        if (element instanceof PsiDirectory) {
            vDirectory = ((PsiDirectory)element).getVirtualFile();
            virtualFile = null;
            containingFile = null;
        } else {
            containingFile = element.getContainingFile();
            if (containingFile == null) {
                return allScope;
            }
            virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                return allScope;
            }
            if (virtualFile instanceof VirtualFileWindow) {
                return GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)((VirtualFileWindow)virtualFile).getDelegate());
            }
            vDirectory = virtualFile.getParent();
        }
        if (vDirectory == null) {
            return allScope;
        }
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module2 = projectFileIndex.getModuleForFile(vDirectory);
        if (module2 == null) {
            VirtualFile notNullVFile = virtualFile != null ? virtualFile : vDirectory;
            List entries = projectFileIndex.getOrderEntriesForFile(notNullVFile);
            if (entries.isEmpty() && (this.myAdditionalIndexableFileSet.isInSet(notNullVFile) || this.isFromAdditionalLibraries(notNullVFile))) {
                return allScope;
            }
            GlobalSearchScope result2 = LibraryScopeCache.getInstance(this.myProject).getLibraryUseScope(entries);
            return containingFile == null || virtualFile.isDirectory() || result2.contains(virtualFile) ? result2 : GlobalSearchScope.fileScope((PsiFile)containingFile).uniteWith(result2);
        }
        boolean isTest = TestSourcesFilter.isTestSources((VirtualFile)vDirectory, (Project)this.myProject);
        GlobalSearchScope globalSearchScope = scope = isTest ? GlobalSearchScope.moduleTestsWithDependentsScope((Module)module2) : GlobalSearchScope.moduleWithDependentsScope((Module)module2);
        if (virtualFile instanceof VirtualFileWithId && RefResolveService.ENABLED && (resolveService = RefResolveService.getInstance((Project)this.myProject)).isUpToDate()) {
            return resolveService.restrictByBackwardIds(virtualFile, scope);
        }
        return scope;
    }

    private boolean isFromAdditionalLibraries(@NotNull VirtualFile file2) {
        for (AdditionalLibraryRootsProvider provider2 : (AdditionalLibraryRootsProvider[])Extensions.getExtensions(AdditionalLibraryRootsProvider.EP_NAME)) {
            for (SyntheticLibrary library : provider2.getAdditionalProjectLibraries(this.myProject)) {
                if (!VfsUtilCore.isUnder((VirtualFile)file2, ResolveScopeManagerImpl.asSet(library.getSourceRoots()))) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Set<VirtualFile> asSet(Collection<VirtualFile> collection) {
        return collection instanceof Set ? (Set)collection : ContainerUtil.newTroveSet(collection);
    }
}

