/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.search.ApproximateResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceChainLink {
    final String referenceName;
    final boolean isCall;
    final int argCount;
    private static final Key<Set<ReferenceChainLink>> EXPENSIVE_LINKS = Key.create((String)"EXPENSIVE_CHAIN_LINKS");

    public ReferenceChainLink(@NotNull String referenceName, boolean isCall, int argCount) {
        this.referenceName = referenceName;
        this.isCall = isCall;
        this.argCount = argCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferenceChainLink)) {
            return false;
        }
        ReferenceChainLink link = (ReferenceChainLink)o;
        if (this.isCall != link.isCall) {
            return false;
        }
        if (this.argCount != link.argCount) {
            return false;
        }
        return this.referenceName.equals(link.referenceName);
    }

    public int hashCode() {
        int result2 = this.referenceName.hashCode();
        result2 = 31 * result2 + (this.isCall ? 1 : 0);
        result2 = 31 * result2 + this.argCount;
        return result2;
    }

    public String toString() {
        return this.referenceName + (this.isCall ? "(" + this.argCount + ")" : "");
    }

    @Nullable
    List<PsiMember> getGlobalMembers(VirtualFile placeFile, Project project2) {
        if (this.isExpensive(project2)) {
            return null;
        }
        ArrayList candidates = new ArrayList();
        AtomicInteger count = new AtomicInteger();
        Processor processor2 = member -> {
            if (!(member instanceof PsiMethod) || ApproximateResolver.canHaveArgCount((PsiMethod)member, this.argCount)) {
                candidates.add(member);
            }
            return count.incrementAndGet() < 42;
        };
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)project2);
        GlobalSearchScope scope = ResolveScopeManager.getInstance(project2).getDefaultResolveScope(placeFile);
        if (this.isCall) {
            if (!cache2.processMethodsWithName(this.referenceName, processor2, scope, null)) {
                this.markExpensive(project2);
                return null;
            }
        } else {
            PsiPackage pkg = JavaPsiFacade.getInstance((Project)project2).findPackage(this.referenceName);
            if (pkg != null && pkg.getDirectories(scope).length > 0) {
                return null;
            }
            if (!cache2.processFieldsWithName(this.referenceName, processor2, scope, null)) {
                this.markExpensive(project2);
                return null;
            }
        }
        if (!cache2.processClassesWithName(this.referenceName, processor2, scope, null)) {
            this.markExpensive(project2);
            return null;
        }
        return candidates.stream().filter(candidate -> ReferenceChainLink.canBeAccessible(placeFile, candidate)).collect(Collectors.toList());
    }

    private static boolean canBeAccessible(VirtualFile placeFile, PsiMember member) {
        return !member.hasModifierProperty("private") || placeFile.equals(PsiUtilCore.getVirtualFile((PsiElement)member));
    }

    private boolean isExpensive(Project project2) {
        Set expensive = (Set)project2.getUserData(EXPENSIVE_LINKS);
        return expensive != null && expensive.contains(this);
    }

    private void markExpensive(Project project2) {
        Set expensive = (Set)project2.getUserData(EXPENSIVE_LINKS);
        if (expensive == null) {
            expensive = ContainerUtil.newConcurrentSet();
            project2.putUserData(EXPENSIVE_LINKS, (Object)expensive);
        }
        expensive.add(this);
    }

    public List<? extends PsiMember> getSymbolMembers(Set<PsiClass> qualifiers) {
        return this.isCall ? ApproximateResolver.getPossibleMethods(qualifiers, this.referenceName, this.argCount) : ApproximateResolver.getPossibleNonMethods(qualifiers, this.referenceName);
    }
}

