/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.cache.ModifierFlags;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMemberStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiAnnotationMethodImpl;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.AnnotationMethodElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaMethodElementType
extends JavaStubElementType<PsiMethodStub, PsiMethod> {
    public static final String TYPE_PARAMETER_PSEUDO_NAME = "$TYPE_PARAMETER$";

    public JavaMethodElementType(@NonNls String name) {
        super(name);
    }

    public PsiMethod createPsi(@NotNull PsiMethodStub stub) {
        return this.getPsiFactory(stub).createMethod(stub);
    }

    @Override
    public PsiMethod createPsi(@NotNull ASTNode node) {
        if (node instanceof AnnotationMethodElement) {
            return new PsiAnnotationMethodImpl(node);
        }
        return new PsiMethodImpl(node);
    }

    public PsiMethodStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String name = null;
        boolean isConstructor = true;
        boolean isVarArgs = false;
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String defValueText = null;
        boolean expectingDef = false;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type2 = child.getTokenType();
            if (type2 == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type2 == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type2 == JavaElementType.TYPE) {
                isConstructor = false;
                continue;
            }
            if (type2 == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (type2 == JavaElementType.PARAMETER_LIST) {
                LighterASTNode pType;
                List<LighterASTNode> params = LightTreeUtil.getChildrenOfType(tree, child, JavaElementType.PARAMETER);
                if (params.isEmpty() || (pType = LightTreeUtil.firstChildOfType(tree, params.get(params.size() - 1), JavaElementType.TYPE)) == null) continue;
                isVarArgs = LightTreeUtil.firstChildOfType(tree, pType, JavaTokenType.ELLIPSIS) != null;
                continue;
            }
            if (type2 == JavaTokenType.DEFAULT_KEYWORD) {
                expectingDef = true;
                continue;
            }
            if (!expectingDef || ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type2) || type2 == JavaTokenType.SEMICOLON || type2 == JavaElementType.CODE_BLOCK) continue;
            defValueText = LightTreeUtil.toFilteredString(tree, child, null);
            break;
        }
        TypeInfo typeInfo = isConstructor ? TypeInfo.createConstructorType() : TypeInfo.create(tree, node, parentStub);
        boolean isAnno = node.getTokenType() == JavaElementType.ANNOTATION_METHOD;
        byte flags = PsiMethodStubImpl.packFlags(isConstructor, isAnno, isVarArgs, isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        return new PsiMethodStubImpl(parentStub, name, typeInfo, flags, defValueText);
    }

    public void serialize(@NotNull PsiMethodStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getReturnTypeText(false));
        dataStream.writeByte((int)((PsiMethodStubImpl)stub).getFlags());
        if (stub.isAnnotationMethod()) {
            dataStream.writeName(stub.getDefaultValueText());
        }
    }

    @NotNull
    public PsiMethodStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        TypeInfo type2 = TypeInfo.readTYPE(dataStream);
        byte flags = dataStream.readByte();
        StringRef defaultMethodValue = PsiMethodStubImpl.isAnnotationMethod(flags) ? dataStream.readName() : null;
        return new PsiMethodStubImpl(parentStub, StringRef.toString((StringRef)name), type2, flags, StringRef.toString((StringRef)defaultMethodValue));
    }

    public void indexStub(@NotNull PsiMethodStub stub, @NotNull IndexSink sink) {
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(JavaStubIndexKeys.METHODS, (Object)name);
            if (RecordUtil.isStaticNonPrivateMember(stub)) {
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, (Object)name);
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, (Object)stub.getReturnTypeText(false).getShortTypeText());
            }
        }
        Set<String> methodTypeParams = JavaMethodElementType.getVisibleTypeParameters(stub);
        for (StubElement stubElement : stub.getChildrenStubs()) {
            if (!(stubElement instanceof PsiParameterListStub)) continue;
            for (StubElement paramStub : ((PsiParameterListStub)stubElement).getChildrenStubs()) {
                if (!(paramStub instanceof PsiParameterStub)) continue;
                TypeInfo type2 = ((PsiParameterStub)paramStub).getType(false);
                String typeName = PsiNameHelper.getShortClassName((String)type2.text);
                if (TypeConversionUtil.isPrimitive((String)typeName) || TypeConversionUtil.isPrimitiveWrapper((String)typeName)) continue;
                sink.occurrence(JavaStubIndexKeys.METHOD_TYPES, (Object)typeName);
                if (!typeName.equals(type2.text) || type2.arrayCount != 0 && (type2.arrayCount != 1 || !type2.isEllipsis) || !methodTypeParams.contains(typeName)) continue;
                sink.occurrence(JavaStubIndexKeys.METHOD_TYPES, (Object)TYPE_PARAMETER_PSEUDO_NAME);
            }
        }
    }

    @NotNull
    private static Set<String> getVisibleTypeParameters(@NotNull StubElement<?> stub) {
        HashSet result2 = null;
        while (stub != null) {
            Set<String> names = JavaMethodElementType.getOwnTypeParameterNames(stub);
            if (!names.isEmpty()) {
                if (result2 == null) {
                    result2 = ContainerUtil.newHashSet();
                }
                result2.addAll(names);
            }
            if (JavaMethodElementType.isStatic(stub)) break;
            stub = stub.getParentStub();
        }
        return result2 == null ? Collections.emptySet() : result2;
    }

    private static boolean isStatic(@NotNull StubElement<?> stub) {
        StubElement modList;
        if (stub instanceof PsiMemberStub && (modList = stub.findChildStubByType((IStubElementType)JavaStubElementTypes.MODIFIER_LIST)) instanceof PsiModifierListStub) {
            return BitUtil.isSet((int)((PsiModifierListStub)modList).getModifiersMask(), (int)ModifierFlags.NAME_TO_MODIFIER_FLAG_MAP.get((Object)"static"));
        }
        return false;
    }

    private static Set<String> getOwnTypeParameterNames(StubElement<?> stubElement) {
        StubElement typeParamList = stubElement.findChildStubByType((IStubElementType)JavaStubElementTypes.TYPE_PARAMETER_LIST);
        if (typeParamList == null) {
            return Collections.emptySet();
        }
        HashSet<String> methodTypeParams = null;
        for (Object tStub : typeParamList.getChildrenStubs()) {
            if (!(tStub instanceof PsiTypeParameterStub)) continue;
            if (methodTypeParams == null) {
                methodTypeParams = new HashSet<String>();
            }
            methodTypeParams.add(((PsiTypeParameterStub)tStub).getName());
        }
        return methodTypeParams == null ? Collections.emptySet() : methodTypeParams;
    }
}

