/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.impl.PsiModifierListStubImpl;
import com.intellij.psi.impl.source.PsiModifierListImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ModifierListElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaModifierListElementType
extends JavaStubElementType<PsiModifierListStub, PsiModifierList> {
    public JavaModifierListElementType() {
        super("MODIFIER_LIST");
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new ModifierListElement();
    }

    public PsiModifierList createPsi(@NotNull PsiModifierListStub stub) {
        return this.getPsiFactory(stub).createModifierList(stub);
    }

    @Override
    public PsiModifierList createPsi(@NotNull ASTNode node) {
        return new PsiModifierListImpl(node);
    }

    public PsiModifierListStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        return new PsiModifierListStubImpl(parentStub, RecordUtil.packModifierList(tree, node));
    }

    public void serialize(@NotNull PsiModifierListStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeVarInt(stub.getModifiersMask());
    }

    public boolean shouldCreateStub(ASTNode node) {
        IElementType parentType = node.getTreeParent().getElementType();
        return JavaModifierListElementType.shouldCreateStub(parentType);
    }

    public boolean shouldCreateStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        LighterASTNode parent = tree.getParent(node);
        IElementType parentType = parent != null ? parent.getTokenType() : null;
        return JavaModifierListElementType.shouldCreateStub(parentType);
    }

    private static boolean shouldCreateStub(IElementType parentType) {
        return parentType != null && parentType != JavaElementType.LOCAL_VARIABLE && parentType != JavaElementType.RESOURCE_VARIABLE && parentType != JavaElementType.RESOURCE_LIST;
    }

    @NotNull
    public PsiModifierListStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        return new PsiModifierListStubImpl(parentStub, dataStream.readVarInt());
    }

    public void indexStub(@NotNull PsiModifierListStub stub, @NotNull IndexSink sink) {
    }
}

