/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaModuleStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiJavaModuleImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaModuleElementType
extends JavaStubElementType<PsiJavaModuleStub, PsiJavaModule> {
    public JavaModuleElementType() {
        super("MODULE");
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new CompositeElement((IElementType)this);
    }

    public PsiJavaModule createPsi(@NotNull PsiJavaModuleStub stub) {
        return this.getPsiFactory(stub).createModule(stub);
    }

    @Override
    public PsiJavaModule createPsi(@NotNull ASTNode node) {
        return new PsiJavaModuleImpl(node);
    }

    public PsiJavaModuleStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        LighterASTNode ref = LightTreeUtil.requiredChildOfType(tree, node, JavaElementType.MODULE_REFERENCE);
        return new PsiJavaModuleStubImpl(parentStub, JavaSourceUtil.getReferenceText(tree, ref));
    }

    public void serialize(@NotNull PsiJavaModuleStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
    }

    @NotNull
    public PsiJavaModuleStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        String name = StringRef.toString((StringRef)dataStream.readName());
        return new PsiJavaModuleStubImpl(parentStub, name);
    }

    public void indexStub(@NotNull PsiJavaModuleStub stub, @NotNull IndexSink sink) {
        sink.occurrence(JavaStubIndexKeys.MODULE_NAMES, (Object)stub.getName());
    }
}

