/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiNameValuePairStub;
import com.intellij.psi.impl.java.stubs.impl.PsiNameValuePairStubImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.NameValuePairElement;
import com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaNameValuePairType
extends JavaStubElementType<PsiNameValuePairStub, PsiNameValuePair> {
    protected JavaNameValuePairType() {
        super("NAME_VALUE_PAIR", true);
    }

    @Override
    public PsiNameValuePair createPsi(@NotNull ASTNode node) {
        return new PsiNameValuePairImpl(node);
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new NameValuePairElement();
    }

    public PsiNameValuePairStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String name = null;
        String value2 = null;
        List children2 = tree.getChildren(node);
        for (LighterASTNode child : children2) {
            if (child.getTokenType() == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (!ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(child.getTokenType())) continue;
            value2 = LightTreeUtil.toFilteredString(tree, child, null);
        }
        return new PsiNameValuePairStubImpl(parentStub, name, value2);
    }

    public PsiNameValuePair createPsi(@NotNull PsiNameValuePairStub stub) {
        return this.getPsiFactory(stub).createNameValuePair(stub);
    }

    public void serialize(@NotNull PsiNameValuePairStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        String value2 = stub.getValue();
        boolean hasValue = value2 != null;
        dataStream.writeBoolean(hasValue);
        if (hasValue) {
            dataStream.writeUTFFast(value2);
        }
    }

    @NotNull
    public PsiNameValuePairStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        String name = StringRef.toString((StringRef)dataStream.readName());
        boolean hasValue = dataStream.readBoolean();
        return new PsiNameValuePairStubImpl(parentStub, name, hasValue ? dataStream.readUTFFast() : null);
    }

    public void indexStub(@NotNull PsiNameValuePairStub stub, @NotNull IndexSink sink) {
    }
}

