/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiPackageAccessibilityStatementStub;
import com.intellij.psi.impl.java.stubs.impl.PsiPackageAccessibilityStatementStubImpl;
import com.intellij.psi.impl.source.PackageAccessibilityStatementElement;
import com.intellij.psi.impl.source.PsiPackageAccessibilityStatementImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaPackageAccessibilityStatementElementType
extends JavaStubElementType<PsiPackageAccessibilityStatementStub, PsiPackageAccessibilityStatement> {
    public JavaPackageAccessibilityStatementElementType(@NotNull String debugName) {
        super(debugName);
    }

    public PsiPackageAccessibilityStatement createPsi(@NotNull PsiPackageAccessibilityStatementStub stub) {
        return this.getPsiFactory(stub).createPackageAccessibilityStatement(stub);
    }

    @Override
    public PsiPackageAccessibilityStatement createPsi(@NotNull ASTNode node) {
        return new PsiPackageAccessibilityStatementImpl(node);
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new PackageAccessibilityStatementElement((IElementType)this);
    }

    public PsiPackageAccessibilityStatementStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String refText = null;
        List to = ContainerUtil.newSmartList();
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type2 = child.getTokenType();
            if (type2 == JavaElementType.JAVA_CODE_REFERENCE) {
                refText = JavaSourceUtil.getReferenceText(tree, child);
                continue;
            }
            if (type2 != JavaElementType.MODULE_REFERENCE) continue;
            to.add(JavaSourceUtil.getReferenceText(tree, child));
        }
        return new PsiPackageAccessibilityStatementStubImpl(parentStub, (IStubElementType)this, refText, to);
    }

    public void serialize(@NotNull PsiPackageAccessibilityStatementStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getPackageName());
        dataStream.writeUTFFast(StringUtil.join(stub.getTargets(), (String)"/"));
    }

    @NotNull
    public PsiPackageAccessibilityStatementStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        String packageName = StringRef.toString((StringRef)dataStream.readName());
        List targets = StringUtil.split((String)dataStream.readUTFFast(), (String)"/");
        return new PsiPackageAccessibilityStatementStubImpl(parentStub, (IStubElementType)this, packageName, targets);
    }

    public void indexStub(@NotNull PsiPackageAccessibilityStatementStub stub, @NotNull IndexSink sink) {
    }

    @NotNull
    public static PsiPackageAccessibilityStatement.Role typeToRole(@NotNull IElementType type2) {
        if (type2 == JavaElementType.EXPORTS_STATEMENT) {
            return PsiPackageAccessibilityStatement.Role.EXPORTS;
        }
        if (type2 == JavaElementType.OPENS_STATEMENT) {
            return PsiPackageAccessibilityStatement.Role.OPENS;
        }
        throw new IllegalArgumentException("Unknown type: " + type2);
    }
}

