/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class PsiClassReferenceListStubImpl
extends StubBase<PsiReferenceList>
implements PsiClassReferenceListStub {
    private final String[] myNames;
    private PsiClassType[] myTypes;

    public PsiClassReferenceListStubImpl(@NotNull JavaClassReferenceListElementType type2, StubElement parent, @NotNull String[] names) {
        super(parent, (IStubElementType)type2);
        ObjectUtils.assertAllElementsNotNull((Object[])names);
        this.myNames = names;
    }

    @Override
    @NotNull
    public PsiClassType[] getReferencedTypes() {
        if (this.myTypes != null) {
            return this.myTypes;
        }
        if (this.myNames.length == 0) {
            this.myTypes = PsiClassType.EMPTY_ARRAY;
            return this.myTypes;
        }
        PsiClassType[] types = new PsiClassType[this.myNames.length];
        boolean compiled = ((JavaClassReferenceListElementType)this.getStubType()).isCompiled(this);
        if (compiled) {
            for (int i = 0; i < types.length; ++i) {
                types[i] = new PsiClassReferenceType((PsiJavaCodeReferenceElement)new ClsJavaCodeReferenceElementImpl(this.getPsi(), this.myNames[i]), null);
            }
        } else {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            int nullCount = 0;
            PsiReferenceList psi = (PsiReferenceList)this.getPsi();
            for (int i = 0; i < types.length; ++i) {
                try {
                    PsiJavaCodeReferenceElement ref = factory.createReferenceFromText(this.myNames[i], (PsiElement)psi);
                    ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(1);
                    types[i] = factory.createType(ref);
                    continue;
                }
                catch (IncorrectOperationException e) {
                    types[i] = null;
                    ++nullCount;
                }
            }
            if (nullCount > 0) {
                PsiClassType[] newTypes = new PsiClassType[types.length - nullCount];
                int cnt = 0;
                for (PsiClassType type2 : types) {
                    if (type2 == null) continue;
                    newTypes[cnt++] = type2;
                }
                types = newTypes;
            }
        }
        this.myTypes = types;
        return (PsiClassType[])types.clone();
    }

    @Override
    @NotNull
    public String[] getReferencedNames() {
        return (String[])this.myNames.clone();
    }

    @Override
    @NotNull
    public PsiReferenceList.Role getRole() {
        return JavaClassReferenceListElementType.elementTypeToRole((IElementType)this.getStubType());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiRefListStub[").append(this.getRole()).append(':');
        for (int i = 0; i < this.myNames.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.myNames[i]);
        }
        builder.append(']');
        return builder.toString();
    }
}

