/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JavaAutoModuleNameIndex
extends ScalarIndexExtension<String> {
    private static final ID<String, Void> NAME = ID.create((String)"java.auto.module.name");
    private final FileBasedIndex.InputFilter myFilter = file2 -> file2.isDirectory() && file2.getParent() == null && "jar".equalsIgnoreCase(file2.getExtension());
    private final DataIndexer<String, Void, FileContent> myIndexer = data -> Collections.singletonMap(LightJavaModule.moduleName(data.getFile().getNameWithoutExtension()), null);

    @NotNull
    public ID<String, Void> getName() {
        return NAME;
    }

    public int getVersion() {
        return 1 + (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping ? 2 : 0);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myFilter;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return this.myIndexer;
    }

    @NotNull
    public static Collection<VirtualFile> getFilesByKey(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)moduleName, scope);
    }
}

