/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AllClassesSearchExecutor
implements QueryExecutor<PsiClass, AllClassesSearch.SearchParameters> {
    public boolean execute(@NotNull AllClassesSearch.SearchParameters queryParameters, @NotNull Processor<PsiClass> consumer2) {
        PsiElement[] scopeRoots;
        SearchScope scope = queryParameters.getScope();
        if (scope instanceof GlobalSearchScope) {
            return AllClassesSearchExecutor.processAllClassesInGlobalScope((GlobalSearchScope)scope, queryParameters, consumer2);
        }
        for (PsiElement scopeRoot : scopeRoots = ((LocalSearchScope)scope).getScope()) {
            if (AllClassesSearchExecutor.processScopeRootForAllClasses(scopeRoot, consumer2)) continue;
            return false;
        }
        return true;
    }

    private static boolean processAllClassesInGlobalScope(@NotNull GlobalSearchScope scope, @NotNull AllClassesSearch.SearchParameters parameters2, @NotNull Processor<PsiClass> processor2) {
        THashSet names = new THashSet(10000);
        AllClassesSearchExecutor.processClassNames(parameters2.getProject(), scope, (Consumer<String>)((Consumer)arg_0 -> AllClassesSearchExecutor.lambda$processAllClassesInGlobalScope$0(parameters2, (Set)names, arg_0)));
        ArrayList<String> sorted = new ArrayList<String>((Collection<String>)names);
        Collections.sort(sorted, String.CASE_INSENSITIVE_ORDER);
        return AllClassesSearchExecutor.processClassesByNames(parameters2.getProject(), scope, sorted, processor2);
    }

    public static boolean processClassesByNames(Project project2, GlobalSearchScope scope, Collection<String> names, Processor<PsiClass> processor2) {
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)project2);
        for (String name : names) {
            ProgressIndicatorProvider.checkCanceled();
            for (PsiClass psiClass : (PsiClass[])DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> cache2.getClassesByName(name, scope))) {
                ProgressIndicatorProvider.checkCanceled();
                if (processor2.process((Object)psiClass)) continue;
                return false;
            }
        }
        return true;
    }

    public static Project processClassNames(final Project project2, final GlobalSearchScope scope, final Consumer<String> consumer2) {
        final ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        DumbService.getInstance((Project)project2).runReadActionInSmartMode((Computable)new Computable<Void>(){

            public Void compute() {
                PsiShortNamesCache.getInstance((Project)project2).processAllClassNames((Processor)new Processor<String>(){
                    int i;

                    public boolean process(String s) {
                        if (indicator != null && this.i++ % 512 == 0) {
                            indicator.checkCanceled();
                        }
                        consumer2.consume((Object)s);
                        return true;
                    }
                }, scope, IdFilter.getProjectIdFilter((Project)project2, (boolean)true));
                return null;
            }
        });
        if (indicator != null) {
            indicator.checkCanceled();
        }
        return project2;
    }

    private static boolean processScopeRootForAllClasses(@NotNull PsiElement scopeRoot, final @NotNull Processor<PsiClass> processor2) {
        final boolean[] stopped = new boolean[]{false};
        Object visitor = scopeRoot instanceof PsiCompiledElement ? new JavaRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor2.process((Object)aClass);
                super.visitClass(aClass);
            }
        } : new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor2.process((Object)aClass);
                super.visitClass(aClass);
            }
        };
        ApplicationManager.getApplication().runReadAction(() -> AllClassesSearchExecutor.lambda$processScopeRootForAllClasses$2(scopeRoot, (JavaElementVisitor)visitor));
        return !stopped[0];
    }

    private static /* synthetic */ void lambda$processScopeRootForAllClasses$2(@NotNull PsiElement scopeRoot, JavaElementVisitor visitor) {
        scopeRoot.accept((PsiElementVisitor)visitor);
    }

    private static /* synthetic */ void lambda$processAllClassesInGlobalScope$0(@NotNull AllClassesSearch.SearchParameters parameters2, Set names, String s) {
        if (parameters2.nameMatches(s)) {
            names.add(s);
        }
    }
}

