/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AnnotatedElementsSearcher
implements QueryExecutor<PsiModifierListOwner, AnnotatedElementsSearch.Parameters> {
    public boolean execute(final @NotNull AnnotatedElementsSearch.Parameters p, @NotNull Processor<PsiModifierListOwner> consumer2) {
        final PsiClass annClass = p.getAnnotationClass();
        if (!annClass.isAnnotationType()) {
            throw new IllegalArgumentException("Annotation type should be passed to annotated members search but got: " + annClass);
        }
        String annotationFQN = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return annClass.getQualifiedName();
            }
        });
        if (annotationFQN == null) {
            throw new IllegalArgumentException("FQN is null for " + annClass);
        }
        final PsiManager psiManager = (PsiManager)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiManager>(){

            public PsiManager compute() {
                return annClass.getManager();
            }
        });
        SearchScope useScope = p.getScope();
        final Class[] types = p.getTypes();
        for (final PsiAnnotation ann : AnnotatedElementsSearcher.getAnnotationCandidates(annClass, useScope, psiManager.getProject())) {
            PsiModifierListOwner candidate = (PsiModifierListOwner)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiModifierListOwner>(){

                public PsiModifierListOwner compute() {
                    PsiElement parent = ann.getContext();
                    if (!(parent instanceof PsiModifierList)) {
                        return null;
                    }
                    PsiElement owner = parent.getParent();
                    if (!AnnotatedElementsSearcher.isInstanceof(owner, types)) {
                        return null;
                    }
                    if (p.isApproximate()) {
                        return (PsiModifierListOwner)owner;
                    }
                    PsiJavaCodeReferenceElement ref = ann.getNameReferenceElement();
                    if (ref == null || !psiManager.areElementsEquivalent(ref.resolve(), (PsiElement)annClass)) {
                        return null;
                    }
                    return (PsiModifierListOwner)owner;
                }
            });
            if (candidate == null || consumer2.process((Object)candidate)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Collection<PsiAnnotation> getAnnotationCandidates(final @NotNull PsiClass annClass, final @NotNull SearchScope useScope, final @NotNull Project project2) {
        return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiAnnotation>>(){

            public Collection<PsiAnnotation> compute() {
                if (useScope instanceof GlobalSearchScope) {
                    return JavaAnnotationIndex.getInstance().get(annClass.getName(), project2, (GlobalSearchScope)useScope);
                }
                ArrayList<PsiAnnotation> result2 = new ArrayList<PsiAnnotation>();
                for (PsiElement element : ((LocalSearchScope)useScope).getScope()) {
                    result2.addAll(PsiTreeUtil.findChildrenOfType((PsiElement)element, PsiAnnotation.class));
                }
                return result2;
            }
        });
    }

    public static boolean isInstanceof(PsiElement owner, @NotNull Class<? extends PsiModifierListOwner>[] types) {
        for (Class<? extends PsiModifierListOwner> type2 : types) {
            if (!type2.isInstance(owner)) continue;
            return true;
        }
        return false;
    }
}

