/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

class ConstructorReferencesSearchHelper {
    private final PsiManager myManager;

    ConstructorReferencesSearchHelper(@NotNull PsiManager manager) {
        this.myManager = manager;
    }

    boolean processConstructorReferences(@NotNull Processor<PsiReference> processor2, @NotNull PsiMethod constructor, @NotNull PsiClass containingClass, @NotNull SearchScope searchScope, @NotNull Project project2, boolean ignoreAccessScope, boolean isStrictSignatureSearch, @NotNull SearchRequestCollector collector) {
        boolean[] constructorCanBeCalledImplicitly = new boolean[1];
        boolean[] isEnum = new boolean[1];
        boolean[] isUnder18 = new boolean[1];
        DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> {
            PsiParameter[] parameters2 = constructor.getParameterList().getParameters();
            boolean bl = constructorCanBeCalledImplicitly[0] = parameters2.length == 0;
            if (!constructorCanBeCalledImplicitly[0]) {
                constructorCanBeCalledImplicitly[0] = parameters2.length == 1 && parameters2[0].isVarArgs();
            }
            isEnum[0] = containingClass.isEnum();
            isUnder18[0] = PsiUtil.getLanguageLevel((PsiElement)containingClass).isAtLeast(LanguageLevel.JDK_1_8);
            return null;
        });
        if (isEnum[0] && !ConstructorReferencesSearchHelper.processEnumReferences(processor2, constructor, project2, containingClass)) {
            return false;
        }
        PairProcessor processor1 = (reference, collector1) -> {
            PsiMethod constructor1;
            PsiElement parent = reference.getElement().getParent();
            if (parent instanceof PsiAnonymousClass) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiNewExpression && (constructor1 = ((PsiNewExpression)parent).resolveConstructor()) != null && (isStrictSignatureSearch ? this.myManager.areElementsEquivalent((PsiElement)constructor, (PsiElement)constructor1) : this.myManager.areElementsEquivalent((PsiElement)containingClass, (PsiElement)constructor1.getContainingClass()))) {
                return processor2.process(reference);
            }
            return true;
        };
        ReferencesSearch.searchOptimized((PsiElement)containingClass, (SearchScope)searchScope, (boolean)ignoreAccessScope, (SearchRequestCollector)collector, (boolean)true, (PairProcessor)processor1);
        if (isUnder18[0] && !ConstructorReferencesSearchHelper.process18MethodPointers(processor2, constructor, project2, containingClass, searchScope)) {
            return false;
        }
        if (!((Boolean)DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> this.processSuperOrThis(containingClass, constructor, constructorCanBeCalledImplicitly[0], searchScope, project2, isStrictSignatureSearch, "this", "super", processor2))).booleanValue()) {
            return false;
        }
        Processor processor22 = inheritor -> {
            PsiElement navigationElement = inheritor.getNavigationElement();
            if (navigationElement instanceof PsiClass) {
                return this.processSuperOrThis((PsiClass)navigationElement, constructor, constructorCanBeCalledImplicitly[0], searchScope, project2, isStrictSignatureSearch, "super", "this", processor2);
            }
            return true;
        };
        return ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)searchScope, (boolean)false).forEach(processor22);
    }

    private static boolean processEnumReferences(@NotNull Processor<PsiReference> processor2, @NotNull PsiMethod constructor, @NotNull Project project2, @NotNull PsiClass aClass) {
        return (Boolean)DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> {
            for (PsiField field : aClass.getFields()) {
                PsiReference reference;
                if (!(field instanceof PsiEnumConstant) || (reference = field.getReference()) == null || !reference.isReferenceTo((PsiElement)constructor) || processor2.process((Object)reference)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean process18MethodPointers(@NotNull Processor<PsiReference> processor2, @NotNull PsiMethod constructor, @NotNull Project project2, @NotNull PsiClass aClass, SearchScope searchScope) {
        return ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope).forEach(reference -> {
            PsiElement element = reference.getElement();
            if (element != null) {
                return (Boolean)DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> {
                    PsiElement parent = element.getParent();
                    if (parent instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)parent).getReferenceNameElement() instanceof PsiKeyword && ((PsiMethodReferenceExpression)parent).isReferenceTo((PsiElement)constructor) && !processor2.process((Object)((PsiReference)parent))) {
                        return false;
                    }
                    return true;
                });
            }
            return true;
        });
    }

    private boolean processSuperOrThis(@NotNull PsiClass inheritor, @NotNull PsiMethod constructor, boolean constructorCanBeCalledImplicitly, @NotNull SearchScope searchScope, @NotNull Project project2, boolean isStrictSignatureSearch, @NotNull String superOrThisKeyword, @NotNull String thisOrSuperKeyword, @NotNull Processor<PsiReference> processor2) {
        PsiMethod[] constructors = inheritor.getConstructors();
        if (constructors.length == 0 && constructorCanBeCalledImplicitly && !this.processImplicitConstructorCall((PsiMember)inheritor, processor2, constructor, project2, inheritor)) {
            return false;
        }
        for (PsiMethod method2 : constructors) {
            PsiReferenceExpression refExpr;
            PsiExpression expr;
            PsiStatement statement2;
            PsiCodeBlock body2 = method2.getBody();
            if (body2 == null || method2 == constructor && isStrictSignatureSearch) continue;
            PsiStatement[] statements = body2.getStatements();
            if (statements.length != 0 && (statement2 = statements[0]) instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement2).getExpression()) instanceof PsiMethodCallExpression && PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)(refExpr = ((PsiMethodCallExpression)expr).getMethodExpression()))) {
                if (refExpr.textMatches((CharSequence)superOrThisKeyword)) {
                    boolean match;
                    PsiElement referencedElement = refExpr.resolve();
                    if (!(referencedElement instanceof PsiMethod)) continue;
                    PsiMethod constructor1 = (PsiMethod)referencedElement;
                    boolean bl = match = isStrictSignatureSearch ? this.myManager.areElementsEquivalent((PsiElement)constructor1, (PsiElement)constructor) : this.myManager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)constructor1.getContainingClass());
                    if (!match || processor2.process((Object)refExpr)) continue;
                    return false;
                }
                if (refExpr.textMatches((CharSequence)thisOrSuperKeyword)) continue;
            }
            if (!constructorCanBeCalledImplicitly || !PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)method2) || this.processImplicitConstructorCall((PsiMember)method2, processor2, constructor, project2, inheritor)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitConstructorCall(final @NotNull PsiMember usage, @NotNull Processor<PsiReference> processor2, @NotNull PsiMethod constructor, @NotNull Project project2, @NotNull PsiClass containingClass) {
        if (containingClass instanceof PsiAnonymousClass) {
            return true;
        }
        PsiClass ctrClass = constructor.getContainingClass();
        if (ctrClass == null) {
            return true;
        }
        boolean isImplicitSuper = (Boolean)DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> this.myManager.areElementsEquivalent((PsiElement)ctrClass, (PsiElement)containingClass.getSuperClass()));
        if (!isImplicitSuper) {
            return true;
        }
        PsiElement resolved = JavaResolveUtil.resolveImaginarySuperCallInThisPlace(usage, project2, ctrClass);
        boolean resolvesToThisConstructor = (Boolean)DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> this.myManager.areElementsEquivalent((PsiElement)constructor, resolved));
        if (!resolvesToThisConstructor) {
            return true;
        }
        return processor2.process((Object)new LightMemberReference(this.myManager, usage, PsiSubstitutor.EMPTY){

            @Override
            public PsiElement getElement() {
                return usage;
            }

            @Override
            public TextRange getRangeInElement() {
                int startOffsetInParent;
                PsiElement identifier;
                if (usage instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)usage).getNameIdentifier()) != null && (startOffsetInParent = identifier.getStartOffsetInParent()) >= 0) {
                    return TextRange.from((int)startOffsetInParent, (int)identifier.getTextLength());
                }
                return super.getRangeInElement();
            }
        });
    }
}

