/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.search.IndexPatternOccurrenceImpl;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import gnu.trove.TIntArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class IndexPatternSearcher
implements QueryExecutor<IndexPatternOccurrence, IndexPatternSearch.SearchParameters> {
    private static final TokenSet COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT});

    public boolean execute(@NotNull IndexPatternSearch.SearchParameters queryParameters, @NotNull Processor<IndexPatternOccurrence> consumer2) {
        PsiFile file2 = queryParameters.getFile();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (file2 instanceof PsiBinaryFile || file2 instanceof PsiCompiledElement || virtualFile == null) {
            return true;
        }
        TodoCacheManager cacheManager = TodoCacheManager.SERVICE.getInstance(file2.getProject());
        IndexPatternProvider patternProvider = queryParameters.getPatternProvider();
        int count = patternProvider != null ? cacheManager.getTodoCount(virtualFile, patternProvider) : cacheManager.getTodoCount(virtualFile, queryParameters.getPattern());
        return count == 0 || IndexPatternSearcher.executeImpl(queryParameters, consumer2);
    }

    protected static boolean executeImpl(IndexPatternSearch.SearchParameters queryParameters, Processor<IndexPatternOccurrence> consumer2) {
        IndexPatternProvider patternProvider = queryParameters.getPatternProvider();
        PsiFile file2 = queryParameters.getFile();
        TIntArrayList commentStarts = new TIntArrayList();
        TIntArrayList commentEnds = new TIntArrayList();
        CharSequence chars = file2.getViewProvider().getContents();
        IndexPatternSearcher.findCommentTokenRanges(file2, chars, queryParameters.getRange(), commentStarts, commentEnds);
        TIntArrayList occurrences = new TIntArrayList(1);
        IndexPattern[] patterns = patternProvider != null ? patternProvider.getIndexPatterns() : null;
        for (int i = 0; i < commentStarts.size(); ++i) {
            int commentStart = commentStarts.get(i);
            int commentEnd = commentEnds.get(i);
            occurrences.resetQuick();
            if (patternProvider != null) {
                for (int j = patterns.length - 1; j >= 0; --j) {
                    if (IndexPatternSearcher.collectPatternMatches(patterns[j], chars, commentStart, commentEnd, file2, queryParameters.getRange(), consumer2, occurrences)) continue;
                    return false;
                }
                continue;
            }
            if (IndexPatternSearcher.collectPatternMatches(queryParameters.getPattern(), chars, commentStart, commentEnd, file2, queryParameters.getRange(), consumer2, occurrences)) continue;
            return false;
        }
        return true;
    }

    private static void findCommentTokenRanges(PsiFile file2, CharSequence chars, TextRange range, TIntArrayList commentStarts, TIntArrayList commentEnds) {
        if (file2 instanceof PsiPlainTextFile) {
            FileType fType = file2.getFileType();
            if (fType instanceof CustomSyntaxTableFileType) {
                Lexer lexer = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fType, (Project)file2.getProject(), (VirtualFile)file2.getVirtualFile()).getHighlightingLexer();
                IndexPatternSearcher.findComments(lexer, chars, range, COMMENT_TOKENS, commentStarts, commentEnds, null);
            } else {
                commentStarts.add(0);
                commentEnds.add(file2.getTextLength());
            }
        } else {
            FileViewProvider viewProvider = file2.getViewProvider();
            Set relevantLanguages = viewProvider.getLanguages();
            for (Language lang : relevantLanguages) {
                ParserDefinition parserDefinition;
                TIntArrayList commentStartsList = new TIntArrayList();
                TIntArrayList commentEndsList = new TIntArrayList();
                SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)lang, (Project)file2.getProject(), (VirtualFile)file2.getVirtualFile());
                Lexer lexer = syntaxHighlighter.getHighlightingLexer();
                TokenSet commentTokens = null;
                IndexPatternBuilder builderForFile = null;
                for (IndexPatternBuilder builder : (IndexPatternBuilder[])Extensions.getExtensions(IndexPatternBuilder.EP_NAME)) {
                    Lexer lexerFromBuilder = builder.getIndexingLexer(file2);
                    if (lexerFromBuilder == null) continue;
                    lexer = lexerFromBuilder;
                    commentTokens = builder.getCommentTokenSet(file2);
                    builderForFile = builder;
                }
                if (builderForFile == null && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) != null) {
                    commentTokens = parserDefinition.getCommentTokens();
                }
                if (commentTokens == null) continue;
                IndexPatternSearcher.findComments(lexer, chars, range, commentTokens, commentStartsList, commentEndsList, builderForFile);
                IndexPatternSearcher.mergeCommentLists(commentStarts, commentEnds, commentStartsList, commentEndsList);
            }
        }
    }

    private static void mergeCommentLists(TIntArrayList commentStarts, TIntArrayList commentEnds, TIntArrayList commentStartsList, TIntArrayList commentEndsList) {
        if (commentStarts.isEmpty() && commentEnds.isEmpty()) {
            commentStarts.add(commentStartsList.toNativeArray());
            commentEnds.add(commentEndsList.toNativeArray());
            return;
        }
        ContainerUtil.mergeSortedArrays((TIntArrayList)commentStarts, (TIntArrayList)commentEnds, (TIntArrayList)commentStartsList, (TIntArrayList)commentEndsList);
    }

    private static void findComments(Lexer lexer, CharSequence chars, TextRange range, TokenSet commentTokens, TIntArrayList commentStarts, TIntArrayList commentEnds, IndexPatternBuilder builderForFile) {
        IElementType tokenType;
        lexer.start(chars);
        while ((tokenType = lexer.getTokenType()) != null) {
            if (range != null) {
                if (lexer.getTokenEnd() > range.getStartOffset()) {
                    if (lexer.getTokenStart() >= range.getEndOffset()) break;
                }
            } else {
                boolean isComment;
                boolean bl = isComment = commentTokens.contains(tokenType) || CacheUtil.isInComments(tokenType);
                if (isComment) {
                    int startDelta = builderForFile != null ? builderForFile.getCommentStartDelta(lexer.getTokenType()) : 0;
                    int endDelta = builderForFile != null ? builderForFile.getCommentEndDelta(lexer.getTokenType()) : 0;
                    int start = lexer.getTokenStart() + startDelta;
                    int end = lexer.getTokenEnd() - endDelta;
                    assert (start <= end) : "Invalid comment range: " + new TextRange(start, end) + "; lexer token range=" + new TextRange(lexer.getTokenStart(), lexer.getTokenEnd()) + "; delta=" + new TextRange(startDelta, endDelta) + "; lexer=" + lexer + "; builder=" + builderForFile + "; chars length:" + chars.length();
                    assert (end <= chars.length()) : "Invalid comment end: " + new TextRange(start, end) + "; lexer token range=" + new TextRange(lexer.getTokenStart(), lexer.getTokenEnd()) + "; delta=" + new TextRange(startDelta, endDelta) + "; lexer=" + lexer + "; builder=" + builderForFile + "; chars length:" + chars.length();
                    commentStarts.add(start);
                    commentEnds.add(end);
                }
            }
            lexer.advance();
        }
    }

    private static boolean collectPatternMatches(IndexPattern indexPattern, CharSequence chars, int commentStart, int commentEnd, PsiFile file2, TextRange range, Processor<IndexPatternOccurrence> consumer2, TIntArrayList matches) {
        Pattern pattern = indexPattern.getPattern();
        if (pattern != null) {
            boolean found;
            ProgressManager.checkCanceled();
            CharSequenceSubSequence input = new CharSequenceSubSequence(chars, commentStart, commentEnd);
            Matcher matcher = pattern.matcher((CharSequence)input);
            while (found = matcher.find()) {
                int end;
                int start = matcher.start() + commentStart;
                if (start != (end = matcher.end() + commentStart) && (range == null || range.getStartOffset() <= start && end <= range.getEndOffset()) && matches.indexOf(start) == -1) {
                    matches.add(start);
                    if (!consumer2.process((Object)new IndexPatternOccurrenceImpl(file2, start, end, indexPattern))) {
                        return false;
                    }
                }
                ProgressManager.checkCanceled();
            }
        }
        return true;
    }
}

