/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.LazyConcurrentCollection;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.Predicate;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class JavaClassInheritorsSearcher
extends QueryExecutorBase<PsiClass, ClassInheritorsSearch.SearchParameters> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull ClassInheritorsSearch.SearchParameters parameters2, @NotNull Processor<PsiClass> consumer2) {
        PsiClass baseClass = parameters2.getClassToProcess();
        assert (parameters2.isCheckDeep());
        assert (parameters2.isCheckInheritance());
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress != null) {
            progress.pushState();
            String className = (String)ReadAction.compute(() -> ((PsiClass)baseClass).getName());
            progress.setText(className != null ? PsiBundle.message((String)"psi.search.inheritors.of.class.progress", (Object[])new Object[]{className}) : PsiBundle.message((String)"psi.search.inheritors.progress", (Object[])new Object[0]));
        }
        try {
            JavaClassInheritorsSearcher.processInheritors(parameters2, consumer2);
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
    }

    private static boolean processInheritors(@NotNull ClassInheritorsSearch.SearchParameters parameters2, @NotNull Processor<PsiClass> consumer2) {
        PsiClass baseClass = parameters2.getClassToProcess();
        if (baseClass instanceof PsiAnonymousClass || JavaClassInheritorsSearcher.isFinal(baseClass)) {
            return true;
        }
        SearchScope searchScope = parameters2.getScope();
        Project project2 = PsiUtilCore.getProjectInReadAction((PsiElement)baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            return AllClassesSearch.search((SearchScope)searchScope, (Project)project2, (Condition)parameters2.getNameCondition()).forEach(aClass -> {
                ProgressManager.checkCanceled();
                return JavaClassInheritorsSearcher.isJavaLangObject(aClass) || consumer2.process(aClass);
            });
        }
        if (searchScope instanceof LocalSearchScope) {
            return JavaClassInheritorsSearcher.processLocalScope(project2, parameters2, (LocalSearchScope)searchScope, baseClass, consumer2);
        }
        Iterable<PsiClass> cached = JavaClassInheritorsSearcher.getOrComputeSubClasses(project2, baseClass, searchScope);
        for (PsiClass subClass : cached) {
            ProgressManager.checkCanceled();
            if (subClass instanceof PsiAnonymousClass && !parameters2.isIncludeAnonymous() || !((Boolean)ReadAction.compute(() -> JavaClassInheritorsSearcher.checkCandidate(subClass, parameters2) && !consumer2.process((Object)subClass))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Iterable<PsiClass> getOrComputeSubClasses(@NotNull Project project2, @NotNull PsiClass baseClass, @NotNull SearchScope searchScopeForNonPhysical) {
        ConcurrentMap<PsiClass, Iterable<PsiClass>> map2 = HighlightingCaches.getInstance((Project)project2).ALL_SUB_CLASSES;
        LazyConcurrentCollection<PsiAnchor, PsiClass> cached = (LazyConcurrentCollection<PsiAnchor, PsiClass>)map2.get(baseClass);
        if (cached == null) {
            Function converter = anchor -> (PsiClass)ReadAction.compute(() -> (PsiClass)anchor.retrieve());
            Predicate applicableFilter = candidate -> !(candidate instanceof PsiAnonymousClass) && candidate != null && !candidate.hasModifierProperty("final");
            boolean isPhysical = (Boolean)ReadAction.compute(() -> ((PsiClass)baseClass).isPhysical());
            SearchScope scopeToUse = isPhysical ? GlobalSearchScope.allScope((Project)project2) : searchScopeForNonPhysical;
            LazyConcurrentCollection.MoreElementsGenerator generator = (candidate, processor2) -> DirectClassInheritorsSearch.search((PsiClass)candidate, (SearchScope)scopeToUse).forEach(subClass -> {
                ProgressManager.checkCanceled();
                PsiAnchor pointer = (PsiAnchor)ReadAction.compute(() -> PsiAnchor.create((PsiElement)subClass));
                processor2.consume((Object)pointer);
                return true;
            });
            PsiAnchor seed = (PsiAnchor)ReadAction.compute(() -> PsiAnchor.create((PsiElement)baseClass));
            LazyConcurrentCollection<PsiAnchor, PsiClass> computed = new LazyConcurrentCollection<PsiAnchor, PsiClass>(seed, converter, applicableFilter, generator);
            cached = isPhysical ? (Iterable)ConcurrencyUtil.cacheOrGet(map2, (Object)baseClass, computed) : computed;
        }
        return cached;
    }

    private static boolean processLocalScope(final @NotNull Project project2, final @NotNull ClassInheritorsSearch.SearchParameters parameters2, @NotNull LocalSearchScope searchScope, final @NotNull PsiClass baseClass, final @NotNull Processor<PsiClass> consumer2) {
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        final boolean[] success = new boolean[]{true};
        for (final VirtualFile virtualFile : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                    if (psiFile != null) {
                        psiFile.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                            public void visitClass(PsiClass candidate) {
                                ProgressManager.checkCanceled();
                                if (!success[0]) {
                                    return;
                                }
                                if (candidate.isInheritor(baseClass, true) && JavaClassInheritorsSearcher.checkCandidate(candidate, parameters2) && !consumer2.process((Object)candidate)) {
                                    success[0] = false;
                                    return;
                                }
                                super.visitClass(candidate);
                            }
                        });
                    }
                }
            });
        }
        return success[0];
    }

    private static boolean checkCandidate(@NotNull PsiClass candidate, @NotNull ClassInheritorsSearch.SearchParameters parameters2) {
        SearchScope searchScope = parameters2.getScope();
        ProgressManager.checkCanceled();
        if (!PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)candidate)) {
            return false;
        }
        if (candidate instanceof PsiAnonymousClass) {
            return true;
        }
        String name = candidate.getName();
        return name != null && parameters2.getNameCondition().value((Object)name);
    }

    static boolean isJavaLangObject(@NotNull PsiClass baseClass) {
        return (Boolean)ReadAction.compute(() -> baseClass.isValid() && "java.lang.Object".equals(baseClass.getQualifiedName()));
    }

    private static boolean isFinal(@NotNull PsiClass baseClass) {
        return (Boolean)ReadAction.compute(() -> baseClass.hasModifierProperty("final"));
    }
}

