/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaClassInheritorsSearcher;
import com.intellij.psi.impl.search.StubHierarchyInheritorSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters parameters2, @NotNull Processor<PsiClass> consumer2) {
        SearchScope useScope;
        SearchScope scope;
        PsiClass baseClass = parameters2.getClassToProcess();
        assert (parameters2.isCheckInheritance());
        Project project2 = PsiUtilCore.getProjectInReadAction((PsiElement)baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            SearchScope useScope2 = (SearchScope)ReadAction.compute(() -> ((PsiClass)baseClass).getUseScope());
            return AllClassesSearch.search((SearchScope)useScope2, (Project)project2).forEach(psiClass -> {
                ProgressManager.checkCanceled();
                if (psiClass.isInterface()) {
                    return consumer2.process(psiClass);
                }
                PsiClass superClass = psiClass.getSuperClass();
                return superClass == null || !JavaClassInheritorsSearcher.isJavaLangObject(superClass) || consumer2.process(psiClass);
            });
        }
        CompilerDirectHierarchyInfo info = JavaDirectInheritorsSearcher.performSearchUsingCompilerIndices(parameters2, parameters2.getScope(), project2);
        if (info == null) {
            scope = parameters2.getScope();
            useScope = (SearchScope)ReadAction.compute(() -> ((PsiClass)baseClass).getUseScope());
        } else {
            if (!JavaDirectInheritorsSearcher.processInheritorCandidates(info.getHierarchyChildren(), consumer2, parameters2.includeAnonymous())) {
                return false;
            }
            scope = (SearchScope)ReadAction.compute(() -> parameters2.getScope().intersectWith((SearchScope)info.getDirtyScope()));
            useScope = (SearchScope)ReadAction.compute(() -> baseClass.getUseScope().intersectWith((SearchScope)info.getDirtyScope()));
        }
        PsiClass[] cache2 = JavaDirectInheritorsSearcher.getOrCalculateDirectSubClasses(project2, baseClass, useScope);
        if (cache2.length == 0) {
            return true;
        }
        VirtualFile baseClassJarFile = null;
        int groupStart = 0;
        boolean sameJarClassFound = false;
        String currentFQN = null;
        boolean[] isOutOfScope = new boolean[cache2.length];
        for (int i = 0; i <= cache2.length; ++i) {
            String fqn;
            PsiClass subClass;
            ProgressManager.checkCanceled();
            PsiClass psiClass2 = subClass = i == cache2.length ? null : cache2[i];
            if (subClass instanceof PsiAnonymousClass && !parameters2.includeAnonymous()) {
                return true;
            }
            if (i != cache2.length && !JavaDirectInheritorsSearcher.isInScope(scope, subClass)) {
                isOutOfScope[i] = true;
                continue;
            }
            String string = fqn = i == cache2.length ? null : (String)ReadAction.compute(() -> ((PsiClass)subClass).getQualifiedName());
            if (currentFQN != null && Comparing.equal((String)fqn, (String)currentFQN)) {
                boolean fromSameJar;
                VirtualFile currentJarFile = JavaDirectInheritorsSearcher.getJarFile(subClass);
                if (baseClassJarFile == null) {
                    baseClassJarFile = JavaDirectInheritorsSearcher.getJarFile(baseClass);
                }
                if (!(fromSameJar = Comparing.equal((Object)currentJarFile, (Object)baseClassJarFile))) continue;
                if (!consumer2.process((Object)subClass)) {
                    return false;
                }
                sameJarClassFound = true;
                continue;
            }
            currentFQN = fqn;
            if (!sameJarClassFound) {
                for (int g = groupStart; g < i; ++g) {
                    PsiClass subClassCandidate;
                    ProgressManager.checkCanceled();
                    if (isOutOfScope[g] || consumer2.process((Object)(subClassCandidate = cache2[g]))) continue;
                    return false;
                }
            }
            groupStart = i;
            sameJarClassFound = false;
        }
        return true;
    }

    private static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiClass subClass) {
        return (Boolean)ReadAction.compute(() -> PsiSearchScopeUtil.isInScope((SearchScope)scope, (PsiElement)subClass));
    }

    @NotNull
    private static PsiClass[] getOrCalculateDirectSubClasses(@NotNull Project project2, @NotNull PsiClass baseClass, @NotNull SearchScope useScope) {
        ConcurrentMap<PsiClass, PsiClass[]> map2 = HighlightingCaches.getInstance((Project)project2).DIRECT_SUB_CLASSES;
        PsiClass[] cache2 = (PsiClass[])map2.get(baseClass);
        if (cache2 != null) {
            return cache2;
        }
        String baseClassName = (String)ReadAction.compute(() -> ((PsiClass)baseClass).getName());
        if (StringUtil.isEmpty((String)baseClassName)) {
            return PsiClass.EMPTY_ARRAY;
        }
        cache2 = JavaDirectInheritorsSearcher.calculateDirectSubClasses(project2, baseClass, baseClassName, useScope);
        if (((Boolean)ReadAction.compute(() -> ((PsiClass)baseClass).isPhysical())).booleanValue()) {
            cache2 = (PsiClass[])ConcurrencyUtil.cacheOrGet(map2, (Object)baseClass, (Object)cache2);
        }
        return cache2;
    }

    private static <T> boolean processConcurrentlyIfTooMany(@NotNull Collection<T> collection, @NotNull Processor<? super T> processor2) {
        int size = collection.size();
        if (size == 0) {
            return true;
        }
        if (size > 100) {
            return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<T>(collection), ProgressIndicatorProvider.getGlobalProgressIndicator(), true, processor2);
        }
        return ContainerUtil.process(collection, processor2);
    }

    @NotNull
    private static PsiClass[] calculateDirectSubClasses(@NotNull Project project2, @NotNull PsiClass baseClass, @NotNull String baseClassName, @NotNull SearchScope useScope) {
        DumbService dumbService = DumbService.getInstance((Project)project2);
        GlobalSearchScope globalUseScope = (GlobalSearchScope)dumbService.runReadActionInSmartMode(() -> StubHierarchyInheritorSearcher.restrictScope(GlobalSearchScopeUtil.toGlobalSearchScope(useScope, project2)));
        Collection candidates = (Collection)dumbService.runReadActionInSmartMode(() -> JavaSuperClassNameOccurenceIndex.getInstance().get(baseClassName, project2, globalUseScope));
        HashMap classesWithFqn = new HashMap();
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(candidates, arg_0 -> JavaDirectInheritorsSearcher.lambda$calculateDirectSubClasses$7(baseClass, (Map)classesWithFqn, arg_0));
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (Object value2 : classesWithFqn.values()) {
            if (value2 instanceof PsiClass) {
                result2.add((PsiClass)value2);
                continue;
            }
            List list = (List)value2;
            result2.addAll(list);
        }
        Collection anonymousCandidates = (Collection)dumbService.runReadActionInSmartMode(() -> JavaAnonymousClassBaseRefOccurenceIndex.getInstance().get(baseClassName, project2, globalUseScope));
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(anonymousCandidates, candidate -> {
            boolean isInheritor = (Boolean)dumbService.runReadActionInSmartMode(() -> candidate.isInheritor(baseClass, false));
            if (isInheritor) {
                List list = result2;
                synchronized (list) {
                    result2.add(candidate);
                }
            }
            return true;
        });
        boolean isEnum = (Boolean)ReadAction.compute(() -> ((PsiClass)baseClass).isEnum());
        if (isEnum) {
            PsiField[] fields;
            for (PsiField field : fields = (PsiField[])ReadAction.compute(() -> ((PsiClass)baseClass).getFields())) {
                ProgressManager.checkCanceled();
                if (!(field instanceof PsiEnumConstant)) continue;
                PsiEnumConstantInitializer initializingClass2 = (PsiEnumConstantInitializer)ReadAction.compute(() -> ((PsiEnumConstant)((PsiEnumConstant)field)).getInitializingClass());
                if (initializingClass2 == null) continue;
                result2.add(initializingClass2);
            }
        }
        return result2.isEmpty() ? PsiClass.EMPTY_ARRAY : result2.toArray(new PsiClass[result2.size()]);
    }

    private static VirtualFile getJarFile(@NotNull PsiClass aClass) {
        return (VirtualFile)ReadAction.compute(() -> PsiUtil.getJarFile((PsiElement)aClass));
    }

    private static CompilerDirectHierarchyInfo performSearchUsingCompilerIndices(@NotNull DirectClassInheritorsSearch.SearchParameters parameters2, @NotNull SearchScope useScope, @NotNull Project project2) {
        if (!(useScope instanceof GlobalSearchScope)) {
            return null;
        }
        SearchScope scope = parameters2.getScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return null;
        }
        PsiClass searchClass = (PsiClass)ReadAction.compute(() -> (PsiClass)PsiUtil.preferCompiledElement((PsiModifierListOwner)parameters2.getClassToProcess()));
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstance(project2);
        return compilerReferenceService.getDirectInheritors((PsiNamedElement)searchClass, (GlobalSearchScope)useScope, (GlobalSearchScope)scope, (FileType)JavaFileType.INSTANCE);
    }

    private static boolean processInheritorCandidates(@NotNull Stream<PsiElement> classStream, @NotNull Processor<PsiClass> consumer2, boolean acceptAnonymous) {
        if (!acceptAnonymous) {
            classStream = classStream.filter(c -> !(c instanceof PsiAnonymousClass));
        }
        return ContainerUtil.process(classStream.iterator(), e -> {
            ProgressManager.checkCanceled();
            PsiClass c = (PsiClass)e;
            return consumer2.process((Object)c);
        });
    }

    private static /* synthetic */ boolean lambda$calculateDirectSubClasses$7(@NotNull PsiClass baseClass, Map classesWithFqn, PsiReferenceList referenceList) {
        ProgressManager.checkCanceled();
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass candidate = (PsiClass)referenceList.getParent();
            boolean isInheritor = candidate.isInheritor(baseClass, false);
            if (isInheritor) {
                String fqn = candidate.getQualifiedName();
                Map map2 = classesWithFqn;
                synchronized (map2) {
                    Object value2 = classesWithFqn.get(fqn);
                    if (value2 == null) {
                        classesWithFqn.put(fqn, candidate);
                    } else if (value2 instanceof PsiClass) {
                        ArrayList<PsiClass> list = new ArrayList<PsiClass>();
                        list.add((PsiClass)value2);
                        list.add(candidate);
                        classesWithFqn.put(fqn, list);
                    } else {
                        List list = (List)value2;
                        list.add(candidate);
                    }
                }
            }
        });
        return true;
    }
}

