/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.search.JavaNullMethodArgumentIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNullMethodArgumentUtil {
    public static boolean hasNullArgument(@NotNull PsiMethod method2, int argumentIdx) {
        boolean[] result2 = new boolean[]{false};
        JavaNullMethodArgumentUtil.searchNullArgument(method2, argumentIdx, (Processor<PsiExpression>)((Processor)expression2 -> {
            result2[0] = true;
            return false;
        }));
        return result2[0];
    }

    public static void searchNullArgument(@NotNull PsiMethod method2, int argumentIdx, @NotNull Processor<PsiExpression> nullArgumentProcessor) {
        PsiParameter parameter = method2.getParameterList().getParameters()[argumentIdx];
        if (parameter.getType() instanceof PsiEllipsisType) {
            return;
        }
        GlobalSearchScope scope = JavaNullMethodArgumentUtil.findScopeWhereNullArgumentCanPass(method2, argumentIdx);
        if (scope == null) {
            return;
        }
        MethodReferencesSearch.search((PsiMethod)method2, (SearchScope)scope, (boolean)true).forEach(ref -> {
            PsiElement psi = ref.getElement();
            if (psi != null) {
                PsiExpression argument;
                PsiExpression[] arguments;
                PsiElement parent = psi.getParent();
                PsiExpressionList argumentList = null;
                if (parent instanceof PsiCallExpression) {
                    argumentList = ((PsiCallExpression)parent).getArgumentList();
                } else if (parent instanceof PsiAnonymousClass) {
                    argumentList = ((PsiAnonymousClass)parent).getArgumentList();
                }
                if (argumentList != null && argumentIdx < (arguments = argumentList.getExpressions()).length && (argument = arguments[argumentIdx]) instanceof PsiLiteralExpression && "null".equals(argument.getText())) {
                    return nullArgumentProcessor.process((Object)argument);
                }
            }
            return true;
        });
    }

    @Nullable
    private static GlobalSearchScope findScopeWhereNullArgumentCanPass(@NotNull PsiMethod method2, int parameterIndex) {
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor(new ArrayList());
        GlobalSearchScope searchScope = GlobalSearchScopeUtil.toGlobalSearchScope(method2.getUseScope(), method2.getProject());
        searchScope = searchScope.intersectWith(GlobalSearchScopesCore.projectProductionScope((Project)method2.getProject()));
        fileBasedIndex.getFilesWithKey(JavaNullMethodArgumentIndex.INDEX_ID, Collections.singleton(new JavaNullMethodArgumentIndex.MethodCallData(method2.getName(), parameterIndex)), (Processor)collector, searchScope);
        Collection candidateFiles = collector.getResults();
        return candidateFiles.isEmpty() ? null : GlobalSearchScope.filesScope((Project)method2.getProject(), (Collection)candidateFiles);
    }
}

