/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaOverridingMethodsSearcher
implements QueryExecutor<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull OverridingMethodsSearch.SearchParameters parameters2, @NotNull Processor<PsiMethod> consumer2) {
        PsiMethod method2 = parameters2.getMethod();
        Project project2 = (Project)ReadAction.compute(() -> ((PsiMethod)method2).getProject());
        SearchScope searchScope = parameters2.getScope();
        if (searchScope instanceof LocalSearchScope) {
            return JavaOverridingMethodsSearcher.processLocalScope((LocalSearchScope)searchScope, method2, project2, consumer2);
        }
        Iterable<PsiMethod> cached = HighlightingCaches.getInstance((Project)project2).OVERRIDING_METHODS.get(method2);
        if (cached == null) {
            cached = JavaOverridingMethodsSearcher.compute(method2, project2);
            if (((Boolean)ReadAction.compute(() -> ((PsiMethod)method2).isPhysical())).booleanValue()) {
                HighlightingCaches.getInstance((Project)project2).OVERRIDING_METHODS.put(method2, cached);
            }
        }
        for (PsiMethod subMethod : cached) {
            ProgressManager.checkCanceled();
            if (!((Boolean)ReadAction.compute(() -> PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)subMethod))).booleanValue() || consumer2.process((Object)subMethod) && parameters2.isCheckDeep()) continue;
            return false;
        }
        return true;
    }

    private static boolean processLocalScope(@NotNull LocalSearchScope searchScope, final @NotNull PsiMethod method2, final @NotNull Project project2, final @NotNull Processor<PsiMethod> consumer2) {
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        final PsiClass methodContainingClass = (PsiClass)ReadAction.compute(() -> ((PsiMethod)method2).getContainingClass());
        if (methodContainingClass == null) {
            return true;
        }
        final boolean[] success = new boolean[]{true};
        for (final VirtualFile virtualFile : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                    if (psiFile != null) {
                        psiFile.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                            public void visitClass(PsiClass candidate) {
                                PsiMethod overridingMethod;
                                ProgressManager.checkCanceled();
                                if (!success[0]) {
                                    return;
                                }
                                PsiMethod psiMethod = overridingMethod = candidate.isInheritor(methodContainingClass, true) ? JavaOverridingMethodsSearcher.findOverridingMethod(project2, candidate, method2, methodContainingClass) : null;
                                if (overridingMethod != null && !consumer2.process(overridingMethod)) {
                                    success[0] = false;
                                } else {
                                    super.visitClass(candidate);
                                }
                            }
                        });
                    }
                }
            });
        }
        return success[0];
    }

    @NotNull
    private static Iterable<PsiMethod> compute(@NotNull PsiMethod method2, @NotNull Project project2) {
        Application application = ApplicationManager.getApplication();
        PsiClass containingClass = (PsiClass)application.runReadAction(() -> ((PsiMethod)method2).getContainingClass());
        assert (containingClass != null);
        LinkedHashSet<PsiMethod> result2 = new LinkedHashSet<PsiMethod>();
        Processor inheritorsProcessor = inheritor -> {
            PsiMethod found = (PsiMethod)application.runReadAction(() -> JavaOverridingMethodsSearcher.findOverridingMethod(project2, inheritor, method2, containingClass));
            if (found != null) {
                result2.add(found);
            }
            return true;
        };
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project2);
        boolean success = ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)allScope, (boolean)true).forEach(inheritorsProcessor);
        assert (success);
        return result2;
    }

    @Nullable
    static PsiMethod findOverridingMethod(@NotNull Project project2, @NotNull PsiClass inheritor, @NotNull PsiMethod method2, @NotNull PsiClass methodContainingClass) {
        MethodSignature signature;
        PsiMethod derived;
        PsiClass superClass;
        PsiMethod found;
        String name = method2.getName();
        if (inheritor.findMethodsByName(name, false).length > 0 && (found = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)inheritor, (MethodSignature)JavaOverridingMethodsSearcher.getSuperSignature(inheritor, methodContainingClass, method2), (boolean)false)) != null && JavaOverridingMethodsSearcher.isAcceptable(project2, found, inheritor, method2, methodContainingClass)) {
            return found;
        }
        if (methodContainingClass.isInterface() && !inheritor.isInterface() && (superClass = inheritor.getSuperClass()) != null && !superClass.isInheritor(methodContainingClass, true) && superClass.findMethodsByName(name, true).length > 0 && (derived = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived((PsiClass)inheritor, (PsiClass)superClass, (MethodSignature)(signature = JavaOverridingMethodsSearcher.getSuperSignature(inheritor, methodContainingClass, method2)), (boolean)true)) != null && JavaOverridingMethodsSearcher.isAcceptable(project2, derived, inheritor, method2, methodContainingClass)) {
            return derived;
        }
        return null;
    }

    @NotNull
    private static MethodSignature getSuperSignature(PsiClass inheritor, @NotNull PsiClass parentClass, PsiMethod method2) {
        PsiSubstitutor substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)parentClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY, null);
        return method2.getSignature(substitutor != null ? substitutor : PsiSubstitutor.EMPTY);
    }

    private static boolean isAcceptable(@NotNull Project project2, @NotNull PsiMethod found, @NotNull PsiClass foundContainingClass, @NotNull PsiMethod method2, @NotNull PsiClass methodContainingClass) {
        return !found.hasModifierProperty("static") && (!method2.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance((Project)project2).arePackagesTheSame((PsiElement)methodContainingClass, (PsiElement)foundContainingClass));
    }
}

