/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSourceFilterScope
extends DelegatingGlobalSearchScope {
    @Nullable
    private final ProjectFileIndex myIndex;

    public JavaSourceFilterScope(@NotNull GlobalSearchScope delegate) {
        super(delegate);
        Project project2 = this.getProject();
        this.myIndex = project2 == null ? null : ProjectRootManager.getInstance((Project)project2).getFileIndex();
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (!super.contains(file2)) {
            return false;
        }
        if (this.myIndex == null) {
            return false;
        }
        if (JavaClassFileType.INSTANCE == file2.getFileType()) {
            return this.myIndex.isInLibraryClasses(file2);
        }
        return this.myIndex.isInSourceContent(file2) || this.myBaseScope.isForceSearchingInLibrarySources() && this.myIndex.isInLibrarySource(file2);
    }
}

