/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MethodDeepestSuperSearcher
implements QueryExecutor<PsiMethod, PsiMethod> {
    public boolean execute(@NotNull PsiMethod method2, @NotNull Processor<PsiMethod> consumer2) {
        return MethodDeepestSuperSearcher.processDeepestSuperMethods(method2, consumer2);
    }

    public static boolean processDeepestSuperMethods(@NotNull PsiMethod method2, @NotNull Processor<PsiMethod> consumer2) {
        THashSet methods = new THashSet();
        methods.add(method2);
        return MethodDeepestSuperSearcher.findDeepestSuperOrSelfSignature(method2, (Set<PsiMethod>)methods, null, consumer2);
    }

    private static boolean findDeepestSuperOrSelfSignature(final @NotNull PsiMethod method2, @NotNull Set<PsiMethod> set2, Set<PsiMethod> guard, @NotNull Processor<PsiMethod> processor2) {
        if (guard != null && !guard.add((PsiMethod)method2)) {
            return true;
        }
        PsiMethod[] supers = (PsiMethod[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod[]>(){

            public PsiMethod[] compute() {
                return method2.findSuperMethods();
            }
        });
        if (supers.length == 0 && set2.add(method2) && !processor2.process((Object)method2)) {
            return false;
        }
        for (PsiMethod superMethod : supers) {
            if (guard == null) {
                guard = new THashSet();
                guard.add(method2);
            }
            if (MethodDeepestSuperSearcher.findDeepestSuperOrSelfSignature(superMethod, set2, (Set<PsiMethod>)guard, processor2)) continue;
            return false;
        }
        return true;
    }
}

