/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodSuperSearcher
implements QueryExecutor<MethodSignatureBackedByPsiMethod, SuperMethodsSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.MethodSuperSearcher");

    public boolean execute(@NotNull SuperMethodsSearch.SearchParameters queryParameters, @NotNull Processor<MethodSignatureBackedByPsiMethod> consumer2) {
        PsiClass parentClass = queryParameters.getPsiClass();
        PsiMethod method2 = queryParameters.getMethod();
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            HierarchicalMethodSignature signature = method2.getHierarchicalMethodSignature();
            boolean checkBases = queryParameters.isCheckBases();
            boolean allowStaticMethod = queryParameters.isAllowStaticMethod();
            List supers = signature.getSuperSignatures();
            for (HierarchicalMethodSignature superSignature : supers) {
                if (!MethodSignatureUtil.isSubsignature((MethodSignature)superSignature, (MethodSignature)signature) || MethodSuperSearcher.addSuperMethods(superSignature, method2, parentClass, allowStaticMethod, checkBases, consumer2)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean addSuperMethods(HierarchicalMethodSignature signature, PsiMethod method2, PsiClass parentClass, boolean allowStaticMethod, boolean checkBases, Processor<MethodSignatureBackedByPsiMethod> consumer2) {
        PsiMethod signatureMethod = signature.getMethod();
        PsiClass hisClass = signatureMethod.getContainingClass();
        if ((parentClass == null || InheritanceUtil.isInheritorOrSelf((PsiClass)parentClass, (PsiClass)hisClass, (boolean)true)) && MethodSuperSearcher.isAcceptable(signatureMethod, method2, allowStaticMethod)) {
            if (parentClass != null && !parentClass.equals(hisClass) && !checkBases) {
                return true;
            }
            LOG.assertTrue(signatureMethod != method2, (Object)method2);
            return consumer2.process((Object)signature);
        }
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            if (!MethodSignatureUtil.isSubsignature((MethodSignature)superSignature, (MethodSignature)signature)) continue;
            MethodSuperSearcher.addSuperMethods(superSignature, method2, parentClass, allowStaticMethod, checkBases, consumer2);
        }
        return true;
    }

    private static boolean isAcceptable(PsiMethod superMethod, PsiMethod method2, boolean allowStaticMethod) {
        boolean hisStatic = superMethod.hasModifierProperty("static");
        return hisStatic == method2.hasModifierProperty("static") && (allowStaticMethod || !hisStatic) && JavaPsiFacade.getInstance((Project)method2.getProject()).getResolveHelper().isAccessible((PsiMember)superMethod, (PsiElement)method2, null);
    }
}

