/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.stubsHierarchy.ClassHierarchy;
import com.intellij.psi.stubsHierarchy.HierarchyService;
import com.intellij.psi.stubsHierarchy.SmartClassAnchor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class StubHierarchyInheritorSearcher
extends QueryExecutorBase<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.StubHierarchyInheritorSearcher");

    public StubHierarchyInheritorSearcher() {
        super(true);
    }

    private static boolean isSearching() {
        return Registry.is((String)"java.use.stub.hierarchy.in.inheritor.search");
    }

    @NotNull
    public static GlobalSearchScope restrictScope(@NotNull GlobalSearchScope scope) {
        if (!StubHierarchyInheritorSearcher.isSearching()) {
            return scope;
        }
        Project project2 = scope.getProject();
        return project2 == null ? scope : HierarchyService.getHierarchy(project2).restrictToUncovered(scope);
    }

    public void processQuery(@NotNull DirectClassInheritorsSearch.SearchParameters p, @NotNull Processor<PsiClass> consumer2) {
        if (!(p.getScope() instanceof GlobalSearchScope) || !StubHierarchyInheritorSearcher.isSearching()) {
            return;
        }
        PsiClass base = p.getClassToProcess();
        PsiElement original = base.getOriginalElement();
        if (original instanceof PsiClass) {
            base = (PsiClass)original;
        }
        GlobalSearchScope scope = (GlobalSearchScope)p.getScope();
        ClassHierarchy hierarchy = HierarchyService.getHierarchy(base.getProject());
        for (SmartClassAnchor anchor : hierarchy.getDirectSubtypeCandidates(base)) {
            if (!p.includeAnonymous() && hierarchy.isAnonymous(anchor) || StubHierarchyInheritorSearcher.processCandidate(consumer2, base, scope, hierarchy, anchor)) continue;
            return;
        }
    }

    private static boolean processCandidate(Processor<PsiClass> consumer2, PsiClass base, GlobalSearchScope scope, ClassHierarchy hierarchy, SmartClassAnchor anchor) {
        VirtualFile file2 = anchor.retrieveFile();
        if (!scope.contains(file2)) {
            return true;
        }
        PsiClass candidate = anchor.retrieveClass(base.getProject());
        if (!PsiSearchScopeUtil.isInScope((GlobalSearchScope)candidate.getResolveScope(), (PsiElement)base)) {
            return true;
        }
        if (hierarchy.hasAmbiguousSupers(anchor) && !candidate.isInheritor(base, false)) {
            return true;
        }
        return consumer2.process((Object)candidate);
    }
}

